/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Binary;
import org.modeshape.schematic.document.Code;
import org.modeshape.schematic.document.CodeWithScope;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.MaxKey;
import org.modeshape.schematic.document.MinKey;
import org.modeshape.schematic.document.Null;
import org.modeshape.schematic.document.ObjectId;
import org.modeshape.schematic.document.Symbol;
import org.modeshape.schematic.internal.document.ArrayEditor;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.BasicDocument;
import org.modeshape.schematic.internal.document.BsonUtils;
import org.modeshape.schematic.internal.document.DefaultDocumentValueFactory;
import org.modeshape.schematic.internal.document.DocumentValueFactory;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;
import org.modeshape.schematic.internal.document.Utility;

public class DocumentEditor
implements EditableDocument {
    private static final long serialVersionUID = 1L;
    private final MutableDocument document;
    protected final DocumentValueFactory factory;

    public DocumentEditor(MutableDocument document) {
        assert (document != null);
        this.document = document;
        this.factory = DefaultDocumentValueFactory.INSTANCE;
    }

    public DocumentEditor(MutableDocument document, DocumentValueFactory factory) {
        assert (document != null);
        this.document = document;
        this.factory = factory != null ? factory : DefaultDocumentValueFactory.INSTANCE;
    }

    @Override
    public DocumentEditor clone() {
        return new DocumentEditor(this.document.clone(), this.factory);
    }

    @Override
    public DocumentEditor with(Map<String, Object> changedFields) {
        return new DocumentEditor((MutableDocument)this.document.with(changedFields), this.factory);
    }

    @Override
    public Document with(String fieldName, Object value) {
        return new DocumentEditor((MutableDocument)this.document.with(fieldName, value), this.factory);
    }

    @Override
    public DocumentEditor with(Document.ValueTransformer transformer) {
        return new DocumentEditor((MutableDocument)this.document.with(transformer), this.factory);
    }

    @Override
    public Document withVariablesReplaced(Properties properties) {
        return new DocumentEditor((MutableDocument)this.document.withVariablesReplaced(properties), this.factory);
    }

    @Override
    public Document withVariablesReplacedWithSystemProperties() {
        return new DocumentEditor((MutableDocument)this.document.withVariablesReplacedWithSystemProperties(), this.factory);
    }

    @Override
    public Document unwrap() {
        return this.document;
    }

    @Override
    public MutableDocument asMutableDocument() {
        return this.document;
    }

    @Override
    public Object get(String name) {
        return this.document.get(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.document.getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.document.getBoolean(name, defaultValue);
    }

    public Object put(String name, Object value) {
        return this.doSetValue(name, value);
    }

    @Override
    public void putAll(Document object) {
        this.doSetAllValues(object);
    }

    public void putAll(Map<? extends String, ?> map) {
        this.doSetAllValues(map);
    }

    @Override
    public void merge(Document other) {
        if (other == this) {
            return;
        }
        for (Document.Field field : other.fields()) {
            Document otherDoc = field.getValueAsDocument();
            if (!Null.matches(otherDoc)) {
                EditableDocument thisField = this.getDocument(field.getName());
                if (!Null.matches(thisField)) {
                    thisField.merge(otherDoc);
                    continue;
                }
                this.doSetValue(field.getName(), otherDoc);
                continue;
            }
            this.doSetValue(field.getName(), field.getValue());
        }
    }

    @Override
    public Object remove(String name) {
        return this.document.remove(name);
    }

    @Override
    public Integer getInteger(String name) {
        return this.document.getInteger(name);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        return this.document.getInteger(name, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        return this.document.getLong(name);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return this.document.getLong(name, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        return this.document.getDouble(name);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        return this.document.getDouble(name, defaultValue);
    }

    @Override
    public Number getNumber(String name) {
        return this.document.getNumber(name);
    }

    @Override
    public Number getNumber(String name, Number defaultValue) {
        return this.document.getNumber(name, defaultValue);
    }

    @Override
    public Date getDate(String name) {
        return this.document.getDate(name);
    }

    @Override
    public String getString(String name) {
        return this.document.getString(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.document.getString(name, defaultValue);
    }

    @Override
    public EditableArray getArray(String name) {
        return this.editable(this.document.getArray(name), name);
    }

    @Override
    public EditableArray getOrCreateArray(String name) {
        List<?> existing = this.document.getArray(name);
        return existing != null ? this.editable(existing, name) : this.setArray(name);
    }

    @Override
    public EditableDocument getDocument(String name) {
        return this.editable(this.document.getDocument(name), name);
    }

    @Override
    public EditableDocument getOrCreateDocument(String name) {
        Document existing = this.document.getDocument(name);
        return existing != null ? this.editable(existing, name) : this.setDocument(name);
    }

    @Override
    public boolean isNull(String name) {
        return this.document.isNull(name);
    }

    @Override
    public boolean isNullOrMissing(String name) {
        return this.document.isNullOrMissing(name);
    }

    @Override
    public MaxKey getMaxKey(String name) {
        return this.document.getMaxKey(name);
    }

    @Override
    public MinKey getMinKey(String name) {
        return this.document.getMinKey(name);
    }

    @Override
    public Code getCode(String name) {
        return this.document.getCode(name);
    }

    @Override
    public CodeWithScope getCodeWithScope(String name) {
        return this.document.getCodeWithScope(name);
    }

    @Override
    public ObjectId getObjectId(String name) {
        return this.document.getObjectId(name);
    }

    @Override
    public Binary getBinary(String name) {
        return this.document.getBinary(name);
    }

    @Override
    public Symbol getSymbol(String name) {
        return this.document.getSymbol(name);
    }

    @Override
    public Pattern getPattern(String name) {
        return this.document.getPattern(name);
    }

    @Override
    public UUID getUuid(String name) {
        return this.document.getUuid(name);
    }

    @Override
    public UUID getUuid(String name, UUID defaultValue) {
        return this.document.getUuid(name, defaultValue);
    }

    @Override
    public int getType(String name) {
        return this.document.getType(name);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.document.toMap();
    }

    @Override
    public Iterable<Document.Field> fields() {
        return this.document.fields();
    }

    @Override
    public boolean containsField(String name) {
        return this.document.containsField(name);
    }

    @Override
    public boolean containsAll(Document document) {
        return this.document.containsAll(document);
    }

    @Override
    public Set<String> keySet() {
        return this.document.keySet();
    }

    @Override
    public int size() {
        return this.document.size();
    }

    @Override
    public boolean isEmpty() {
        return this.document.isEmpty();
    }

    @Override
    public void removeAll() {
        this.document.removeAll();
    }

    @Override
    public EditableDocument set(String name, Object value) {
        this.doSetValue(name, value);
        return this;
    }

    @Override
    public EditableDocument setBoolean(String name, boolean value) {
        this.doSetValue(name, this.factory.createBoolean(value));
        return this;
    }

    @Override
    public EditableDocument setNumber(String name, int value) {
        this.doSetValue(name, this.factory.createInt(value));
        return this;
    }

    @Override
    public EditableDocument setNumber(String name, long value) {
        this.doSetValue(name, this.factory.createLong(value));
        return this;
    }

    @Override
    public EditableDocument setNumber(String name, float value) {
        this.doSetValue(name, this.factory.createDouble(value));
        return this;
    }

    @Override
    public EditableDocument setNumber(String name, double value) {
        this.doSetValue(name, this.factory.createDouble(value));
        return this;
    }

    @Override
    public EditableDocument setString(String name, String value) {
        this.doSetValue(name, this.factory.createString(value));
        return this;
    }

    @Override
    public EditableDocument setSymbol(String name, String value) {
        this.doSetValue(name, this.factory.createSymbol(value));
        return this;
    }

    @Override
    public EditableDocument setDocument(String name) {
        BasicDocument doc = new BasicDocument();
        this.doSetValueIfAbsent(name, doc);
        return this.editable(doc, name);
    }

    @Override
    public EditableDocument setDocument(String name, Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).asMutableDocument();
        }
        this.doSetValue(name, document);
        return this.editable(document, name);
    }

    @Override
    public EditableArray setArray(String name) {
        BasicArray array = new BasicArray();
        this.doSetValueIfAbsent(name, array);
        return this.editable(array, name);
    }

    @Override
    public EditableArray setArray(String name, Array array) {
        if (array instanceof ArrayEditor) {
            array = ((ArrayEditor)array).unwrap();
        }
        this.doSetValue(name, array);
        return this.editable(array, name);
    }

    @Override
    public EditableArray setArray(String name, Object ... values) {
        BasicArray array = new BasicArray(values);
        this.doSetValue(name, array);
        return this.editable(array, name);
    }

    @Override
    public EditableDocument setDate(String name, Date value) {
        this.doSetValue(name, value);
        return this;
    }

    @Override
    public EditableDocument setDate(String name, String isoDate) throws ParseException {
        this.doSetValue(name, this.factory.createDate(isoDate));
        return this;
    }

    @Override
    public EditableDocument setTimestamp(String name, int timeInSeconds, int increment) {
        this.doSetValue(name, this.factory.createTimestamp(timeInSeconds, increment));
        return this;
    }

    @Override
    public EditableDocument setObjectId(String name, String hex) {
        this.doSetValue(name, this.factory.createObjectId(hex));
        return this;
    }

    @Override
    public EditableDocument setObjectId(String name, byte[] bytes) {
        this.doSetValue(name, this.factory.createObjectId(bytes));
        return this;
    }

    @Override
    public EditableDocument setObjectId(String name, int time, int machine, int process, int inc) {
        this.doSetValue(name, this.factory.createObjectId(time, machine, process, inc));
        return this;
    }

    @Override
    public EditableDocument setRegularExpression(String name, String pattern) {
        this.doSetValue(name, this.factory.createRegex(pattern, null));
        return this;
    }

    @Override
    public EditableDocument setRegularExpression(String name, String pattern, int flags) {
        this.doSetValue(name, this.factory.createRegex(pattern, BsonUtils.regexFlagsFor(flags)));
        return this;
    }

    @Override
    public EditableDocument setNull(String name) {
        this.doSetValue(name, this.factory.createNull());
        return this;
    }

    @Override
    public EditableDocument setBinary(String name, byte type, byte[] data) {
        this.doSetValue(name, this.factory.createBinary(type, data));
        return this;
    }

    @Override
    public EditableDocument setUuid(String name, UUID uuid) {
        this.doSetValue(name, uuid);
        return this;
    }

    @Override
    public EditableDocument setCode(String name, String code, boolean includeScope) {
        if (includeScope) {
            BasicDocument scope = new BasicDocument();
            this.doSetValue(name, this.factory.createCode(code, scope));
            return this.editable(scope, name);
        }
        this.doSetValue(name, this.factory.createCode(code));
        return this;
    }

    @Override
    public EditableDocument setCode(String name, String code, Document scope) {
        if (scope != null) {
            this.doSetValue(name, this.factory.createCode(code, scope));
            return this.editable(scope, name);
        }
        this.doSetValue(name, this.factory.createCode(code));
        return this;
    }

    protected Object doSetValue(String name, Object value) {
        value = value == null ? Null.getInstance() : Utility.unwrap(value);
        return this.document.put(name, value);
    }

    protected Object doSetValueIfAbsent(String name, Object value) {
        value = value == null ? Null.getInstance() : Utility.unwrap(value);
        return this.document.put(name, value);
    }

    protected void doSetAllValues(Document values) {
        if (values != null) {
            values = Utility.unwrap(values);
            this.document.putAll(values);
        }
    }

    protected void doSetAllValues(Map<? extends String, ?> values) {
        if (values != null) {
            this.document.putAll(Utility.unwrapValues(values));
        }
    }

    protected EditableDocument editable(Document doc, String fieldName) {
        if (doc == null) {
            return null;
        }
        assert (!(doc instanceof DocumentEditor)) : "The document value should not be a DocumentEditor instance";
        if (doc instanceof MutableArray) {
            return this.createEditableArray((MutableArray)doc, fieldName, this.factory);
        }
        assert (doc instanceof MutableDocument);
        return this.createEditableDocument((MutableDocument)doc, fieldName, this.factory);
    }

    protected EditableArray editable(List<?> array, String fieldName) {
        if (array == null) {
            return null;
        }
        assert (!(array instanceof ArrayEditor)) : "The array value should not be an ArrayEditor instance";
        return this.createEditableArray((BasicArray)array, fieldName, this.factory);
    }

    protected EditableDocument createEditableDocument(MutableDocument document, String fieldName, DocumentValueFactory factory) {
        return new DocumentEditor(document, factory);
    }

    protected EditableArray createEditableArray(MutableArray array, String fieldName, DocumentValueFactory factory) {
        return new ArrayEditor(array, factory);
    }

    public String toString() {
        return this.document.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MutableDocument) && !(o instanceof DocumentEditor)) {
            return false;
        }
        if (o instanceof MutableDocument) {
            return Objects.equals(this.document, o);
        }
        DocumentEditor that = (DocumentEditor)o;
        return Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(this.document);
    }
}

