/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.UUID;
import java.util.regex.Pattern;
import org.modeshape.schematic.annotation.Immutable;
import org.modeshape.schematic.document.Binary;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Json;

@Immutable
public class ImmutableField
implements Document.Field {
    private final String name;
    private final Object value;

    public ImmutableField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public int compareTo(Document.Field that) {
        return this == that ? 0 : this.name.compareTo(that.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Document.Field) {
            Document.Field that = (Document.Field)obj;
            if (!this.getName().equals(that.getName())) {
                return true;
            }
            return this.getValue() != null ? this.getValue().equals(that.getValue()) : that.getValue() == null;
        }
        return false;
    }

    public String toString() {
        return Json.write(this);
    }

    @Override
    public String getValueAsString() {
        Object value = this.getValue();
        return value != null && value instanceof String ? (String)value : null;
    }

    @Override
    public Integer getValueAsInt() {
        Object value = this.getValue();
        return value != null && value instanceof Integer ? (Integer)value : null;
    }

    @Override
    public boolean getValueAsBoolean() {
        Object value = this.getValue();
        return value != null && value instanceof Boolean ? (Boolean)value : false;
    }

    @Override
    public Binary getValueAsBinary() {
        Object value = this.getValue();
        return value != null && value instanceof Binary ? (Binary)value : null;
    }

    @Override
    public Document getValueAsDocument() {
        Object value = this.getValue();
        return value != null && value instanceof Document ? (Document)value : null;
    }

    @Override
    public Number getValueAsNumber() {
        Object value = this.getValue();
        return value != null && value instanceof Number ? (Number)((Number)value) : (Number)null;
    }

    @Override
    public Pattern getValueAsPattern() {
        Object value = this.getValue();
        return value != null && value instanceof Pattern ? (Pattern)value : null;
    }

    @Override
    public Double getValueAsDouble() {
        Object value = this.getValue();
        return value != null && value instanceof Double ? (Double)value : null;
    }

    @Override
    public UUID getValueAsUuid() {
        Object value = this.getValue();
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        return null;
    }
}

