/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.Collection;
import java.util.List;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.delta.AddValueIfAbsentOperation;
import org.modeshape.schematic.internal.delta.AddValueOperation;
import org.modeshape.schematic.internal.delta.ClearOperation;
import org.modeshape.schematic.internal.delta.DocumentObserver;
import org.modeshape.schematic.internal.delta.RemoveAllValuesOperation;
import org.modeshape.schematic.internal.delta.RemoveAtIndexOperation;
import org.modeshape.schematic.internal.delta.RemoveValueOperation;
import org.modeshape.schematic.internal.delta.RetainAllValuesOperation;
import org.modeshape.schematic.internal.delta.SetValueOperation;
import org.modeshape.schematic.internal.document.ArrayEditor;
import org.modeshape.schematic.internal.document.DocumentValueFactory;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;
import org.modeshape.schematic.internal.document.ObservableDocumentEditor;
import org.modeshape.schematic.internal.document.Utility;

public class ObservableArrayEditor
extends ArrayEditor {
    private static final long serialVersionUID = 1L;
    private final Path path;
    private final DocumentObserver observer;

    public ObservableArrayEditor(MutableArray array, Path path, DocumentObserver observer, DocumentValueFactory factory) {
        super(array, factory);
        this.path = path;
        this.observer = observer;
    }

    protected boolean doAddAll(Collection<?> c) {
        return this.doAddAll(this.size(), c);
    }

    @Override
    protected boolean doAddAll(int index, Collection<?> c) {
        if (super.doAddAll(index, c = Utility.unwrapValues(c))) {
            for (Object value : c) {
                value = Utility.unwrap(value);
                this.observer.addOperation(new AddValueOperation(this.path, value));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doAddValue(int index, Object value) {
        value = Utility.unwrap(value);
        super.doAddValue(index, value);
        this.observer.addOperation(new AddValueOperation(this.path, value, index));
    }

    @Override
    protected int doAddValue(Object value) {
        value = Utility.unwrap(value);
        int index = super.doAddValue(value);
        this.observer.addOperation(new AddValueOperation(this.path, value));
        return index;
    }

    @Override
    protected boolean doAddValueIfAbsent(Object value) {
        if (super.doAddValueIfAbsent(value = Utility.unwrap(value))) {
            this.observer.addOperation(new AddValueIfAbsentOperation(this.path, value));
            return true;
        }
        return false;
    }

    @Override
    protected void doClear() {
        super.doClear();
        this.observer.addOperation(new ClearOperation(this.path));
    }

    @Override
    protected List<Array.Entry> doRemoveAll(Collection<?> c) {
        c = Utility.unwrapValues(c);
        List<Array.Entry> removed = super.doRemoveAll(c);
        this.observer.addOperation(new RemoveAllValuesOperation(this.path, c));
        return removed;
    }

    @Override
    protected Object doRemoveValue(int index) {
        Object removed = super.doRemoveValue(index);
        if (removed != null) {
            this.observer.addOperation(new RemoveAtIndexOperation(this.path, index));
        }
        return removed;
    }

    @Override
    protected boolean doRemoveValue(Object value) {
        if (super.doRemoveValue(value = Utility.unwrap(value))) {
            this.observer.addOperation(new RemoveValueOperation(this.path, value));
        }
        return false;
    }

    @Override
    protected List<Array.Entry> doRetainAll(Collection<?> c) {
        c = Utility.unwrapValues(c);
        List<Array.Entry> removed = super.doRetainAll(c);
        this.observer.addOperation(new RetainAllValuesOperation(this.path, c));
        return removed;
    }

    @Override
    protected Object doSetValue(int index, Object value) {
        value = Utility.unwrap(value);
        Object oldValue = super.doSetValue(index, value);
        this.observer.addOperation(new SetValueOperation(this.path, value, index));
        return oldValue;
    }

    @Override
    protected EditableDocument createEditableDocument(MutableDocument document, int index, DocumentValueFactory factory) {
        return new ObservableDocumentEditor(document, this.path.with(Integer.toString(index)), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableArray(MutableArray array, int index, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path.with(Integer.toString(index)), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableSublist(MutableArray array, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path, this.observer, factory);
    }
}

