/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.EditableDocument;

public abstract class AbstractAddBinaryStorage
extends AbstractAddStepHandler {
    protected Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    protected AbstractAddBinaryStorage() {
    }

    static void populate(ModelNode operation, ModelNode model, AttributeDefinition[] attributes) throws OperationFailedException {
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        EditableDocument binaries = Schematic.newDocument();
        this.writeCommonBinaryStorageConfiguration(context, model, binaries);
        this.writeBinaryStorageConfiguration(repositoryName, context, model, binaries);
        boolean isNestedStore = model.hasDefined("store-name");
        ServiceName serviceName = ModeShapeServiceNames.binaryStorageDefaultServiceName(repositoryName);
        if (isNestedStore) {
            String binaryStorageName = binaries.getString("storeName");
            assert (binaryStorageName != null);
            serviceName = ModeShapeServiceNames.binaryStorageNestedServiceName(repositoryName, binaryStorageName);
        } else {
            context.removeService(serviceName);
        }
        this.createBinaryStorageService(context, model, target, repositoryName, binaries, serviceName);
    }

    protected void createBinaryStorageService(OperationContext context, ModelNode model, ServiceTarget target, String repositoryName, EditableDocument binaries, ServiceName serviceName) throws OperationFailedException {
        BinaryStorageService service = BinaryStorageService.createWithConfiguration(binaries);
        ServiceBuilder builder = target.addService(serviceName, (Service)service);
        String binariesStoreName = binaries.containsField("storeName") ? binaries.getString("storeName") : null;
        this.addControllersAndDependencies(repositoryName, service, (ServiceBuilder<BinaryStorage>)builder, target, binariesStoreName);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    protected abstract void writeBinaryStorageConfiguration(String var1, OperationContext var2, ModelNode var3, EditableDocument var4) throws OperationFailedException;

    protected void writeCommonBinaryStorageConfiguration(OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        ModelNode mimeTypeDetection;
        ModelNode storeName;
        ModelNode stringSize;
        ModelNode minBinarySize = ModelAttributes.MINIMUM_BINARY_SIZE.resolveModelAttribute(context, model);
        if (minBinarySize.isDefined()) {
            binaries.set("minimumBinarySizeInBytes", (Object)minBinarySize.asInt());
        }
        if ((stringSize = ModelAttributes.MINIMUM_STRING_SIZE.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("minimumStringSize", (Object)stringSize.asInt());
        }
        if ((storeName = ModelAttributes.STORE_NAME.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("storeName", (Object)storeName.asString());
        }
        if ((mimeTypeDetection = ModelAttributes.MIME_TYPE_DETECTION.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("mimeTypeDetection", (Object)mimeTypeDetection.asString());
        }
    }

    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, ServiceTarget target, String binariesStoreName) throws OperationFailedException {
    }
}

