/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.PersistenceService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.document.EditableDocument;

public class AddDatabasePersistence
extends AbstractAddStepHandler {
    public static final AddDatabasePersistence INSTANCE = new AddDatabasePersistence();

    private AddDatabasePersistence() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.PERSISTENCE_DB_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode poolSize;
        ModelNode compress;
        ModelNode jndi;
        ModelNode password;
        ModelNode username;
        ModelNode driver;
        ModelNode url;
        ModelNode fetchSize;
        ModelNode dropOnExit;
        ModelNode createOnStart;
        ServiceTarget target = context.getServiceTarget();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        String type = addressContext.lastPathElementValue();
        EditableDocument persistenceConfig = DocumentFactory.newDocument();
        persistenceConfig.setString("type", "db");
        ModelNode tableName = ModelAttributes.TABLE_NAME.resolveModelAttribute(context, operation);
        if (tableName.isDefined()) {
            persistenceConfig.setString(ModelAttributes.TABLE_NAME.getFieldName(), tableName.asString());
        }
        if ((createOnStart = ModelAttributes.CREATE_ON_START.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setBoolean(ModelAttributes.CREATE_ON_START.getFieldName(), createOnStart.asBoolean());
        }
        if ((dropOnExit = ModelAttributes.DROP_ON_EXIT.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setBoolean(ModelAttributes.DROP_ON_EXIT.getFieldName(), dropOnExit.asBoolean());
        }
        if ((fetchSize = ModelAttributes.FETCH_SIZE.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setNumber(ModelAttributes.FETCH_SIZE.getFieldName(), fetchSize.asInt());
        }
        if ((url = ModelAttributes.CONNECTION_URL.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setString(ModelAttributes.CONNECTION_URL.getFieldName(), url.asString());
        }
        if ((driver = ModelAttributes.DRIVER.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setString(ModelAttributes.DRIVER.getFieldName(), driver.asString());
        }
        if ((username = ModelAttributes.USERNAME.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setString(ModelAttributes.USERNAME.getFieldName(), username.asString());
        }
        if ((password = ModelAttributes.PASSWORD.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setString(ModelAttributes.PASSWORD.getFieldName(), password.asString());
        }
        if ((jndi = ModelAttributes.PERSISTENCE_DS_JNDI_NAME.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setString(ModelAttributes.PERSISTENCE_DS_JNDI_NAME.getFieldName(), jndi.asString());
        }
        if ((compress = ModelAttributes.DB_COMPRESS.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setBoolean(ModelAttributes.DB_COMPRESS.getFieldName(), compress.asBoolean());
        }
        if ((poolSize = ModelAttributes.POOL_SIZE.resolveModelAttribute(context, operation)).isDefined()) {
            persistenceConfig.setNumber(ModelAttributes.POOL_SIZE.getFieldName(), poolSize.asInt());
        }
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                persistenceConfig.set(property.getName(), (Object)property.getValue().asString());
            }
        }
        PersistenceService persistenceService = new PersistenceService(repositoryName, persistenceConfig);
        ServiceBuilder serviceBuilder = target.addService(ModeShapeServiceNames.persistenceDBServiceName(repositoryName, type), (Service)persistenceService);
        serviceBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, persistenceService.getModeShapeEngineInjector());
        serviceBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, persistenceService.getJcrRepositoryInjector());
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
    }
}

