/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.document.EditableDocument;

public class AddMongoBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddMongoBinaryStorage INSTANCE = new AddMongoBinaryStorage();

    private AddMongoBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        ModelNode hostAddressesNode;
        ModelNode passwordNode;
        ModelNode userNode;
        ModelNode portNode;
        binaries.set("type", (Object)"mongo");
        boolean singleHost = false;
        ModelNode hostNode = ModelAttributes.MONGO_HOST.resolveModelAttribute(context, model);
        if (hostNode.isDefined()) {
            binaries.setString("host", hostNode.asString());
            singleHost = true;
        }
        if ((portNode = ModelAttributes.MONGO_PORT.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setNumber("port", portNode.asInt());
        } else if (singleHost) {
            throw new OperationFailedException("The MongoDB port is required if the 'host' attribute is present");
        }
        ModelNode databaseNode = ModelAttributes.MONGO_DATABASE.resolveModelAttribute(context, model);
        if (databaseNode.isDefined()) {
            binaries.setString("database", databaseNode.asString());
        }
        if ((userNode = ModelAttributes.MONGO_USERNAME.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setString("username", userNode.asString());
        }
        if ((passwordNode = ModelAttributes.MONGO_PASSWORD.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setString("password", passwordNode.asString());
        }
        if ((hostAddressesNode = ModelAttributes.MONGO_HOST_ADDRESSES.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setArray("hostAddresses", (Object[])hostAddressesNode.asString().split(","));
        } else if (!singleHost) {
            throw new OperationFailedException("Either 'host' and 'port' OR 'host-addresses' have to be provided for the MongoDB binary store");
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddMongoBinaryStorage.populate(operation, model, ModelAttributes.MONGO_BINARY_STORAGE_ATTRIBUTES);
    }
}

