/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jboss.subsystem.MappedSimpleAttributeDefinition;

public class MappedListAttributeDefinition
extends SimpleListAttributeDefinition
implements MappedAttributeDefinition {
    private final List<String> pathToFieldInConfiguration;
    private final List<String> pathToContainerOfFieldInConfiguration;

    protected MappedListAttributeDefinition(SimpleListAttributeDefinition.Builder builder, SimpleAttributeDefinition valueType, List<String> pathToFieldInConfiguration) {
        super((ListAttributeDefinition.Builder)builder, (AttributeDefinition)valueType);
        assert (pathToFieldInConfiguration != null);
        assert (pathToFieldInConfiguration.size() > 0);
        this.pathToFieldInConfiguration = pathToFieldInConfiguration;
        this.pathToContainerOfFieldInConfiguration = this.pathToFieldInConfiguration.size() > 1 ? this.pathToFieldInConfiguration.subList(0, this.pathToFieldInConfiguration.size() - 1) : Collections.emptyList();
    }

    @Override
    public List<String> getPathToField() {
        return this.pathToFieldInConfiguration;
    }

    @Override
    public List<String> getPathToContainerOfField() {
        return this.pathToContainerOfFieldInConfiguration;
    }

    @Override
    public String getFieldName() {
        return this.pathToFieldInConfiguration.get(this.pathToFieldInConfiguration.size() - 1);
    }

    @Override
    public Object getTypedValue(ModelNode node) throws OperationFailedException {
        return MappedSimpleAttributeDefinition.getTypedValue(node, (AttributeDefinition)this);
    }

    public ModelNode getDefaultValue() {
        String[] segments;
        ModelNode listDefault = super.getDefaultValue();
        if (listDefault != null) {
            return listDefault;
        }
        ModelNode valueTypeDefault = this.getValueType().getDefaultValue();
        if (valueTypeDefault == null) {
            return null;
        }
        switch (valueTypeDefault.getType()) {
            case LIST: {
                return valueTypeDefault;
            }
        }
        ModelNode result = new ModelNode();
        for (String segment : segments = valueTypeDefault.asString().split(" ")) {
            result.add(segment);
        }
        return result;
    }

    public static class Builder {
        private final SimpleAttributeDefinition valueType;
        private final SimpleListAttributeDefinition.Builder builder;
        private List<String> configPath;

        protected Builder(String name, SimpleAttributeDefinition valueType) {
            this.valueType = valueType;
            this.builder = new SimpleListAttributeDefinition.Builder(name, (AttributeDefinition)valueType);
        }

        protected static Builder of(String name, SimpleAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        protected ListAttributeDefinition build() {
            if (this.configPath == null) {
                return this.builder.build();
            }
            return new MappedListAttributeDefinition(this.builder, this.valueType, this.configPath);
        }

        protected Builder setAllowNull(boolean allowNull) {
            this.builder.setAllowNull(allowNull);
            return this;
        }

        protected Builder setFlags(AttributeAccess.Flag ... flags) {
            this.builder.setFlags(flags);
            return this;
        }

        protected Builder setMaxSize(int maxSize) {
            this.builder.setMaxSize(maxSize);
            return this;
        }

        protected Builder setMinSize(int minSize) {
            this.builder.setMinSize(minSize);
            return this;
        }

        protected Builder setAllowExpression(boolean allowExpression) {
            this.builder.setAllowExpression(allowExpression);
            return this;
        }

        protected Builder setFieldPathInRepositoryConfiguration(String ... pathToField) {
            this.configPath = Collections.unmodifiableList(Arrays.asList(pathToField));
            return this;
        }

        protected Builder setAccessConstraints(AccessConstraintDefinition ... constraints) {
            this.builder.setAccessConstraints(constraints);
            return this;
        }
    }
}

