/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLReader_3_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.add("subsystem", "modeshape");
        subsystem.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(subsystem);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> repositories = new ArrayList<ModelNode>();
        ArrayList<ModelNode> webapps = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODESHAPE_3_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case REPOSITORY: {
                            this.parseRepository(reader, subsystem, repositories);
                            break block0;
                        }
                        case WEBAPP: {
                            this.parseWebApp(reader, subsystem, webapps);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        list.addAll(webapps);
        list.addAll(repositories);
    }

    private void parseWebApp(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> webapps) throws XMLStreamException {
        ModelNode webappAddress = address.clone();
        ModelNode webapp = Util.getEmptyOperation((String)"add", (ModelNode)webappAddress);
        String webappName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case NAME: {
                    webappName = attrValue;
                    webappAddress.add("webapp", webappName);
                    webappAddress.protect();
                    webapp.get("operation").set("add");
                    webapp.get("address").set(webappAddress);
                    webapps.add(webapp);
                    continue block4;
                }
                case EXPLODED: {
                    ModelAttributes.EXPLODED.parseAndSetParameter(attrValue, webapp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.requireNoElements(reader);
    }

    private void parseRepository(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> repositories) throws XMLStreamException {
        ModelNode repositoryAddress = address.clone();
        ModelNode repository = Util.getEmptyOperation((String)"add", (ModelNode)repositoryAddress);
        String repositoryName = null;
        if (reader.getAttributeCount() > 0) {
            block46: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        repositoryName = attrValue;
                        repositoryAddress.add("repository", attrValue);
                        repositoryAddress.protect();
                        repository.get("operation").set("add");
                        repository.get("address").set(repositoryAddress);
                        repositories.add(repository);
                        continue block46;
                    }
                    case JNDI_NAME: {
                        ModelAttributes.JNDI_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case ENABLE_MONITORING: {
                        ModelAttributes.ENABLE_MONITORING.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case CLUSTER_STACK: {
                        ModelAttributes.CLUSTER_STACK.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case CLUSTER_NAME: {
                        ModelAttributes.CLUSTER_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case CLUSTER_CONFIG: {
                        ModelAttributes.CLUSTER_CONFIG.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case CLUSTER_LOCKING: {
                        ModelAttributes.CLUSTER_LOCKING.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case SECURITY_DOMAIN: {
                        ModelAttributes.SECURITY_DOMAIN.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case ANONYMOUS_ROLES: {
                        for (String role : reader.getListAttributeValue(i)) {
                            repository.get("anonymous-roles").add(role);
                        }
                        continue block46;
                    }
                    case ANONYMOUS_USERNAME: {
                        ModelAttributes.ANONYMOUS_USERNAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case USE_ANONYMOUS_IF_AUTH_FAILED: {
                        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case GARBAGE_COLLECTION_THREAD_POOL: {
                        ModelAttributes.GARBAGE_COLLECTION_THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case GARBAGE_COLLECTION_INITIAL_TIME: {
                        ModelAttributes.GARBAGE_COLLECTION_INITIAL_TIME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case GARBAGE_COLLECTION_INTERVAL: {
                        ModelAttributes.GARBAGE_COLLECTION_INTERVAL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case DOCUMENT_OPTIMIZATION_THREAD_POOL: {
                        ModelAttributes.DOCUMENT_OPTIMIZATION_THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case DOCUMENT_OPTIMIZATION_INITIAL_TIME: {
                        ModelAttributes.DOCUMENT_OPTIMIZATION_INITIAL_TIME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case DOCUMENT_OPTIMIZATION_INTERVAL: {
                        ModelAttributes.DOCUMENT_OPTIMIZATION_INTERVAL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET: {
                        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE: {
                        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case EVENT_BUS_SIZE: {
                        ModelAttributes.EVENT_BUS_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case LOCK_TIMEOUT_MILLIS: {
                        ModelAttributes.LOCK_TIMEOUT_MILLIS.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    case REPOSITORY_MODULE_DEPENDENCIES: {
                        ModelAttributes.REPOSITORY_MODULE_DEPENDENCIES.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block46;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        ModelNode persistence = null;
        ModelNode binaryStorage = null;
        List<Object> sequencers = new ArrayList();
        List<Object> indexProviders = new ArrayList();
        List<Object> indexes = new ArrayList();
        List<Object> externalSources = new ArrayList();
        List<Object> textExtractors = new ArrayList();
        List<Object> authenticators = new ArrayList();
        List<Object> multipleStorageNodes = new ArrayList();
        block48: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DB_PERSISTENCE: {
                    persistence = this.parseDBPersistence(reader, repositoryName);
                    continue block48;
                }
                case FILE_PERSISTENCE: {
                    persistence = this.parseFilePersistence(reader, repositoryName);
                    continue block48;
                }
                case WORKSPACES: {
                    this.parseWorkspaces(reader, address, repository);
                    continue block48;
                }
                case JOURNALING: {
                    this.parseJournaling(reader, repository);
                    continue block48;
                }
                case NODE_TYPES: {
                    this.parseNodeTypes(reader, repository);
                    continue block48;
                }
                case TRANSIENT_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseTransientBinaryStorage(reader, repositoryName);
                    continue block48;
                }
                case FILE_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseFileBinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case DB_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseDatabaseBinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case CASSANDRA_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseCassandraBinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case MONGO_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseMongoBinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case S3_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseS3BinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case COMPOSITE_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    multipleStorageNodes = this.parseCompositeBinaryStorage(reader, repositoryName);
                    continue block48;
                }
                case CUSTOM_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseCustomBinaryStorage(reader, repositoryName, false);
                    continue block48;
                }
                case AUTHENTICATORS: {
                    authenticators = this.parseAuthenticators(reader, repositoryName);
                    continue block48;
                }
                case SEQUENCERS: {
                    sequencers = this.parseSequencers(reader, repository, address, repositoryName);
                    continue block48;
                }
                case INDEX_PROVIDERS: {
                    indexProviders = this.parseIndexProviders(reader, address, repositoryName);
                    continue block48;
                }
                case INDEXES: {
                    indexes = this.parseIndexes(reader, address, repositoryName);
                    continue block48;
                }
                case REINDEXIG: {
                    this.parseReindexing(reader, repository);
                    continue block48;
                }
                case EXTERNAL_SOURCES: {
                    externalSources = this.parseExternalSources(reader, address, repositoryName);
                    continue block48;
                }
                case TEXT_EXTRACTORS: {
                    textExtractors = this.parseTextExtracting(reader, repository, repositoryName);
                    continue block48;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (binaryStorage != null) {
            repositories.add(binaryStorage);
        }
        if (persistence != null) {
            repositories.add(persistence);
        }
        repositories.addAll(multipleStorageNodes);
        repositories.addAll(sequencers);
        repositories.addAll(indexProviders);
        repositories.addAll(indexes);
        repositories.addAll(externalSources);
        repositories.addAll(textExtractors);
        repositories.addAll(authenticators);
    }

    private ModelNode parseDBPersistence(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode persistence = new ModelNode();
        persistence.get("operation").set("add");
        if (reader.getAttributeCount() > 0) {
            block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case TABLE_NAME: {
                        ModelAttributes.TABLE_NAME.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case CREATE_ON_START: {
                        ModelAttributes.CREATE_ON_START.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case DROP_ON_EXIT: {
                        ModelAttributes.DROP_ON_EXIT.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case URL: {
                        ModelAttributes.CONNECTION_URL.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case USERNAME: {
                        ModelAttributes.USERNAME.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case PASSWORD: {
                        ModelAttributes.PASSWORD.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case DRIVER: {
                        ModelAttributes.DRIVER.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case FETCH_SIZE: {
                        ModelAttributes.FETCH_SIZE.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case COMPRESS: {
                        ModelAttributes.DB_COMPRESS.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case DATA_SOURCE_JNDI_NAME: {
                        ModelAttributes.PERSISTENCE_DS_JNDI_NAME.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case POOL_SIZE: {
                        ModelAttributes.POOL_SIZE.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        persistence.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        String dbPersistenceKey = Attribute.DB_PERSISTENCE.getLocalName();
        persistence.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add(dbPersistenceKey, dbPersistenceKey);
        this.requireNoElements(reader);
        return persistence;
    }

    private ModelNode parseFilePersistence(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode persistence = new ModelNode();
        persistence.get("operation").set("add");
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case PATH: {
                        ModelAttributes.FS_PATH.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case COMPRESS: {
                        ModelAttributes.FS_COMPRESS.parseAndSetParameter(attrValue, persistence, (XMLStreamReader)reader);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        String fsPersistenceKey = Attribute.FS_PERSISTENCE.getLocalName();
        persistence.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add(fsPersistenceKey, fsPersistenceKey);
        this.requireNoElements(reader);
        return persistence;
    }

    private void parseNodeTypes(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NODE_TYPE: {
                    repository.get("node-types").add(reader.getElementText());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void addBinaryStorageConfiguration(List<ModelNode> repositories, String repositoryName) {
        ModelNode configuration = new ModelNode();
        configuration.get("operation").set("add");
        configuration.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        repositories.add(configuration);
    }

    private void parseWorkspaces(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case ALLOW_WORKSPACE_CREATION: {
                        ModelAttributes.ALLOW_WORKSPACE_CREATION.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case DEFAULT_WORKSPACE: {
                        ModelAttributes.DEFAULT_WORKSPACE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case CACHE_SIZE: {
                        ModelAttributes.WORKSPACES_CACHE_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKSPACE: {
                    this.parseWorkspace(reader, repository);
                    continue block10;
                }
                case INITIAL_CONTENT: {
                    repository.get("default-initial-content").set(reader.getElementText());
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseReindexing(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case REINDEXING_ASNC: {
                        ModelAttributes.REINDEXING_ASYNC.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case REINDEXING_MODE: {
                        ModelAttributes.REINDEXING_MODE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
    }

    private void parseJournaling(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        repository.get(ModelAttributes.JOURNALING.getName()).set(true);
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case JOURNAL_ENABLED: {
                        ModelAttributes.JOURNAL_ENABLED.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case JOURNAL_PATH: {
                        ModelAttributes.JOURNAL_PATH.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case JOURNAL_RELATIVE_TO: {
                        ModelAttributes.JOURNAL_RELATIVE_TO.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MAX_DAYS_TO_KEEP_RECORDS: {
                        ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case ASYNC_WRITES: {
                        ModelAttributes.ASYNC_WRITES.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case JOURNAL_GC_THREAD_POOL: {
                        ModelAttributes.JOURNAL_GC_THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case JOURNAL_GC_INITIAL_TIME: {
                        ModelAttributes.JOURNAL_GC_INITIAL_TIME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
    }

    private void parseWorkspace(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        String workspaceName = null;
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        workspaceName = attrValue;
                        repository.get("predefined-workspace-names").add(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INITIAL_CONTENT: {
                    if (workspaceName == null) continue block7;
                    repository.get("workspaces-initial-content").add(workspaceName, reader.getElementText());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseFileBinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        String storeName = null;
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case PATH: {
                        ModelAttributes.PATH.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case TRASH: {
                        ModelAttributes.TRASH.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case STORE_NAME: {
                        if (nested) {
                            storeName = attrValue.trim();
                            ModelAttributes.STORE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                            continue block9;
                        }
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        if (nested) {
            storageType.get("address").add("storage-type", "composite-binary-storage").add("nested-storage-type-file", storeName);
        } else {
            storageType.get("address").add("storage-type", "file-binary-storage");
        }
        return storageType;
    }

    private ModelNode parseTransientBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storageType.get("address").add("storage-type", "transient-binary-storage");
        return storageType;
    }

    private ModelNode parseDatabaseBinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        String storeName = null;
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case DATA_SOURCE_JNDI_NAME: {
                        ModelAttributes.DATA_SOURCE_JNDI_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case STORE_NAME: {
                        if (nested) {
                            storeName = attrValue.trim();
                            ModelAttributes.STORE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                            continue block7;
                        }
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        if (nested) {
            storageType.get("address").add("storage-type", "composite-binary-storage").add("nested-storage-type-db", storeName);
        } else {
            storageType.get("address").add("storage-type", "db-binary-storage");
        }
        return storageType;
    }

    private ModelNode parseCassandraBinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case HOST: {
                        ModelAttributes.CASSANDRA_HOST.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storageType.get("address").add("storage-type", "cassandra-binary-storage");
        return storageType;
    }

    private ModelNode parseMongoBinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        if (reader.getAttributeCount() > 0) {
            block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case HOST: {
                        ModelAttributes.MONGO_HOST.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case PORT: {
                        ModelAttributes.MONGO_PORT.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case DATABASE: {
                        ModelAttributes.MONGO_DATABASE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case USERNAME: {
                        ModelAttributes.MONGO_USERNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case PASSWORD: {
                        ModelAttributes.MONGO_PASSWORD.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case HOST_ADDRESSES: {
                        ModelAttributes.MONGO_HOST_ADDRESSES.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storageType.get("address").add("storage-type", "mongo-binary-storage");
        return storageType;
    }

    private ModelNode parseS3BinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case BUCKET_NAME: {
                        ModelAttributes.S3_BUCKET_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case USERNAME: {
                        ModelAttributes.S3_USERNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case PASSWORD: {
                        ModelAttributes.S3_PASSWORD.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case ENDPOINT_URL: {
                        ModelAttributes.S3_ENDPOINT_URL.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storageType.get("address").add("storage-type", "s3-binary-storage");
        return storageType;
    }

    private ModelNode parseCustomBinaryStorage(XMLExtendedStreamReader reader, String repositoryName, boolean nested) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        String storeName = null;
        if (reader.getAttributeCount() > 0) {
            block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case STORE_NAME: {
                        if (nested) {
                            storeName = attrValue.trim();
                            ModelAttributes.STORE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                            continue block8;
                        }
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        if (nested) {
            storageType.get("address").add("storage-type", "composite-binary-storage").add("nested-storage-type-custom", storeName);
        } else {
            storageType.get("address").add("storage-type", "custom-binary-storage");
        }
        return storageType;
    }

    private List<ModelNode> parseCompositeBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ArrayList<ModelNode> stores = new ArrayList<ModelNode>();
        ModelNode compositeBinaryStorage = new ModelNode();
        compositeBinaryStorage.get("operation").set("add");
        compositeBinaryStorage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage").add("storage-type", "composite-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, compositeBinaryStorage, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, compositeBinaryStorage, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MIME_TYPE_DETECTION: {
                        ModelAttributes.MIME_TYPE_DETECTION.parseAndSetParameter(attrValue, compositeBinaryStorage, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case STORE_NAME: {
                        ModelAttributes.STORE_NAME.parseAndSetParameter(attrValue, compositeBinaryStorage, (XMLStreamReader)reader);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        stores.add(compositeBinaryStorage);
        ArrayList<String> storeNames = new ArrayList<String>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ModelNode nestedBinaryStore;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FILE_BINARY_STORAGE: {
                    nestedBinaryStore = this.parseFileBinaryStorage(reader, repositoryName, true);
                    break;
                }
                case DB_BINARY_STORAGE: {
                    nestedBinaryStore = this.parseDatabaseBinaryStorage(reader, repositoryName, true);
                    break;
                }
                case CUSTOM_BINARY_STORAGE: {
                    nestedBinaryStore = this.parseCustomBinaryStorage(reader, repositoryName, true);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            String storeName = nestedBinaryStore.get("store-name").asString();
            if (storeNames.contains(storeName)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)("store-name=" + storeName));
            }
            storeNames.add(storeName);
            stores.add(nestedBinaryStore);
            ModelAttributes.NESTED_STORES.parseAndAddParameterElement(storeName, compositeBinaryStorage, (XMLStreamReader)reader);
        }
        return stores;
    }

    private List<ModelNode> parseAuthenticators(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> authenticators = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATOR: {
                    this.parseAuthenticator(reader, repositoryName, authenticators);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return authenticators;
    }

    private void parseAuthenticator(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> authenticators) throws XMLStreamException {
        ModelNode authenticator = new ModelNode();
        authenticator.get("operation").set("add");
        String name = null;
        authenticators.add(authenticator);
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case CLASSNAME: {
                        ModelAttributes.AUTHENTICATOR_CLASSNAME.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        if (name != null) continue block5;
                        name = attrValue;
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        authenticator.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        authenticator.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("authenticator", name);
        this.requireNoElements(reader);
    }

    private List<ModelNode> parseSequencers(XMLExtendedStreamReader reader, ModelNode repository, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case THREAD_POOL_NAME: {
                        ModelAttributes.SEQUENCER_THREAD_POOL_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MAX_POOL_SIZE: {
                        ModelAttributes.SEQUENCER_MAX_POOL_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        ArrayList<ModelNode> sequencers = new ArrayList<ModelNode>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SEQUENCER: {
                    this.parseSequencer(reader, repositoryName, sequencers);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return sequencers;
    }

    private void parseSequencer(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> sequencers) throws XMLStreamException {
        ModelNode sequencer = new ModelNode();
        sequencer.get("operation").set("add");
        String name = null;
        sequencers.add(sequencer);
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block9;
                    }
                    case PATH_EXPRESSION: {
                        ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case CLASSNAME: {
                        ModelAttributes.SEQUENCER_CLASSNAME.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        if (name != null) continue block9;
                        name = attrValue;
                        continue block9;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        sequencer.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATH_EXPRESSION: {
                    String value = reader.getElementText();
                    ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(value, sequencer, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        sequencer.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("sequencer", name);
    }

    private List<ModelNode> parseIndexProviders(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> providers = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INDEX_PROVIDER: {
                    this.parseIndexProvider(reader, repositoryName, providers);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return providers;
    }

    private void parseIndexProvider(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> providers) throws XMLStreamException {
        ModelNode provider = new ModelNode();
        provider.get("operation").set("add");
        String name = null;
        providers.add(provider);
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, provider, (XMLStreamReader)reader);
                        if (name != null) continue block7;
                        name = attrValue;
                        continue block7;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, provider, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, provider, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case PATH: {
                        ModelAttributes.PATH.parseAndSetParameter(attrValue, provider, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        provider.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        provider.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index-provider", name);
        this.requireNoElements(reader);
    }

    private List<ModelNode> parseIndexes(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> indexes = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INDEX: {
                    this.parseIndex(reader, repositoryName, indexes);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return indexes;
    }

    private void parseIndex(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> indexes) throws XMLStreamException {
        ModelNode index = new ModelNode();
        index.get("operation").set("add");
        String name = null;
        indexes.add(index);
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block9;
                    }
                    case PROVIDER_NAME: {
                        ModelAttributes.PROVIDER_NAME.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case INDEX_KIND: {
                        ModelAttributes.INDEX_KIND.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case SYNCHRONOUS: {
                        ModelAttributes.SYNCHRONOUS.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case NODE_TYPE: {
                        ModelAttributes.NODE_TYPE_NAME.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case COLUMNS: {
                        ModelAttributes.INDEX_COLUMNS.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case WORKSPACES: {
                        ModelAttributes.WORKSPACES.parseAndSetParameter(attrValue, index, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        index.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index", name);
        this.requireNoElements(reader);
    }

    private List<ModelNode> parseExternalSources(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> externalSources = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOURCE: {
                    this.parseExternalSource(reader, repositoryName, externalSources);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return externalSources;
    }

    private void parseExternalSource(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> externalSources) throws XMLStreamException {
        ModelNode externalSource = new ModelNode();
        externalSource.get("operation").set("add");
        String name = null;
        externalSources.add(externalSource);
        if (reader.getAttributeCount() > 0) {
            block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block12;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CONNECTOR_CLASSNAME.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        if (name != null) continue block12;
                        name = attrValue;
                        continue block12;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case CACHEABLE: {
                        ModelAttributes.CACHEABLE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case QUERYABLE: {
                        ModelAttributes.QUERYABLE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case READONLY: {
                        ModelAttributes.READONLY.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case EXPOSE_AS_WORKSPACE: {
                        ModelAttributes.EXPOSE_AS_WORKSPACE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block12;
                    }
                    default: {
                        if (!attrValue.startsWith("$")) {
                            externalSource.get("properties").add(attrName, attrValue);
                            continue block12;
                        }
                        externalSource.get("properties").add(attrName, new ValueExpression(attrValue));
                    }
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROJECTION: {
                    String value = reader.getElementText();
                    ModelAttributes.PROJECTIONS.parseAndAddParameterElement(value, externalSource, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        externalSource.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("source", name);
    }

    private List<ModelNode> parseTextExtracting(XMLExtendedStreamReader reader, ModelNode repository, String repositoryName) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case THREAD_POOL_NAME: {
                        ModelAttributes.TEXT_EXTRACTOR_THREAD_POOL_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MAX_POOL_SIZE: {
                        ModelAttributes.TEXT_EXTRACTOR_MAX_POOL_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        ArrayList<ModelNode> extractors = new ArrayList<ModelNode>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TEXT_EXTRACTOR: {
                    this.parseTextExtractor(reader, repositoryName, extractors);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return extractors;
    }

    private void parseTextExtractor(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> extractors) throws XMLStreamException {
        ModelNode extractor = new ModelNode();
        extractor.get("operation").set("add");
        String name = null;
        extractors.add(extractor);
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case CLASSNAME: {
                        ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.parseAndSetParameter(attrValue, extractor, (XMLStreamReader)reader);
                        if (name != null) continue block5;
                        name = attrValue;
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, extractor, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        extractor.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        extractor.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("text-extractor", name);
        this.requireNoElements(reader);
    }

    protected void requireNoElements(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

