/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class StringSetValidator
extends ModelTypeValidator {
    private final Set<String> allowedValues = new HashSet<String>();

    protected StringSetValidator(boolean nullable, boolean strictType, String ... allowedValues) {
        super(ModelType.STRING, nullable, false, strictType);
        for (String allowedValue : allowedValues) {
            this.allowedValues.add(allowedValue.toLowerCase());
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (!value.isDefined()) {
            assert (this.nullable);
            return;
        }
        String string = value.asString();
        if (!this.allowedValues.contains(string.toLowerCase())) {
            throw new OperationFailedException("Invalid value '" + string + "' for attribute '" + parameterName + "'. Expected values: " + this.allowedValues);
        }
    }
}

