/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryEnvironment;
import org.modeshape.jcr.TimeoutException;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.AllPathsCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.WrappedException;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.BucketId;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCaches;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.binary.AbstractBinary;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;

@ThreadSafe
public class WritableSessionCache
extends AbstractSessionCache {
    private static final AtomicInteger SAVE_NUMBER = new AtomicInteger(1);
    private static final int MAX_SAVE_NUMBER = 100;
    private static final Logger SAVE_LOGGER = Logger.getLogger((String)"org.modeshape.jcr.txn");
    private static final NodeKey REMOVED_KEY = new NodeKey("REMOVED_NODE_SHOULD_NEVER_BE_PERSISTED");
    private static final SessionNode REMOVED = new SessionNode(REMOVED_KEY, false);
    private static final int MAX_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 4;
    private static final long PAUSE_TIME_BEFORE_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 50L;
    private static final ConcurrentHashMap<String, Map<String, Transactions.TransactionFunction>> COMPLETE_FUNCTION_BY_TX_AND_WS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Set<String>> LOCKED_KEYS_BY_TX_ID = new ConcurrentHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Transactions txns;
    private final RepositoryEnvironment repositoryEnvironment;
    private final TransactionalWorkspaceCaches txWorkspaceCaches;
    private Map<NodeKey, SessionNode> changedNodes = new HashMap<NodeKey, SessionNode>();
    private Set<NodeKey> replacedNodes;
    private LinkedHashSet<NodeKey> changedNodesInOrder = new LinkedHashSet();
    private Map<NodeKey, SessionNode.ReferrerChanges> referrerChangesForRemovedNodes = new HashMap<NodeKey, SessionNode.ReferrerChanges>();
    private final ConcurrentHashMap<NodeKey, Set<BinaryKey>> binaryReferencesByNodeKey = new ConcurrentHashMap();

    public WritableSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, TransactionalWorkspaceCaches txWorkspaceCaches, RepositoryEnvironment repositoryEnvironment) {
        super(context, workspaceCache);
        assert (repositoryEnvironment != null);
        this.txns = repositoryEnvironment.getTransactions();
        this.repositoryEnvironment = repositoryEnvironment;
        assert (txWorkspaceCaches != null);
        this.txWorkspaceCaches = txWorkspaceCaches;
        try {
            this.checkForTransaction();
        }
        catch (SystemException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    protected final void assertInSession(SessionNode node) {
        assert (this.changedNodes.get(node.getKey()) == node) : "Node " + node.getKey() + " is not in this session";
    }

    protected NodeTypes nodeTypes() {
        RepositoryEnvironment repositoryEnvironment = this.workspaceCache().repositoryEnvironment();
        if (repositoryEnvironment != null) {
            return repositoryEnvironment.nodeTypes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedNode getNode(NodeKey key) {
        CachedNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == REMOVED) {
            return null;
        }
        return sessionNode != null ? sessionNode : super.getNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SessionNode mutable(NodeKey key) {
        SessionNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == null || sessionNode == REMOVED) {
            sessionNode = new SessionNode(key, false);
            lock = this.lock.writeLock();
            try {
                lock.lock();
                sessionNode = this.changedNodes.get(key);
                if (sessionNode != null) return sessionNode;
                sessionNode = new SessionNode(key, false);
                this.changedNodes.put(key, sessionNode);
                this.changedNodesInOrder.add(key);
                return sessionNode;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (this.changedNodesInOrder.contains(key)) return sessionNode;
            this.changedNodesInOrder.add(key);
        }
        return sessionNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected void doClear() {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.referrerChangesForRemovedNodes.clear();
            this.changedNodes.clear();
            this.changedNodesInOrder.clear();
            this.referrerChangesForRemovedNodes.clear();
            this.binaryReferencesByNodeKey.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear(CachedNode node) {
        Path nodePath = node.getPath(this);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            List<SessionNode> nodesToRemoveInOrder = this.getChangedNodesAtOrBelowChildrenFirst(nodePath);
            for (SessionNode nodeToRemove : nodesToRemoveInOrder) {
                NodeKey key = nodeToRemove.getKey();
                this.changedNodes.remove(key);
                this.changedNodesInOrder.remove(key);
            }
            NodeKey key = node.getKey();
            this.referrerChangesForRemovedNodes.remove(key);
            this.binaryReferencesByNodeKey.remove(key);
        }
        finally {
            lock.unlock();
        }
    }

    private List<SessionNode> getChangedNodesAtOrBelowChildrenFirst(Path nodePath) {
        ArrayList<SessionNode> changedNodesChildrenFirst = new ArrayList<SessionNode>();
        for (NodeKey key : this.changedNodes.keySet()) {
            SessionNode changedNode = this.changedNodes.get(key);
            boolean isAtOrBelow = false;
            try {
                isAtOrBelow = changedNode.isAtOrBelow(this, nodePath);
            }
            catch (NodeNotFoundException e) {
                isAtOrBelow = false;
            }
            if (!isAtOrBelow) continue;
            int insertIndex = changedNodesChildrenFirst.size();
            Path changedNodePath = changedNode.getPath(this);
            for (int i = 0; i < changedNodesChildrenFirst.size(); ++i) {
                if (!((SessionNode)changedNodesChildrenFirst.get(i)).getPath(this).isAncestorOf(changedNodePath)) continue;
                insertIndex = i;
                break;
            }
            changedNodesChildrenFirst.add(insertIndex, changedNode);
        }
        return changedNodesChildrenFirst;
    }

    @Override
    public Set<NodeKey> getChangedNodeKeys() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<NodeKey> hashSet = new HashSet<NodeKey>(this.changedNodes.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeysAtOrBelow(CachedNode srcNode) {
        CheckArg.isNotNull((Object)srcNode, (String)"srcNode");
        Path sourcePath = srcNode.getPath(this);
        WorkspaceCache workspaceCache = this.workspaceCache();
        AllPathsCache allPathsCache = new AllPathsCache(this, workspaceCache, this.context()){

            @Override
            protected Set<NodeKey> getAdditionalParentKeys(CachedNode node, NodeCache cache) {
                SessionNode sessionNode;
                SessionNode.ChangedAdditionalParents changed;
                Set<NodeKey> keys = super.getAdditionalParentKeys(node, cache);
                if (node instanceof SessionNode && (changed = (sessionNode = (SessionNode)node).additionalParents()) != null) {
                    keys = new HashSet<NodeKey>(keys);
                    keys.addAll(sessionNode.additionalParents().getRemovals());
                }
                return keys;
            }
        };
        Lock readLock = this.lock.readLock();
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        try {
            readLock.lock();
            block3: for (Map.Entry<NodeKey, SessionNode> entry : this.changedNodes.entrySet()) {
                SessionNode changedNodeThisSession = entry.getValue();
                NodeKey changedNodeKey = entry.getKey();
                CachedNode changedNode = null;
                if (changedNodeThisSession == REMOVED) {
                    CachedNode persistentRemovedNode = workspaceCache.getNode(changedNodeKey);
                    if (persistentRemovedNode == null) {
                        result.add(changedNodeKey);
                        continue;
                    }
                    changedNode = persistentRemovedNode;
                } else {
                    changedNode = changedNodeThisSession;
                }
                for (Path validPath : allPathsCache.getPaths(changedNode)) {
                    if (!validPath.isAtOrBelow(sourcePath)) continue;
                    result.add(changedNodeKey);
                    continue block3;
                }
            }
            HashSet<NodeKey> hashSet = result;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean hasChanges() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = !this.changedNodesInOrder.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void checkForTransaction() throws SystemException {
        try {
            Transactions transactions = this.repositoryEnvironment.getTransactions();
            Transaction txn = transactions.getTransactionManager().getTransaction();
            if (txn != null && txn.getStatus() == 0) {
                WorkspaceCache workspaceCache = this.getWorkspace();
                if (workspaceCache instanceof TransactionalWorkspaceCache) {
                    return;
                }
                this.setWorkspaceCache(this.txWorkspaceCaches.getTransactionalCache(workspaceCache));
                Transactions.Transaction modeshapeTx = transactions.currentTransaction();
                if (modeshapeTx != null) {
                    String txId = modeshapeTx.id();
                    Map funcsByTxId = COMPLETE_FUNCTION_BY_TX_AND_WS.computeIfAbsent(txId, transactionId -> new ConcurrentHashMap());
                    funcsByTxId.computeIfAbsent(this.workspaceName(), wsName -> {
                        Transactions.TransactionFunction completeFunction = () -> this.completeTransaction(txId, (String)wsName);
                        modeshapeTx.uponCompletion(completeFunction);
                        return completeFunction;
                    });
                }
            } else {
                this.setWorkspaceCache(this.sharedWorkspaceCache());
            }
        }
        catch (SystemException e) {
            this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorDeterminingCurrentTransactionAssumingNone, new Object[]{this.workspaceName(), e.getMessage()});
            throw e;
        }
    }

    private void completeTransaction(String txId, String wsName) {
        this.getWorkspace().clear();
        this.setWorkspaceCache(this.sharedWorkspaceCache());
        COMPLETE_FUNCTION_BY_TX_AND_WS.compute(txId, (transactionId, funcsByWsName) -> {
            funcsByWsName.remove(wsName);
            if (funcsByWsName.isEmpty()) {
                LOCKED_KEYS_BY_TX_ID.remove(txId);
                return null;
            }
            return funcsByWsName;
        });
    }

    protected final void logChangesBeingSaved(Iterable<NodeKey> firstNodesInOrder, Iterable<NodeKey> secondNodesInOrder) {
        if (SAVE_LOGGER.isTraceEnabled()) {
            String txn = this.txns.currentTransactionId();
            int s = SAVE_NUMBER.getAndIncrement();
            if (s == 100) {
                SAVE_NUMBER.set(1);
            }
            AtomicInteger changes = new AtomicInteger(0);
            ExecutionContext context = this.getContext();
            String id = context.getId();
            String username = context.getSecurityContext().getUserName();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            if (username == null) {
                username = "<anonymous>";
            }
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) is persisting the following changes:", new Object[]{s, txn, username, id});
            UnionIterator<NodeKey> unionIterator = new UnionIterator<NodeKey>(firstNodesInOrder.iterator(), secondNodesInOrder);
            unionIterator.forEachRemaining(key -> {
                SessionNode node = this.changedNodes.get(key);
                if (node != null && node.hasChanges()) {
                    SAVE_LOGGER.trace(" #{0} {1}", new Object[]{s, node.getString(registry)});
                    changes.incrementAndGet();
                }
            });
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) completed persisting changes to {4} nodes", new Object[]{s, txn, username, id, changes.get()});
        }
    }

    @Override
    public void save() {
        this.save(null);
    }

    protected void save(SessionCache.PreSave preSaveOperation) {
        if (!this.hasChanges()) {
            return;
        }
        ChangeSet events = null;
        Lock lock = this.lock.writeLock();
        Transactions.Transaction txn = null;
        try {
            int repeat;
            lock.lock();
            this.runBeforeLocking(preSaveOperation);
            int numNodes = this.changedNodes.size();
            int n = repeat = this.txns.isCurrentlyInTransaction() ? 1 : 4;
            while (--repeat >= 0) {
                txn = this.txns.begin();
                assert (txn != null);
                try {
                    this.checkForTransaction();
                    this.lockNodes(this.changedNodesInOrder);
                    this.runAfterLocking(preSaveOperation);
                    this.logChangesBeingSaved(this.changedNodesInOrder, null);
                    events = this.persistChanges(this.changedNodesInOrder);
                    if (events.hasBinaryChanges()) {
                        txn.uponCommit(this.binaryUsageUpdateFunction(events.usedBinaries(), events.unusedBinaries()));
                    }
                    this.logger.debug("Altered {0} node(s)", new Object[]{numNodes});
                }
                catch (TimeoutException e) {
                    txn.rollback();
                    if (repeat <= 0) {
                        throw new TimeoutException(e.getMessage(), e);
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception err) {
                    this.logger.debug((Throwable)err, "Error while attempting to save", new Object[0]);
                    this.rollback(txn, err);
                }
                txn.commit();
                this.clearState();
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new WrappedException(t);
        }
        finally {
            lock.unlock();
        }
        this.txns.updateCache(this.workspaceCache(), events, txn);
    }

    private void runBeforeLocking(SessionCache.PreSave preSaveOperation) throws Exception {
        this.runBeforeLocking(preSaveOperation, this.changedNodesInOrder);
    }

    private List<NodeKey> runBeforeLocking(SessionCache.PreSave preSaveOperation, Collection<NodeKey> filter) throws Exception {
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            ArrayList<SessionNode> nodesToProcess = new ArrayList<SessionNode>(this.changedNodes.values());
            for (MutableCachedNode mutableCachedNode : nodesToProcess) {
                if (mutableCachedNode == REMOVED || !filter.contains(mutableCachedNode.getKey())) continue;
                this.checkNodeNotRemovedByAnotherTransaction(mutableCachedNode);
                preSaveOperation.processBeforeLocking(mutableCachedNode, saveContext);
                nodeKeys.add(mutableCachedNode.getKey());
            }
        }
        return nodeKeys;
    }

    private void runAfterLocking(SessionCache.PreSave preSaveOperation) throws Exception {
        this.runAfterLocking(preSaveOperation, this.changedNodesInOrder);
    }

    private void runAfterLocking(SessionCache.PreSave preSaveOperation, Collection<NodeKey> filter) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (MutableCachedNode mutableCachedNode : this.changedNodes.values()) {
                if (mutableCachedNode == REMOVED || !filter.contains(mutableCachedNode.getKey())) continue;
                preSaveOperation.processAfterLocking(mutableCachedNode, saveContext);
            }
        }
    }

    protected void clearState() throws SystemException {
        this.changedNodes = new HashMap<NodeKey, SessionNode>();
        this.referrerChangesForRemovedNodes.clear();
        this.changedNodesInOrder.clear();
        this.binaryReferencesByNodeKey.clear();
        this.replacedNodes = null;
        this.checkForTransaction();
    }

    protected void clearState(Iterable<NodeKey> savedNodesInOrder) throws SystemException {
        for (NodeKey savedNode : savedNodesInOrder) {
            this.changedNodes.remove(savedNode);
            this.changedNodesInOrder.remove(savedNode);
            if (this.replacedNodes != null) {
                this.replacedNodes.remove(savedNode);
            }
            this.referrerChangesForRemovedNodes.remove(savedNode);
            this.binaryReferencesByNodeKey.remove(savedNode);
        }
        this.checkForTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(SessionCache other, SessionCache.PreSave preSaveOperation) {
        WritableSessionCache that = (WritableSessionCache)other.unwrap();
        Lock thisLock = this.lock.writeLock();
        Lock thatLock = that.lock.writeLock();
        ChangeSet events1 = null;
        ChangeSet events2 = null;
        Transactions.Transaction txn = null;
        try {
            int repeat;
            thisLock.lock();
            thatLock.lock();
            this.runBeforeLocking(preSaveOperation);
            int numNodes = this.changedNodes.size() + that.changedNodes.size();
            int n = repeat = this.txns.isCurrentlyInTransaction() ? 1 : 4;
            while (--repeat >= 0) {
                txn = this.txns.begin();
                assert (txn != null);
                try {
                    this.checkForTransaction();
                    that.checkForTransaction();
                    this.lockNodes(this.changedNodesInOrder);
                    that.lockNodes(that.changedNodesInOrder);
                    this.runAfterLocking(preSaveOperation);
                    this.logChangesBeingSaved(this.changedNodesInOrder, that.changedNodesInOrder);
                    events1 = this.persistChanges(this.changedNodesInOrder);
                    if (events1.hasBinaryChanges()) {
                        txn.uponCommit(this.binaryUsageUpdateFunction(events1.usedBinaries(), events1.unusedBinaries()));
                    }
                    if ((events2 = that.persistChanges(that.changedNodesInOrder)).hasBinaryChanges()) {
                        txn.uponCommit(this.binaryUsageUpdateFunction(events2.usedBinaries(), events2.unusedBinaries()));
                    }
                }
                catch (TimeoutException e) {
                    txn.rollback();
                    if (repeat <= 0) {
                        throw new TimeoutException(e.getMessage(), e);
                    }
                    --repeat;
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, "Error while attempting to save", new Object[0]);
                    this.rollback(txn, e);
                }
                this.logger.debug("Altered {0} node(s)", new Object[]{numNodes});
                txn.commit();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Altered {0} keys: {1}", new Object[]{numNodes, this.changedNodes.keySet()});
                }
                this.clearState();
                that.clearState();
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            try {
                thatLock.unlock();
            }
            finally {
                thisLock.unlock();
            }
        }
        this.txns.updateCache(this.workspaceCache(), events1, txn);
        this.txns.updateCache(that.workspaceCache(), events2, txn);
    }

    private void checkNodeNotRemovedByAnotherTransaction(MutableCachedNode node) {
        String keyString = node.getKey().toString();
        if (!node.isNew() && !this.workspaceCache().documentStore().containsKey(keyString)) {
            throw new DocumentNotFoundException(keyString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Set<NodeKey> toBeSaved, SessionCache other, SessionCache.PreSave preSaveOperation) {
        WritableSessionCache that = (WritableSessionCache)other.unwrap();
        Lock thisLock = this.lock.writeLock();
        Lock thatLock = that.lock.writeLock();
        ChangeSet events1 = null;
        ChangeSet events2 = null;
        Transactions.Transaction txn = null;
        try {
            int repeat;
            thisLock.lock();
            thatLock.lock();
            List<NodeKey> savedNodesInOrder = this.runBeforeLocking(preSaveOperation, toBeSaved);
            int numNodes = savedNodesInOrder.size() + that.changedNodesInOrder.size();
            int n = repeat = this.txns.isCurrentlyInTransaction() ? 1 : 4;
            while (--repeat >= 0) {
                txn = this.txns.begin();
                assert (txn != null);
                try {
                    this.checkForTransaction();
                    that.checkForTransaction();
                    this.lockNodes(savedNodesInOrder);
                    that.lockNodes(that.changedNodesInOrder);
                    this.runAfterLocking(preSaveOperation, toBeSaved);
                    this.logChangesBeingSaved(savedNodesInOrder, that.changedNodesInOrder);
                    events1 = this.persistChanges(savedNodesInOrder);
                    if (events1.hasBinaryChanges()) {
                        txn.uponCommit(this.binaryUsageUpdateFunction(events1.usedBinaries(), events1.unusedBinaries()));
                    }
                    if ((events2 = that.persistChanges(that.changedNodesInOrder)).hasBinaryChanges()) {
                        txn.uponCommit(this.binaryUsageUpdateFunction(events2.usedBinaries(), events2.unusedBinaries()));
                    }
                }
                catch (TimeoutException e) {
                    txn.rollback();
                    if (repeat <= 0) {
                        throw new TimeoutException(e.getMessage(), e);
                    }
                    --repeat;
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, "Error while attempting to save", new Object[0]);
                    this.rollback(txn, e);
                }
                this.logger.debug("Altered {0} node(s)", new Object[]{numNodes});
                txn.commit();
                this.clearState(savedNodesInOrder);
                that.clearState();
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            try {
                thatLock.unlock();
            }
            finally {
                thisLock.unlock();
            }
        }
        this.txns.updateCache(this.workspaceCache(), events1, txn);
        this.txns.updateCache(that.workspaceCache(), events2, txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(Transactions.Transaction txn, Exception cause) throws Exception {
        try {
            txn.rollback();
        }
        catch (Exception e) {
            this.logger.debug((Throwable)e, "Error while rolling back transaction " + txn, new Object[0]);
        }
        finally {
            throw cause;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ChangeSet persistChanges(Iterable<NodeKey> changedNodesInOrder) {
        WorkspaceCache persistedCache = this.workspaceCache();
        ExecutionContext context = this.context();
        String userId = context.getSecurityContext().getUserName();
        Map<String, String> userData = context.getData();
        DateTime timestamp = context.getValueFactories().getDateFactory().create();
        String workspaceName = persistedCache.getWorkspaceName();
        String repositoryKey = persistedCache.getRepositoryKey();
        RecordingChanges changes = new RecordingChanges(context.getId(), context.getProcessId(), repositoryKey, workspaceName, this.repositoryEnvironment.journalId());
        DocumentStore documentStore = persistedCache.documentStore();
        DocumentTranslator translator = persistedCache.translator();
        PathCache sessionPaths = new PathCache(this);
        PathCache workspacePaths = new PathCache(persistedCache);
        HashSet<NodeKey> removedNodes = null;
        HashSet<NodeKey> removedUnorderedCollections = null;
        HashSet<BinaryKey> unusedBinaryKeys = new HashSet<BinaryKey>();
        HashSet<BinaryKey> usedBinaryKeys = new HashSet<BinaryKey>();
        HashSet<NodeKey> renamedExternalNodes = new HashSet<NodeKey>();
        LinkedHashMap<NodeKey, Map<BucketId, Set<NodeKey>>> unorderedCollectionBucketRemovals = null;
        NodeTypes nodeTypes = this.nodeTypes();
        for (NodeKey nodeKey : changedNodesInOrder) {
            Path childPath;
            Path parentPath;
            ChildReference ref;
            boolean excludedFromSearch;
            MutableChildReferences appended;
            boolean isExternal;
            SessionNode sessionNode = this.changedNodes.get(nodeKey);
            String string = nodeKey.toString();
            boolean bl = isExternal = !sessionNode.getKey().getSourceKey().equalsIgnoreCase(this.workspaceCache().getRootKey().getSourceKey());
            if (sessionNode == REMOVED) {
                EditableDocument doc;
                SessionNode.ReferrerChanges referrerChanges;
                Set<Name> parentMixinTypes;
                Name parentPrimaryType;
                boolean isUnorderedCollection;
                CachedNode persisted = persistedCache.getNode(nodeKey);
                if (persisted == null) continue;
                if (removedNodes == null) {
                    removedNodes = new HashSet<NodeKey>();
                }
                Name primaryType = persisted.getPrimaryType(this);
                Set<Name> mixinTypes = persisted.getMixinTypes(this);
                boolean bl2 = isUnorderedCollection = nodeTypes != null && nodeTypes.isUnorderedCollection(primaryType, mixinTypes);
                if (isUnorderedCollection && removedUnorderedCollections == null) {
                    removedUnorderedCollections = new HashSet<NodeKey>();
                }
                Path path = workspacePaths.getPath(persisted);
                NodeKey parentKey = persisted.getParentKey(persistedCache);
                CachedNode parent = this.getNode(parentKey);
                if (parent != null) {
                    parentPrimaryType = parent.getPrimaryType(this);
                    parentMixinTypes = parent.getMixinTypes(this);
                } else {
                    parent = persistedCache.getNode(parentKey);
                    parentPrimaryType = parent.getPrimaryType(persistedCache);
                    parentMixinTypes = parent.getMixinTypes(persistedCache);
                }
                changes.nodeRemoved(nodeKey, parentKey, path, primaryType, mixinTypes, parentPrimaryType, parentMixinTypes);
                removedNodes.add(nodeKey);
                if (isUnorderedCollection) {
                    removedUnorderedCollections.add(nodeKey);
                }
                if ((referrerChanges = this.referrerChangesForRemovedNodes.get(nodeKey)) != null && (doc = documentStore.edit(string, false)) != null) {
                    translator.changeReferrers(doc, referrerChanges);
                }
                Iterator<Property> propertyIterator = persisted.getProperties(persistedCache);
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.next();
                    if (!property.isBinary()) continue;
                    List<Object> value = property.isMultiple() ? Arrays.asList(property.getValuesAsArray()) : property.getFirstValue();
                    translator.decrementBinaryReferenceCount(value, unusedBinaryKeys, null);
                }
                continue;
            }
            Name primaryType = sessionNode.getPrimaryType(this);
            Set<Name> mixinTypes = sessionNode.getMixinTypes(this);
            boolean isUnorderedCollection = nodeTypes != null && nodeTypes.isUnorderedCollection(primaryType, mixinTypes);
            CachedNode persisted = null;
            Path newPath = null;
            NodeKey newParent = sessionNode.newParent();
            EditableDocument doc = null;
            SessionNode.ChangedAdditionalParents additionalParents = sessionNode.additionalParents();
            if (sessionNode.isNew()) {
                boolean parentAllowsSNS;
                doc = Schematic.newDocument();
                translator.setKey(doc, nodeKey);
                translator.setParents(doc, newParent, null, additionalParents);
                translator.addInternalProperties(doc, sessionNode.getAddedInternalProperties());
                SessionNode mutableParent = this.mutable(newParent);
                Name parentPrimaryType = mutableParent.getPrimaryType(this);
                Set<Name> parentMixinTypes = mutableParent.getMixinTypes(this);
                boolean bl3 = parentAllowsSNS = nodeTypes != null && nodeTypes.allowsNameSiblings(parentPrimaryType, parentMixinTypes);
                if (!parentAllowsSNS) {
                    appended = mutableParent.appended(false);
                    Path parentPath2 = sessionPaths.getPath(mutableParent);
                    ChildReference ref2 = appended.getChild(nodeKey);
                    if (ref2 == null) {
                        ref2 = mutableParent.changedChildren().inserted(nodeKey);
                    }
                    assert (ref2 != null);
                    newPath = this.pathFactory().create(parentPath2, ref2.getName());
                    sessionPaths.put(nodeKey, newPath);
                } else {
                    newPath = sessionPaths.getPath(sessionNode);
                }
                changes.nodeCreated(nodeKey, newParent, newPath, primaryType, mixinTypes, sessionNode.changedProperties());
            } else {
                doc = documentStore.edit(string, true);
                if (doc == null) {
                    if (isExternal && renamedExternalNodes.contains(nodeKey)) continue;
                    throw new DocumentNotFoundException(string);
                }
                translator.addInternalProperties(doc, sessionNode.getAddedInternalProperties());
                translator.removeInteralProperties(doc, sessionNode.getRemovedInternalProperties());
                newPath = sessionPaths.getPath(sessionNode);
                if (newParent != null) {
                    persisted = persistedCache.getNode(nodeKey);
                    Path oldPath = workspacePaths.getPath(persisted);
                    NodeKey oldParentKey = persisted.getParentKey(persistedCache);
                    if (!oldParentKey.equals(newParent) || additionalParents != null && !additionalParents.isEmpty()) {
                        translator.setParents(doc, sessionNode.newParent(), oldParentKey, additionalParents);
                    }
                    String workspaceKey = sessionNode.getKey().getWorkspaceKey();
                    boolean isSameWorkspace = persistedCache.getWorkspaceKey().equalsIgnoreCase(workspaceKey);
                    if (isSameWorkspace) {
                        changes.nodeMoved(nodeKey, primaryType, mixinTypes, newParent, oldParentKey, newPath, oldPath);
                    }
                } else if (additionalParents != null) {
                    translator.setParents(doc, null, null, additionalParents);
                }
                SessionNode.MixinChanges mixinChanges = sessionNode.mixinChanges(false);
                if (mixinChanges != null && !mixinChanges.isEmpty()) {
                    Property oldProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    translator.addPropertyValues(doc, JcrLexicon.MIXIN_TYPES, true, mixinChanges.getAdded(), unusedBinaryKeys, usedBinaryKeys);
                    translator.removePropertyValues(doc, JcrLexicon.MIXIN_TYPES, mixinChanges.getRemoved(), unusedBinaryKeys, usedBinaryKeys);
                    Property newProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, primaryType, mixinTypes, newPath, newProperty);
                    } else if (newProperty == null) {
                        changes.propertyRemoved(nodeKey, primaryType, mixinTypes, newPath, oldProperty);
                    } else {
                        changes.propertyChanged(nodeKey, primaryType, mixinTypes, newPath, newProperty, oldProperty);
                    }
                }
            }
            SessionNode.LockChange lockChange = sessionNode.getLockChange();
            if (lockChange != null) {
                switch (lockChange) {
                    case LOCK_FOR_SESSION: 
                    case LOCK_FOR_NON_SESSION: {
                        if (!translator.isLocked(doc)) break;
                        throw new LockFailureException(nodeKey);
                    }
                }
            }
            boolean hasPropertyChanges = false;
            Set<Name> removedProperties = sessionNode.removedProperties();
            if (!removedProperties.isEmpty()) {
                assert (!sessionNode.isNew());
                if (persisted == null) {
                    persisted = persistedCache.getNode(nodeKey);
                }
                for (Name name : removedProperties) {
                    Property oldProperty = translator.removeProperty(doc, name, unusedBinaryKeys, usedBinaryKeys);
                    if (oldProperty == null) continue;
                    changes.propertyRemoved(nodeKey, primaryType, mixinTypes, newPath, oldProperty);
                    hasPropertyChanges = true;
                }
            }
            if (!sessionNode.changedProperties().isEmpty()) {
                if (!sessionNode.isNew() && persisted == null) {
                    persisted = persistedCache.getNode(nodeKey);
                }
                for (Map.Entry propEntry : sessionNode.changedProperties().entrySet()) {
                    Name name = (Name)propEntry.getKey();
                    Property prop = (Property)propEntry.getValue();
                    Property property = persisted != null ? persisted.getProperty(name, persistedCache) : null;
                    translator.setProperty(doc, prop, unusedBinaryKeys, usedBinaryKeys);
                    if (property == null) {
                        changes.propertyAdded(nodeKey, primaryType, mixinTypes, newPath, prop);
                        hasPropertyChanges = true;
                        continue;
                    }
                    if (property.equals(prop)) continue;
                    changes.propertyChanged(nodeKey, primaryType, mixinTypes, newPath, prop, property);
                    hasPropertyChanges = true;
                }
            }
            SessionNode.ChangedChildren changedChildren = sessionNode.changedChildren();
            appended = sessionNode.appended(false);
            if ((changedChildren == null || changedChildren.isEmpty()) && appended != null && !appended.isEmpty()) {
                if (!isUnorderedCollection) {
                    translator.changeChildren(doc, changedChildren, appended);
                } else {
                    translator.addChildrenToBuckets(doc, appended);
                }
            } else if (changedChildren != null && !changedChildren.isEmpty()) {
                Map.Entry<NodeKey, Name> renameEntry2;
                ChildReferences childReferences = sessionNode.getChildReferences(this);
                if (!changedChildren.getRemovals().isEmpty() && !isUnorderedCollection) {
                    for (NodeKey nodeKey2 : changedChildren.getRemovals()) {
                        CachedNode persistedChild = persistedCache.getNode(nodeKey2);
                        if (persistedChild == null) continue;
                        NodeKey childKey = persistedChild.getKey();
                        if (appended == null || !appended.hasChild(childKey)) continue;
                        ChildReference appendedChildRef = childReferences.getChild(childKey);
                        Path newNodePath = this.pathFactory().create(newPath, appendedChildRef.getSegment());
                        Path oldNodePath = workspacePaths.getPath(persistedChild);
                        Map<NodeKey, Map<Path, Path>> pathChangesForSNS = this.computePathChangesForSNS(workspacePaths, newPath, childReferences, appendedChildRef, newNodePath, oldNodePath);
                        changes.nodeReordered(childKey, persistedChild.getPrimaryType(this), persistedChild.getMixinTypes(this), sessionNode.getKey(), newNodePath, oldNodePath, null, pathChangesForSNS);
                    }
                }
                if (!isUnorderedCollection) {
                    translator.changeChildren(doc, changedChildren, appended);
                } else {
                    Map<BucketId, Set<NodeKey>> removalsPerBucket;
                    if (appended != null && !appended.isEmpty()) {
                        translator.addChildrenToBuckets(doc, appended);
                    }
                    if (changedChildren.removalCount() > 0 && !(removalsPerBucket = translator.preRemoveChildrenFromBuckets(this.workspaceCache(), doc, changedChildren.getRemovals())).isEmpty()) {
                        if (unorderedCollectionBucketRemovals == null) {
                            unorderedCollectionBucketRemovals = new LinkedHashMap<NodeKey, Map<BucketId, Set<NodeKey>>>();
                        }
                        unorderedCollectionBucketRemovals.put(nodeKey, removalsPerBucket);
                    }
                }
                Map<NodeKey, Name> newNames = changedChildren.getNewNames();
                if (!newNames.isEmpty()) {
                    for (Map.Entry<NodeKey, Name> renameEntry2 : newNames.entrySet()) {
                        NodeKey renamedKey = (NodeKey)renameEntry2.getKey();
                        CachedNode oldRenamedNode = persistedCache.getNode(renamedKey);
                        if (oldRenamedNode == null) continue;
                        Path renamedFromPath = workspacePaths.getPath(oldRenamedNode);
                        Path renamedToPath = this.pathFactory().create(renamedFromPath.getParent(), (Name)renameEntry2.getValue());
                        changes.nodeRenamed(renamedKey, renamedToPath, renamedFromPath.getLastSegment(), primaryType, mixinTypes);
                        if (!isExternal) continue;
                        renamedExternalNodes.add(renamedKey);
                    }
                }
                Map<NodeKey, SessionNode.Insertions> map = changedChildren.getInsertionsByBeforeKey();
                renameEntry2 = map.values().iterator();
                while (renameEntry2.hasNext()) {
                    SessionNode.Insertions insertion = (SessionNode.Insertions)renameEntry2.next();
                    for (ChildReference insertedRef : insertion.inserted()) {
                        CachedNode insertedNodePersistent = persistedCache.getNode(insertedRef);
                        CachedNode insertedNode = this.getNode(insertedRef.getKey());
                        if (insertedNodePersistent != null) {
                            ChildReference nodeNewRef = childReferences.getChild(insertedRef.getKey());
                            Path nodeNewPath = this.pathFactory().create(newPath, nodeNewRef.getSegment());
                            Path nodeOldPath = workspacePaths.getPath(insertedNodePersistent);
                            Path insertedBeforePath = null;
                            CachedNode insertedBeforeNode = persistedCache.getNode(insertion.insertedBefore());
                            if (insertedBeforeNode != null) {
                                insertedBeforePath = workspacePaths.getPath(insertedBeforeNode);
                                boolean isSnsReordering = nodeOldPath.getLastSegment().getName().equals(insertedBeforePath.getLastSegment().getName());
                                if (isSnsReordering) {
                                    nodeNewPath = insertedBeforePath;
                                }
                            }
                            Map<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey = this.computePathChangesForSNS(workspacePaths, newPath, childReferences, insertedRef, nodeNewPath, nodeOldPath);
                            changes.nodeReordered(insertedRef.getKey(), insertedNode.getPrimaryType(this), insertedNode.getMixinTypes(this), sessionNode.getKey(), nodeNewPath, nodeOldPath, insertedBeforePath, snsPathChangesByNodeKey);
                            continue;
                        }
                        Path nodeNewPath = sessionPaths.getPath(insertedNode);
                        CachedNode insertedBeforeNode = this.getNode(insertion.insertedBefore().getKey());
                        Path insertedBeforePath = sessionPaths.getPath(insertedBeforeNode);
                        changes.nodeReordered(insertedRef.getKey(), insertedNode.getPrimaryType(this), insertedNode.getMixinTypes(this), sessionNode.getKey(), nodeNewPath, null, insertedBeforePath);
                    }
                }
            }
            SessionNode.ReferrerChanges referrerChanges = sessionNode.getReferrerChanges();
            boolean nodeChanged = false;
            if (referrerChanges != null && !referrerChanges.isEmpty()) {
                translator.changeReferrers(doc, referrerChanges);
                changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes);
                nodeChanged = true;
            }
            for (Map.Entry<String, String> federatedSegment : sessionNode.getAddedFederatedSegments().entrySet()) {
                String externalNodeKey = federatedSegment.getKey();
                String childName = federatedSegment.getValue();
                translator.addFederatedSegment(doc, externalNodeKey, childName);
                if (nodeChanged) continue;
                changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes);
                nodeChanged = true;
            }
            Set<String> set = sessionNode.getRemovedFederatedSegments();
            if (!set.isEmpty()) {
                translator.removeFederatedSegments(doc, sessionNode.getRemovedFederatedSegments());
                if (!nodeChanged) {
                    changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes);
                    nodeChanged = true;
                }
            }
            if ((excludedFromSearch = sessionNode.isExcludedFromSearch(this)) && translator.isQueryable((Document)doc)) {
                translator.setQueryable(doc, false);
            }
            if (!excludedFromSearch && !translator.isQueryable((Document)doc)) {
                translator.setQueryable(doc, true);
            }
            if (sessionNode.isNew()) {
                if (documentStore.storeIfAbsent(string, (Document)doc) != null) {
                    if (this.replacedNodes != null && this.replacedNodes.contains(nodeKey)) {
                        documentStore.localStore().put(string, (Document)doc);
                    } else {
                        if (removedNodes == null || !removedNodes.contains(nodeKey)) throw new DocumentAlreadyExistsException(string);
                        documentStore.localStore().put(string, (Document)doc);
                        removedNodes.remove(nodeKey);
                    }
                }
            } else {
                boolean externalNodeChanged;
                boolean bl4 = externalNodeChanged = isExternal && (hasPropertyChanges || sessionNode.hasNonPropertyChanges() || sessionNode.changedChildren().renameCount() > 0);
                if (externalNodeChanged) {
                    documentStore.updateDocument(string, (Document)doc, sessionNode);
                }
            }
            if (additionalParents == null) continue;
            for (NodeKey parentKey : additionalParents.getAdditions()) {
                SessionNode parent = this.changedNodes.get(parentKey);
                if (parent == null) continue;
                ref = parent.getChildReferences(this).getChild(nodeKey);
                parentPath = sessionPaths.getPath(parent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeCreated(nodeKey, parentKey, childPath, primaryType, mixinTypes, null);
            }
            for (NodeKey parentKey : additionalParents.getRemovals()) {
                CachedNode persistedParent = persistedCache.getNode(parentKey);
                if (persistedParent == null || (ref = persistedParent.getChildReferences(this).getChild(nodeKey)) == null) continue;
                parentPath = workspacePaths.getPath(persistedParent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                Name parentPrimaryType = persistedParent.getPrimaryType(persistedCache);
                Set<Name> parentMixinTypes = persistedParent.getMixinTypes(persistedCache);
                changes.nodeRemoved(nodeKey, parentKey, childPath, primaryType, mixinTypes, parentPrimaryType, parentMixinTypes);
            }
        }
        if (unorderedCollectionBucketRemovals != null) {
            for (Map.Entry entry : unorderedCollectionBucketRemovals.entrySet()) {
                translator.persistBucketRemovalChanges((NodeKey)entry.getKey(), (Map)entry.getValue());
            }
        }
        if (removedUnorderedCollections != null) {
            for (NodeKey nodeKey : removedUnorderedCollections) {
                translator.removeAllBucketsFromUnorderedCollection(nodeKey);
            }
        }
        if (removedNodes != null) {
            assert (!removedNodes.isEmpty());
            HashMap<NodeKey, Set<NodeKey>> referrersByRemovedNodes = new HashMap<NodeKey, Set<NodeKey>>();
            for (NodeKey nodeKey : removedNodes) {
                SchematicEntry schematicEntry = documentStore.get(nodeKey.toString());
                if (schematicEntry == null) continue;
                Document doc = schematicEntry.content();
                Set<NodeKey> strongReferrers = translator.getReferrers(doc, CachedNode.ReferenceType.STRONG);
                strongReferrers.removeAll(removedNodes);
                if (strongReferrers.isEmpty()) continue;
                referrersByRemovedNodes.put(nodeKey, strongReferrers);
            }
            if (!referrersByRemovedNodes.isEmpty()) {
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
                for (Map.Entry entry : referrersByRemovedNodes.entrySet()) {
                    String removedNodePath = workspacePaths.getPath(persistedCache.getNode((NodeKey)entry.getKey())).toString();
                    Set referrerKeys = (Set)entry.getValue();
                    HashSet<String> referrerPaths = new HashSet<String>(referrerKeys.size());
                    for (NodeKey referrerKey : referrerKeys) {
                        referrerPaths.add(sessionPaths.getPath(this.getNode(referrerKey)).toString());
                    }
                    hashMap.put(removedNodePath, referrerPaths);
                }
                throw new ReferentialIntegrityException(hashMap);
            }
            for (NodeKey nodeKey : removedNodes) {
                documentStore.remove(nodeKey.toString());
            }
        }
        if (!unusedBinaryKeys.isEmpty()) {
            for (BinaryKey binaryKey : unusedBinaryKeys) {
                changes.binaryValueNoLongerUsed(binaryKey);
            }
        }
        if (!usedBinaryKeys.isEmpty()) {
            for (BinaryKey binaryKey : usedBinaryKeys) {
                changes.binaryValueUsed(binaryKey);
            }
        }
        changes.setChangedNodes(this.changedNodes.keySet());
        changes.freeze(userId, userData, timestamp);
        return changes;
    }

    private Map<NodeKey, Map<Path, Path>> computePathChangesForSNS(PathCache workspacePaths, Path parentPath, ChildReferences childReferences, ChildReference reorderedChildRef, Path newChildPath, Path oldChildPath) {
        HashMap<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey = new HashMap<NodeKey, Map<Path, Path>>();
        if (oldChildPath.getLastSegment().hasIndex() || newChildPath.getLastSegment().hasIndex()) {
            for (ChildReference childReference : childReferences) {
                NodeKey childKey = childReference.getKey();
                if (childKey.equals(reorderedChildRef.getKey()) || !childReference.getName().equals(reorderedChildRef.getName())) continue;
                CachedNode sns = this.getNode(childKey);
                Path snsNewPath = this.pathFactory().create(parentPath, childReference.getSegment());
                Path snsOldPath = workspacePaths.getPath(sns);
                if (snsOldPath.equals(snsNewPath)) continue;
                snsPathChangesByNodeKey.put(childKey, Collections.singletonMap(snsOldPath, snsNewPath));
            }
        }
        return snsPathChangesByNodeKey;
    }

    private void lockNodes(Collection<NodeKey> changedNodesInOrder) {
        WorkspaceCache workspaceCache = this.workspaceCache();
        assert (workspaceCache instanceof TransactionalWorkspaceCache);
        if (changedNodesInOrder.isEmpty()) {
            return;
        }
        DocumentStore documentStore = workspaceCache.documentStore();
        if (this.logger.isDebugEnabled() && !this.changedNodes.isEmpty()) {
            this.logger.debug("Attempting to the lock nodes: {0}", new Object[]{this.changedNodes.keySet()});
        }
        Set changedNodesKeys = changedNodesInOrder.stream().map(this::keysToLockForNode).collect(TreeSet::new, TreeSet::addAll, TreeSet::addAll);
        Transactions.Transaction modeshapeTx = this.repositoryEnvironment.getTransactions().currentTransaction();
        assert (modeshapeTx != null);
        String txId = modeshapeTx.id();
        Set lockedKeysForTx = LOCKED_KEYS_BY_TX_ID.computeIfAbsent(txId, id -> new LinkedHashSet());
        if (lockedKeysForTx.containsAll(changedNodesKeys)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The keys {0} have been locked previously as part of the transaction {1}; skipping them...", new Object[]{changedNodesKeys, txId});
            }
            return;
        }
        TreeSet<String> newKeysToLock = new TreeSet<String>(changedNodesKeys);
        newKeysToLock.removeAll(lockedKeysForTx);
        int retryCountOnLockTimeout = 3;
        boolean locksAcquired = false;
        while (!locksAcquired && retryCountOnLockTimeout > 0) {
            locksAcquired = documentStore.lockDocuments(newKeysToLock);
            if (locksAcquired) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Locked the nodes: {0}", new Object[]{newKeysToLock});
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Timeout while attempting to lock keys {0}. Retrying....", new Object[]{newKeysToLock});
            }
            --retryCountOnLockTimeout;
        }
        if (!locksAcquired) {
            throw new TimeoutException("Timeout while attempting to lock the keys " + changedNodesKeys + " after " + retryCountOnLockTimeout + " retry attempts.");
        }
        lockedKeysForTx.addAll(newKeysToLock);
        workspaceCache.loadFromDocumentStore(changedNodesKeys);
    }

    private Set<String> keysToLockForNode(NodeKey key) {
        TreeSet<String> keys = new TreeSet<String>();
        keys.add(key.toString());
        Set<BinaryKey> binaryReferencesForNode = this.binaryReferencesByNodeKey.get(key);
        if (binaryReferencesForNode == null || binaryReferencesForNode.isEmpty()) {
            return keys;
        }
        DocumentTranslator translator = this.translator();
        for (BinaryKey binaryKey : binaryReferencesForNode) {
            keys.add(translator.keyForBinaryReferenceDocument(binaryKey.toString()));
        }
        return keys;
    }

    private Transactions.TransactionFunction binaryUsageUpdateFunction(Set<BinaryKey> usedBinaries, Set<BinaryKey> unusedBinaries) {
        BinaryStore binaryStore = this.getContext().getBinaryStore();
        return () -> {
            if (!usedBinaries.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Marking binary values as used: {0}", new Object[]{usedBinaries});
                }
                try {
                    binaryStore.markAsUsed(usedBinaries);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Finished marking binary values as used: {0}", new Object[]{usedBinaries});
                    }
                }
                catch (BinaryStoreException e) {
                    this.logger.error((Throwable)((Object)e), (I18nResource)JcrI18n.errorMarkingBinaryValuesUsed, new Object[]{e.getMessage()});
                }
            }
            if (!unusedBinaries.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Marking binary values as unused: {0}", new Object[]{unusedBinaries});
                }
                try {
                    binaryStore.markAsUnused(unusedBinaries);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Finished marking binary values as unused: {0}", new Object[]{unusedBinaries});
                    }
                }
                catch (BinaryStoreException e) {
                    this.logger.error((Throwable)((Object)e), (I18nResource)JcrI18n.errorMarkingBinaryValuesUnused, new Object[]{e.getMessage()});
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionNode add(SessionNode newNode) {
        assert (newNode != REMOVED);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            NodeKey key = newNode.getKey();
            SessionNode node = this.changedNodes.put(key, newNode);
            if (node != null) {
                if (node != REMOVED) {
                    this.changedNodes.put(key, node);
                    SessionNode sessionNode = node;
                    return sessionNode;
                }
                if (this.replacedNodes == null) {
                    this.replacedNodes = new HashSet<NodeKey>();
                }
                this.replacedNodes.add(key);
            }
            this.changedNodesInOrder.add(key);
            SessionNode sessionNode = newNode;
            return sessionNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(NodeKey key) {
        assert (key != null);
        WorkspaceCache workspace = this.workspaceCache();
        CachedNode topNode = this.getNode(key);
        if (topNode == null) {
            throw new NodeNotFoundException(key);
        }
        HashMap<NodeKey, SessionNode> removed = new HashMap<NodeKey, SessionNode>();
        LinkedHashSet<NodeKey> addToChangedNodes = new LinkedHashSet<NodeKey>();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
            keys.add(key);
            while (!keys.isEmpty()) {
                NodeKey nodeKey = (NodeKey)keys.remove();
                SessionNode node = this.changedNodes.put(nodeKey, REMOVED);
                boolean cleanupReferences = false;
                ChildReferences children = null;
                if (node != null) {
                    if (node == REMOVED) continue;
                    children = node.getChildReferences(this);
                    removed.put(nodeKey, node);
                    this.referrerChangesForRemovedNodes.put(nodeKey, node.getReferrerChanges());
                    cleanupReferences = true;
                    Iterator<Property> it = node.getProperties(this);
                    while (it.hasNext()) {
                        Property property = it.next();
                        if (property == null || !property.isBinary() || node.isPropertyNew(this, property.getName())) continue;
                        this.collectBinaryReferences(nodeKey, property);
                    }
                } else {
                    addToChangedNodes.add(nodeKey);
                    CachedNode persisted = workspace.getNode(nodeKey);
                    if (persisted == null) continue;
                    children = persisted.getChildReferences(workspace);
                    Iterator<Property> it = persisted.getProperties(workspace);
                    while (it.hasNext()) {
                        Property property = it.next();
                        if (property == null) continue;
                        if (property.isReference()) {
                            this.changedNodes.remove(nodeKey);
                            node = this.mutable(nodeKey);
                            if (node != null) {
                                cleanupReferences = true;
                            }
                            this.changedNodes.put(nodeKey, REMOVED);
                        }
                        if (!property.isBinary()) continue;
                        this.collectBinaryReferences(nodeKey, property);
                    }
                }
                if (cleanupReferences) {
                    assert (node != null);
                    node.removeAllReferences(this);
                }
                assert (children != null);
                for (ChildReference child : children) {
                    NodeKey childKey = child.getKey();
                    if (!childKey.getSourceKey().equalsIgnoreCase(key.getSourceKey())) continue;
                    keys.add(childKey);
                }
            }
            this.changedNodesInOrder.addAll(addToChangedNodes);
        }
        catch (RuntimeException e) {
            try {
                this.changedNodes.putAll(removed);
            }
            catch (RuntimeException e2) {
                I18n msg = JcrI18n.failedWhileRollingBackDestroyToRuntimeError;
                this.logger.error((Throwable)e2, (I18nResource)msg, new Object[]{e2.getMessage(), e.getMessage()});
            }
            finally {
                throw e;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void collectBinaryReferences(NodeKey nodeKey, Property property) {
        property.forEach(value -> {
            assert (value instanceof Binary);
            if (value instanceof AbstractBinary) {
                BinaryKey binaryKey = ((AbstractBinary)value).getKey();
                this.addBinaryReference(nodeKey, binaryKey);
            }
        });
    }

    @Override
    public boolean isDestroyed(NodeKey key) {
        return this.changedNodes.get(key) == REMOVED;
    }

    protected void addBinaryReference(NodeKey nodeKey, BinaryKey ... binaryKeys) {
        Set emptySet;
        if (binaryKeys.length == 0) {
            return;
        }
        Set<BinaryKey> binaryReferencesForNode = this.binaryReferencesByNodeKey.get(nodeKey);
        if (binaryReferencesForNode == null && (binaryReferencesForNode = this.binaryReferencesByNodeKey.putIfAbsent(nodeKey, emptySet = Collections.newSetFromMap(new ConcurrentHashMap()))) == null) {
            binaryReferencesForNode = emptySet;
        }
        binaryReferencesForNode.addAll(Arrays.asList(binaryKeys));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NamespaceRegistry reg = this.context().getNamespaceRegistry();
        sb.append("Session ").append(this.context().getId()).append(" to workspace '").append(this.workspaceName());
        for (NodeKey key : this.changedNodesInOrder) {
            SessionNode changes = this.changedNodes.get(key);
            if (changes == null) continue;
            sb.append("\n ");
            sb.append(changes.getString(reg));
        }
        return sb.toString();
    }
}

