/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.EnumSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.modeshape.common.database.DatabaseType;
import org.modeshape.common.database.DatabaseUtil;
import org.modeshape.common.logging.Logger;
import org.modeshape.persistence.relational.RelationalDbConfig;
import org.modeshape.persistence.relational.RelationalProviderException;
import org.modeshape.persistence.relational.RelationalProviderI18n;

public final class DataSourceManager {
    private static final Logger LOGGER = Logger.getLogger(DataSourceManager.class);
    private static final EnumSet<DatabaseType.Name> SUPPORTED_DBS = EnumSet.of(DatabaseType.Name.H2, DatabaseType.Name.MYSQL, DatabaseType.Name.POSTGRES, DatabaseType.Name.ORACLE, DatabaseType.Name.SQLSERVER);
    private final DataSource dataSource;
    private final DatabaseType dbType;

    protected DataSourceManager(RelationalDbConfig config) {
        this.dataSource = config.isDatasourceManaged() ? this.getFromJndi(config.datasourceJNDIName()) : this.createManagedDS(config);
        try (Connection connection = this.newConnection(false, true);){
            DatabaseMetaData metaData = connection.getMetaData();
            this.dbType = DatabaseUtil.determineType((DatabaseMetaData)metaData);
            if (!SUPPORTED_DBS.contains(this.dbType.name())) {
                throw new RelationalProviderException(RelationalProviderI18n.unsupportedDBError, this.dbType);
            }
        }
        catch (SQLException e) {
            throw new RelationalProviderException(e);
        }
    }

    private DataSource createManagedDS(RelationalDbConfig config) {
        HikariConfig hikariCfg = new HikariConfig(config.datasourceConfig());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempting to connect to '{0}' with '{1}' for username '{2}' and password '{3}'", new Object[]{hikariCfg.getJdbcUrl(), hikariCfg.getDriverClassName(), hikariCfg.getUsername(), "*****"});
        }
        return new HikariDataSource(hikariCfg);
    }

    private DataSource getFromJndi(String jndiName) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Object result = initialContext.lookup(jndiName);
            if (!(result instanceof DataSource)) {
                throw new RelationalProviderException(RelationalProviderI18n.jndiError, jndiName, " incorrect type: " + result.getClass().getName());
            }
            DataSource dataSource = (DataSource)result;
            return dataSource;
        }
        catch (NamingException e) {
            throw new RelationalProviderException(e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException e) {
                    LOGGER.debug((Throwable)e, "Cannot close JNDI context", new Object[0]);
                }
            }
        }
    }

    protected DatabaseType dbType() {
        return this.dbType;
    }

    protected DataSource dataSource() {
        return this.dataSource;
    }

    protected Connection newConnection(boolean autocommit, boolean readonly) {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(autocommit);
            connection.setTransactionIsolation(2);
            connection.setReadOnly(readonly);
            return connection;
        }
        catch (SQLException e) {
            throw new RelationalProviderException(e);
        }
    }

    protected void close() {
        if (this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
    }

    public String toString() {
        return "DataSourceManager[dataSource=" + this.dataSource + ", dbType=" + this.dbType + ']';
    }
}

