/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.persistence.relational.TransactionsHolder;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.BasicDocument;

@ThreadSafe
public final class TransactionalCaches {
    protected static final Document REMOVED = new BasicDocument(){

        public String toString() {
            return "DOCUMENT_REMOVED";
        }
    };
    private final Map<String, TransactionalCache> cachesByTxId = new ConcurrentHashMap<String, TransactionalCache>();

    protected TransactionalCaches() {
    }

    protected Document search(String key) {
        TransactionalCache cache = this.cacheForActiveTransaction();
        Document doc = cache.getFromWriteCache(key);
        if (doc != null) {
            return doc;
        }
        return cache.getFromReadCache(key);
    }

    protected Document getForWriting(String key) {
        return this.cacheForActiveTransaction().getFromWriteCache(key);
    }

    protected void putForReading(String key, Document doc) {
        if (!TransactionsHolder.hasActiveTransaction()) {
            return;
        }
        this.cacheForActiveTransaction().putForReading(key, doc);
    }

    protected Document putForWriting(String key, Document doc) {
        return this.cacheForActiveTransaction().putForWriting(key, doc);
    }

    protected Set<String> documentKeys() {
        TransactionalCache transactionalCache = this.cacheForActiveTransaction();
        return transactionalCache.writeCache().entrySet().stream().filter(entry -> !transactionalCache.isRemoved((String)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected boolean isRemoved(String key) {
        return this.cacheForActiveTransaction().isRemoved(key);
    }

    protected void remove(String key) {
        this.cacheForActiveTransaction().remove(key);
    }

    protected boolean isNew(String key) {
        return this.cacheForActiveTransaction().isNew(key);
    }

    protected void putNew(String key) {
        if (!TransactionsHolder.hasActiveTransaction()) {
            return;
        }
        this.cacheForActiveTransaction().putNew(key);
    }

    protected void putNew(Collection<String> keys) {
        if (!TransactionsHolder.hasActiveTransaction()) {
            return;
        }
        this.cacheForActiveTransaction().putNew(keys);
    }

    protected void clearCache(String txId) {
        this.cachesByTxId.remove(txId);
    }

    protected void stop() {
        this.cachesByTxId.clear();
    }

    private TransactionalCache cacheForActiveTransaction() {
        String activeTxId = TransactionsHolder.requireActiveTransaction();
        return this.cachesByTxId.computeIfAbsent(activeTxId, TransactionalCache::new);
    }

    protected TransactionalCache cacheForTransaction(String txId) {
        return this.cachesByTxId.get(txId);
    }

    protected static class TransactionalCache {
        private final ConcurrentMap<String, Document> read = new ConcurrentHashMap<String, Document>();
        private final ConcurrentMap<String, Document> write = new ConcurrentHashMap<String, Document>();
        private final Set<String> newIds = Collections.newSetFromMap(new ConcurrentHashMap());

        protected TransactionalCache(String txId) {
        }

        protected Document getFromReadCache(String id) {
            return (Document)this.read.get(id);
        }

        protected Document getFromWriteCache(String id) {
            return (Document)this.write.get(id);
        }

        protected void putForReading(String id, Document doc) {
            this.read.put(id, doc);
        }

        protected Document putForWriting(String id, Document doc) {
            if (this.write.replace(id, doc) == null) {
                this.write.putIfAbsent(id, doc.clone());
            }
            return (Document)this.write.get(id);
        }

        protected void putNew(String id) {
            this.newIds.add(id);
        }

        protected void putNew(Collection<String> ids) {
            this.newIds.addAll(ids);
        }

        protected boolean isNew(String id) {
            return this.newIds.contains(id);
        }

        protected boolean isRemoved(String id) {
            return this.write.get(id) == REMOVED;
        }

        protected void remove(String id) {
            this.write.put(id, REMOVED);
        }

        protected ConcurrentMap<String, Document> writeCache() {
            return this.write;
        }

        protected ConcurrentMap<String, Document> readCache() {
            return this.read;
        }

        protected void clear() {
            this.read.clear();
            this.write.clear();
            this.newIds.clear();
        }
    }
}

