/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitBinaryValue;
import org.modeshape.connector.git.GitBranches;
import org.modeshape.connector.git.GitCommitDetails;
import org.modeshape.connector.git.GitFunction;
import org.modeshape.connector.git.GitHistory;
import org.modeshape.connector.git.GitI18n;
import org.modeshape.connector.git.GitRoot;
import org.modeshape.connector.git.GitTags;
import org.modeshape.connector.git.GitTree;
import org.modeshape.connector.git.PageableGitFunction;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.PageKey;
import org.modeshape.jcr.spi.federation.PageWriter;
import org.modeshape.jcr.spi.federation.Pageable;
import org.modeshape.jcr.spi.federation.ReadOnlyConnector;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.schematic.document.Document;

public class GitConnector
extends ReadOnlyConnector
implements Pageable {
    private static final boolean DEFAULT_INCLUDE_MIME_TYPE = false;
    private static final String GIT_DIRECTORY_NAME = ".git";
    private static final String GIT_CND_PATH = "org/modeshape/connector/git/git.cnd";
    private String directoryPath;
    private String remoteName;
    private List<String> parsedRemoteNames;
    private boolean includeMimeType = false;
    private Repository repository;
    private Git git;
    private Map<String, GitFunction> functions;
    private Map<String, PageableGitFunction> pageableFunctions;
    private Values values;

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        File dir = new File(this.directoryPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RepositoryException(GitI18n.directoryDoesNotExist.text(new Object[]{dir.getAbsolutePath()}));
        }
        if (!dir.canRead()) {
            throw new RepositoryException(GitI18n.directoryCannotBeRead.text(new Object[]{dir.getAbsolutePath()}));
        }
        File gitDir = dir;
        if (!GIT_DIRECTORY_NAME.equals(gitDir.getName())) {
            gitDir = new File(dir, GIT_DIRECTORY_NAME);
            if (!gitDir.exists() || !gitDir.isDirectory()) {
                throw new RepositoryException(GitI18n.directoryDoesNotExist.text(new Object[]{gitDir.getAbsolutePath()}));
            }
            if (!gitDir.canRead()) {
                throw new RepositoryException(GitI18n.directoryCannotBeRead.text(new Object[]{gitDir.getAbsolutePath()}));
            }
        }
        this.values = new Values(this.factories(), this.getContext().getBinaryStore());
        this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).setMustExist(true)).setBare()).build();
        this.git = new Git(this.repository);
        this.parsedRemoteNames = new ArrayList<String>();
        if (this.remoteName != null) {
            Set remoteNames = this.repository.getConfig().getSubsections("remote");
            String remoteName = null;
            for (String desiredName : this.remoteName.split(",")) {
                if (!remoteNames.contains(desiredName = desiredName.trim())) continue;
                remoteName = desiredName;
                this.parsedRemoteNames.add(desiredName);
                break;
            }
            if (remoteName == null) {
                throw new RepositoryException(GitI18n.remoteDoesNotExist.text(new Object[]{this.remoteName, gitDir.getAbsolutePath()}));
            }
            this.remoteName = remoteName;
        }
        this.functions = new HashMap<String, GitFunction>();
        this.pageableFunctions = new HashMap<String, PageableGitFunction>();
        this.register(new GitRoot(this), new GitBranches(this), new GitTags(this), new GitHistory(this), new GitCommitDetails(this), new GitTree(this));
        InputStream cndStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(GIT_CND_PATH);
        nodeTypeManager.registerNodeTypes(cndStream, true);
    }

    private void register(GitFunction ... functions) {
        for (GitFunction function : functions) {
            this.functions.put(function.getName(), function);
            if (!(function instanceof PageableGitFunction)) continue;
            this.pageableFunctions.put(function.getName(), (PageableGitFunction)((Object)function));
        }
    }

    protected DocumentWriter newDocumentWriter(String id) {
        return super.newDocument(id);
    }

    protected boolean includeMimeType() {
        return this.includeMimeType;
    }

    public void shutdown() {
        this.repository = null;
        this.git = null;
        this.functions = null;
    }

    public Document getDocumentById(String id) {
        CallSpecification callSpec = new CallSpecification(id);
        GitFunction function = this.functions.get(callSpec.getFunctionName());
        if (function == null) {
            return null;
        }
        try {
            DocumentWriter writer = this.newDocument(id);
            String parentId = callSpec.getParentId();
            assert (parentId != null);
            writer.setParent(parentId);
            if (!this.isQueryable().booleanValue() || !function.isQueryable(callSpec)) {
                writer.setNotQueryable();
            }
            Document doc = function.execute(this.repository, this.git, callSpec, writer, this.values);
            this.getLogger().trace("ID={0},result={1}", new Object[]{id, doc});
            return doc;
        }
        catch (Throwable e) {
            throw new DocumentStoreException(id, e);
        }
    }

    public Document getChildren(PageKey pageKey) {
        String id = pageKey.getParentId();
        CallSpecification callSpec = new CallSpecification(id);
        PageableGitFunction function = this.pageableFunctions.get(callSpec.getFunctionName());
        if (function == null) {
            return null;
        }
        try {
            PageWriter writer = this.newPageDocument(pageKey);
            return function.execute(this.repository, this.git, callSpec, writer, this.values, pageKey);
        }
        catch (Throwable e) {
            throw new DocumentStoreException(id, e);
        }
    }

    public Document getChildReference(String parentKey, String childKey) {
        CallSpecification callSpec = new CallSpecification(childKey);
        return this.newChildReference(childKey, callSpec.lastParameter());
    }

    public String getDocumentId(String path) {
        return path;
    }

    public Collection<String> getDocumentPathsById(String id) {
        return Collections.singletonList(id);
    }

    public boolean hasDocument(String id) {
        Document doc = this.getDocumentById(id);
        return doc != null;
    }

    public ExternalBinaryValue getBinaryValue(String id) {
        try {
            ObjectId fileObjectId = ObjectId.fromString((String)id);
            ObjectLoader fileLoader = this.repository.open((AnyObjectId)fileObjectId);
            return new GitBinaryValue(fileObjectId, fileLoader, this.getSourceName(), null, this.getMimeTypeDetector());
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, (Throwable)e);
        }
    }

    protected final String remoteName() {
        return this.remoteName;
    }

    protected final List<String> remoteNames() {
        return this.parsedRemoteNames;
    }
}

