/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitCommitDetails;
import org.modeshape.connector.git.GitConnector;
import org.modeshape.connector.git.GitFunction;
import org.modeshape.connector.git.GitLexicon;
import org.modeshape.connector.git.GitTree;
import org.modeshape.connector.git.PageableGitFunction;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.PageKey;
import org.modeshape.jcr.spi.federation.PageWriter;
import org.modeshape.schematic.document.Document;

public class GitHistory
extends GitFunction
implements PageableGitFunction {
    protected static final String NAME = "commits";
    protected static final String ID = "/commits";
    protected static int DEFAULT_PAGE_SIZE = 15;
    private int pageSize = DEFAULT_PAGE_SIZE;

    protected static Object referenceToHistory(ObjectId id, String branchOrTagName, Values values) {
        return values.referenceTo("/commits/" + branchOrTagName + "/" + id.getName());
    }

    public GitHistory(GitConnector connector) {
        super(NAME, connector);
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, DocumentWriter writer, Values values) throws GitAPIException, IOException {
        if (spec.parameterCount() == 0) {
            writer.setPrimaryType(GitLexicon.COMMITS);
            this.addBranchesAsChildren(git, spec, writer);
            this.addTagsAsChildren(git, spec, writer);
            this.addCommitsAsChildren(git, spec, writer, this.pageSize);
        } else if (spec.parameterCount() == 1) {
            writer.setPrimaryType(GitLexicon.OBJECT);
            this.addCommitsAsChildren(git, spec, writer, this.pageSize);
        } else if (spec.parameterCount() == 2) {
            writer.setPrimaryType(GitLexicon.COMMIT);
            RevWalk walker = new RevWalk(repository);
            try {
                String commitId = spec.parameter(1);
                ObjectId objId = repository.resolve(commitId);
                RevCommit commit = walker.parseCommit((AnyObjectId)objId);
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)objId.name());
                writer.addProperty(GitLexicon.AUTHOR, (Object)this.authorName(commit));
                writer.addProperty(GitLexicon.COMMITTER, (Object)this.commiterName(commit));
                writer.addProperty(GitLexicon.COMMITTED, (Object)values.dateFrom(commit.getCommitTime()));
                writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                writer.addProperty(GitLexicon.TREE, GitTree.referenceToTree(objId, objId.name(), values));
                writer.addProperty(GitLexicon.DETAIL, GitCommitDetails.referenceToCommit(objId, values));
            }
            finally {
                walker.dispose();
            }
        } else {
            return null;
        }
        return writer.document();
    }

    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, PageWriter writer, Values values, PageKey pageKey) throws GitAPIException, IOException {
        this.addCommitsAsPageOfChildren(git, repository, spec, writer, pageKey);
        return writer.document();
    }
}

