/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.TransactionStore;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.persistence.file.FileProviderException;
import org.modeshape.schematic.SchematicDb;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;

public class FileDb
implements SchematicDb {
    private static final Logger LOGGER = Logger.getLogger(FileDb.class);
    private static final String FILENAME = "modeshape.repository";
    private static final ThreadLocal<String> ACTIVE_TX_ID = new ThreadLocal();
    private static final String REPOSITORY_CONTENT = "modeshape_data";
    private final boolean compress;
    private final String path;
    private final ConcurrentMap<String, TransactionStore.TransactionMap<String, Document>> transactionalContentById = new ConcurrentHashMap<String, TransactionStore.TransactionMap<String, Document>>();
    private MVStore store;
    private TransactionStore txStore;
    private TransactionStore.TransactionMap<String, Document> persistedContent;

    protected static FileDb inMemory(boolean compress) {
        return new FileDb(null, compress);
    }

    protected static FileDb onDisk(boolean compress, String path) {
        path = Objects.requireNonNull(path, "The 'path' configuration parameter is required by the FS persistence provider");
        return new FileDb(path, compress);
    }

    private FileDb(String path, boolean compress) {
        this.path = path;
        this.compress = compress;
    }

    public String id() {
        String prefix = "modeshape-file-persistence";
        return this.path == null ? prefix : prefix + "_" + this.path;
    }

    public List<String> keys() {
        ArrayList<String> keys = new ArrayList<String>();
        this.persistedContent.keyIterator(this.persistedContent.firstKey()).forEachRemaining(keys::add);
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(false);
        if (txContent != null) {
            txContent.keyIterator(txContent.firstKey()).forEachRemaining(keys::add);
        }
        return keys;
    }

    public Document get(String key) {
        Document result;
        LOGGER.debug("reading {0}", new Object[]{key});
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(false);
        Document document = result = txContent != null ? (Document)txContent.getLatest((Object)key) : (Document)this.persistedContent.get((Object)key);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{0} is {1}", new Object[]{key, result});
        }
        return result;
    }

    public List<SchematicEntry> load(Collection<String> keys) {
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(false);
        TransactionStore.TransactionMap<String, Document> actualContent = txContent != null ? txContent : this.persistedContent;
        return keys.stream().map(arg_0 -> actualContent.get(arg_0)).filter(Objects::nonNull).map(SchematicEntry::fromDocument).collect(Collectors.toList());
    }

    public void put(String key, SchematicEntry entry) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("putting at {0} document {1}", new Object[]{key, entry.source()});
        }
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(true);
        Document source = entry.source();
        Document content = entry.content();
        if (content instanceof EditableDocument) {
            source = SchematicEntry.create((String)entry.id(), (Document)((EditableDocument)content).unwrap()).source();
        }
        txContent.put((Object)key, (Object)source);
    }

    public EditableDocument editContent(String key, boolean createIfMissing) {
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(true);
        Document existingTxDoc = (Document)txContent.get((Object)key);
        if (existingTxDoc == null && createIfMissing) {
            existingTxDoc = SchematicEntry.create((String)key).source();
            txContent.put((Object)key, (Object)existingTxDoc);
        }
        if (existingTxDoc == null) {
            return null;
        }
        if (!txContent.isSameTransaction((Object)key) && !txContent.trySet((Object)key, (Object)(existingTxDoc = existingTxDoc.clone()), true)) {
            throw new FileProviderException("cannot write new value for the first time");
        }
        return SchematicEntry.content((Document)existingTxDoc).editable();
    }

    public SchematicEntry putIfAbsent(String key, Document content) {
        SchematicEntry existingEntry = this.getEntry(key);
        if (existingEntry != null) {
            return existingEntry;
        }
        this.put(key, SchematicEntry.create((String)key, (Document)content));
        return null;
    }

    public boolean remove(String key) {
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(true);
        Document doc = (Document)txContent.remove((Object)key);
        if (doc != null) {
            LOGGER.debug("removed document at {0}", new Object[]{key});
            return true;
        }
        return false;
    }

    public void removeAll() {
        TransactionStore.TransactionMap<String, Document> txContent = this.transactionalContent(true);
        txContent.clear();
    }

    public void start() {
        MVStore.Builder builder = new MVStore.Builder();
        builder.autoCommitDisabled();
        if (this.compress) {
            builder.compress();
        }
        if (!StringUtil.isBlank((String)this.path)) {
            File file = new File(this.path);
            if (!(file.exists() && file.isDirectory() && file.canRead())) {
                FileUtil.delete((File)file);
                try {
                    Files.createDirectories(Paths.get(this.path, new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new FileProviderException(e);
                }
            }
            builder.fileName(this.path + "/" + FILENAME);
        }
        this.store = builder.open();
        this.txStore = new TransactionStore(this.store);
        this.txStore.init();
        TransactionStore.Transaction tx = this.txStore.begin();
        this.persistedContent = tx.openMap(REPOSITORY_CONTENT);
    }

    public void stop() {
        this.txStore.getOpenTransactions().forEach(TransactionStore.Transaction::rollback);
        this.store.close();
    }

    public void txStarted(String id) {
        LOGGER.debug("New tx '{0}' started...", new Object[]{id});
        String currentTx = ACTIVE_TX_ID.get();
        if (currentTx != null && !id.equals(currentTx)) {
            throw new FileProviderException("ModeShape transaction '" + currentTx + "' already associated to current thread; cannot associate new transaction " + "'" + id + "'");
        }
        ACTIVE_TX_ID.set(id);
        this.transactionalContentById.putIfAbsent(id, (TransactionStore.TransactionMap<String, Document>)this.txStore.begin().openMap(REPOSITORY_CONTENT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void txCommitted(String id) {
        LOGGER.debug("Received committed notification for tx '{0}'", new Object[]{id});
        try {
            TransactionStore.TransactionMap txContent = (TransactionStore.TransactionMap)this.transactionalContentById.remove(id);
            TransactionStore.Transaction tx = txContent.getTransaction();
            tx.commit();
            LOGGER.debug("tx '{0}' committed", new Object[]{id});
        }
        finally {
            ACTIVE_TX_ID.remove();
        }
    }

    public void txRolledback(String id) {
        LOGGER.debug("Received rollback notification for tx '{0}'", new Object[]{id});
        try {
            TransactionStore.Transaction tx = ((TransactionStore.TransactionMap)this.transactionalContentById.remove(id)).getTransaction();
            tx.rollback();
            LOGGER.debug("tx '{0}' rolled back", new Object[]{id});
        }
        finally {
            ACTIVE_TX_ID.remove();
        }
    }

    protected TransactionStore.TransactionMap<String, Document> transactionalContent(boolean failIfMissing) {
        String currentTxId = ACTIVE_TX_ID.get();
        if (currentTxId == null) {
            if (failIfMissing) {
                throw new FileProviderException("An active transaction is required, but wasn't detected");
            }
            return null;
        }
        TransactionStore.TransactionMap result = (TransactionStore.TransactionMap)this.transactionalContentById.get(currentTxId);
        if (result == null) {
            if (failIfMissing) {
                throw new FileProviderException("No MV store transaction was found for tx id '" + currentTxId + "'");
            }
            LOGGER.debug("Found active ModeShape transaction '{0}' without a corresponding MV store transaction; most likely this has been committed off a separate thread", new Object[]{currentTxId});
            ACTIVE_TX_ID.remove();
        }
        return result;
    }
}

