/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.value.PropertyType;

@Immutable
@ThreadSafe
class SingleColumnIndex
extends LuceneIndex {
    protected SingleColumnIndex(String name, String workspaceName, LuceneConfig config, Map<String, PropertyType> propertyTypesByName, ExecutionContext context) {
        super(name, workspaceName, config, propertyTypesByName, context);
    }

    public void add(String nodeKey, String propertyName, Object[] values) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)values, (String)"values");
        try {
            Document document = new Document();
            this.addProperty(nodeKey, document, propertyName, values);
            this.logger.debug("Adding the document '{0}' in the Lucene Index '{1}' with the property '{2}' and values '{3}", new Object[]{nodeKey, this.name, propertyName, values});
            this.writer.updateDocument(FieldUtil.idTerm(nodeKey), (Iterable)document);
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    @Override
    protected void remove(String nodeKey, String propertyName) {
        try {
            this.writer.deleteDocuments(new Term[]{FieldUtil.idTerm(nodeKey)});
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    @Override
    protected LuceneQueryFactory queryFactory(Map<String, Object> variables) {
        return LuceneQueryFactory.forSingleColumnIndex(this.context.getValueFactories(), variables, this.propertyTypesByName);
    }
}

