/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class CompareNameQuery
extends CompareQuery<Name> {
    private final ValueFactory<Name> nameValueFactory;

    protected CompareNameQuery(String field, Name constraintValue, ValueFactory<Name> nameFactory, BiPredicate<Name, Name> evaluator, Function<String, String> caseOperation) {
        super(field, constraintValue, evaluator, caseOperation);
        this.nameValueFactory = nameFactory;
    }

    @Override
    protected Name convertValue(String casedValue) {
        return (Name)this.nameValueFactory.create(casedValue);
    }

    public Query clone() {
        return new CompareNameQuery(this.field(), (Name)this.constraintValue, this.nameValueFactory, this.evaluator, this.caseOperation);
    }

    public static Query createQueryForNodesWithNameEqualTo(Name constraintValue, String fieldName, ValueFactories factories, Function<String, String> caseOperation) {
        return new CompareNameQuery(fieldName, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), Objects::equals, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThan(Name constraintValue, String localNameField, ValueFactories factories, Function<String, String> caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (name1, name2) -> ValueComparators.NAME_COMPARATOR.compare(name1, name2) > 0, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThanOrEqualTo(Name constraintValue, String localNameField, ValueFactories factories, Function<String, String> caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (name1, name2) -> ValueComparators.NAME_COMPARATOR.compare(name1, name2) >= 0, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThan(Name constraintValue, String localNameField, ValueFactories factories, Function<String, String> caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (name1, name2) -> ValueComparators.NAME_COMPARATOR.compare(name1, name2) < 0, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThanOrEqualTo(Name constraintValue, String localNameField, ValueFactories factories, Function<String, String> caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (name1, name2) -> ValueComparators.NAME_COMPARATOR.compare(name1, name2) <= 0, caseOperation);
    }
}

