/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.query.engine.QueryUtil;
import org.modeshape.jcr.value.ValueComparators;

@Immutable
public class CompareStringQuery
extends CompareQuery<String> {
    protected CompareStringQuery(String fieldName, String constraintValue, BiPredicate<String, String> evaluator, Function<String, String> caseOperation) {
        super(fieldName, constraintValue, evaluator, caseOperation);
    }

    @Override
    protected String convertValue(String casedValue) {
        return casedValue;
    }

    public Query clone() {
        return new CompareStringQuery(this.field(), (String)this.constraintValue, this.evaluator, (Function<String, String>)this.caseOperation);
    }

    public static Query createQueryForNodesWithFieldEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        if (caseOperation == null) {
            return new TermQuery(new Term(fieldName, constraintValue));
        }
        return new CompareStringQuery(fieldName, constraintValue, Objects::equals, caseOperation);
    }

    public static Query createQueryForNodesWithFieldGreaterThan(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        if (caseOperation == null) {
            return new TermRangeQuery(fieldName, new BytesRef((CharSequence)constraintValue), null, false, false);
        }
        return new CompareStringQuery(fieldName, constraintValue, (s1, s2) -> ValueComparators.STRING_COMPARATOR.compare(s1, s2) > 0, caseOperation);
    }

    public static Query createQueryForNodesWithFieldGreaterThanOrEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        if (caseOperation == null) {
            return new TermRangeQuery(fieldName, new BytesRef((CharSequence)constraintValue), null, true, false);
        }
        return new CompareStringQuery(fieldName, constraintValue, (s1, s2) -> ValueComparators.STRING_COMPARATOR.compare(s1, s2) >= 0, caseOperation);
    }

    public static Query createQueryForNodesWithFieldLessThan(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        if (caseOperation == null) {
            return new TermRangeQuery(fieldName, null, new BytesRef((CharSequence)constraintValue), false, false);
        }
        return new CompareStringQuery(fieldName, constraintValue, (s1, s2) -> ValueComparators.STRING_COMPARATOR.compare(s1, s2) < 0, caseOperation);
    }

    public static Query createQueryForNodesWithFieldLessThanOrEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        if (caseOperation == null) {
            return new TermRangeQuery(fieldName, null, new BytesRef((CharSequence)constraintValue), true, true);
        }
        return new CompareStringQuery(fieldName, constraintValue, (s1, s2) -> ValueComparators.STRING_COMPARATOR.compare(s1, s2) <= 0, caseOperation);
    }

    protected static Query createQueryForNodesWithFieldLike(String likeExpression, String fieldName, Function<String, String> caseOperation) {
        char firstChar;
        assert (likeExpression != null);
        assert (likeExpression.length() > 0);
        if (!QueryUtil.hasWildcardCharacters((String)likeExpression)) {
            return CompareStringQuery.createQueryForNodesWithFieldEqualTo(likeExpression, fieldName, caseOperation);
        }
        if (caseOperation == null && (firstChar = likeExpression.charAt(0)) != '%' && firstChar != '_' && firstChar != '*' && firstChar != '?') {
            String expression = CompareStringQuery.toWildcardExpression(likeExpression);
            return new WildcardQuery(new Term(fieldName, expression));
        }
        String regex = QueryUtil.toRegularExpression((String)likeExpression);
        int flags = 64;
        if (caseOperation != null) {
            flags |= 2;
        }
        return new RegexpQuery(new Term(fieldName, regex), flags);
    }

    protected static String toWildcardExpression(String likeExpression) {
        return likeExpression.replace('%', '*').replace('_', '?').replaceAll("\\\\(.)", "$1");
    }
}

