/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public abstract class ConstantScoreWeightQuery
extends Query {
    protected static final float SCORE = 1.0f;
    private final String field;

    protected ConstantScoreWeightQuery(String field) {
        CheckArg.isNotNull((Object)field, (String)"field");
        this.field = field;
    }

    protected String field() {
        return this.field;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                BytesRef bytesRef;
                LeafReader leafReader = context.reader();
                Terms terms = leafReader.terms(ConstantScoreWeightQuery.this.field);
                if (terms == null) {
                    return new ConstantScoreScorer((Weight)this, 1.0f, DocIdSetIterator.empty());
                }
                TermsEnum termsEnum = terms.iterator();
                FixedBitSet result = new FixedBitSet(leafReader.maxDoc());
                PostingsEnum postingsEnum = null;
                while ((bytesRef = termsEnum.next()) != null) {
                    int docId;
                    String value = bytesRef.utf8ToString();
                    if (!ConstantScoreWeightQuery.this.accepts(value)) continue;
                    postingsEnum = termsEnum.postings(postingsEnum);
                    while ((docId = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        result.set(docId);
                    }
                }
                return new ConstantScoreScorer((Weight)this, 1.0f, (DocIdSetIterator)new BitSetIterator((BitSet)result, (long)result.cardinality()));
            }
        };
    }

    protected abstract boolean accepts(String var1);

    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && this.field.equals(((ConstantScoreWeightQuery)((Object)obj)).field);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

