/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.ChildCount;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.elasticsearch.EsManagedIndexBuilder;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexUsage;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;

public class EsIndexProvider
extends IndexProvider {
    private String host = "localhost";
    private int port = 9200;
    private EsClient client;

    protected void doInitialize() throws RepositoryException {
        this.logger().debug("Elasticsearch index provider for repository '{0}' is trying to connect to cluster", new Object[]{this.getRepositoryName()});
        this.client = new EsClient(this.host, this.port);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void postShutdown() {
        this.logger().debug("Shutting down the elasticsearch index provider '{0}' in repository '{1}'", new Object[]{this.getName(), this.getRepositoryName()});
    }

    protected int getCostEstimate() {
        return 10000;
    }

    public void validateProposedIndex(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypeSupplier, Problems problems) {
    }

    protected ManagedIndexBuilder getIndexBuilder(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return EsManagedIndexBuilder.create(this.client, this.context(), defn, nodeTypesSupplier, workspaceName, matcher);
    }

    protected IndexUsage evaluateUsage(QueryContext context, final IndexCostCalculator calculator, final IndexDefinition defn) {
        return new IndexUsage(context, calculator, defn){

            protected boolean applies(ChildCount operand) {
                return false;
            }

            protected boolean applies(DynamicOperand operand) {
                if (IndexDefinition.IndexKind.TEXT == defn.getKind() && !(operand instanceof FullTextSearch)) {
                    return false;
                }
                return super.applies(operand);
            }

            protected boolean indexAppliesTo(Or or) {
                boolean appliesToConstraints = super.indexAppliesTo(or);
                if (!appliesToConstraints) {
                    return false;
                }
                Collection joinConditions = calculator.joinConditions();
                if (joinConditions.isEmpty()) {
                    return true;
                }
                for (JoinCondition joinCondition : joinConditions) {
                    if (!(joinCondition instanceof ChildNodeJoinCondition) && !(joinCondition instanceof DescendantNodeJoinCondition)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

