/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.elasticsearch.EsIndexException;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.client.EsResponse;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.schematic.document.Document;

public class SearchResults
implements Filter.Results {
    private final EsClient client;
    private final EsRequest query;
    private final String index;
    private final String type;
    private int pos = 0;
    private int totalHits;

    public SearchResults(EsClient client, String index, String type, EsRequest query) {
        this.client = client;
        this.query = query;
        this.index = index;
        this.type = type;
    }

    public Filter.ResultBatch getNextBatch(int batchSize) {
        this.query.put("from", this.pos);
        this.query.put("size", batchSize);
        try {
            EsResponse res = this.client.search(this.index, this.type, this.query);
            Document hits = (Document)res.get("hits");
            this.totalHits = hits.getInteger("total");
            List items = hits.getArray("hits");
            if (items == null || items.isEmpty()) {
                return Filter.ResultBatch.EMPTY;
            }
            final LinkedHashMap results = items.stream().collect(Collectors.toMap(doc -> new NodeKey(doc.getString("_id")), doc -> Float.valueOf(doc.getDouble("_score").floatValue()), (v1, v2) -> v1, LinkedHashMap::new));
            this.pos += results.size();
            return new Filter.ResultBatch(){

                public Iterable<NodeKey> keys() {
                    return () -> results.keySet().iterator();
                }

                public Iterable<Float> scores() {
                    return () -> results.values().iterator();
                }

                public boolean hasNext() {
                    return SearchResults.this.pos < SearchResults.this.totalHits;
                }

                public int size() {
                    return results.size();
                }
            };
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void close() {
    }

    public long getCardinality() {
        if (this.pos > 0) {
            return this.totalHits;
        }
        try {
            EsResponse res = this.client.search(this.index, this.type, this.query);
            Document hits = (Document)res.get("hits");
            this.totalHits = hits.getInteger("total");
            return this.totalHits;
        }
        catch (Exception e) {
            throw new EsIndexException(e);
        }
    }
}

