/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.client;

import java.io.IOException;
import java.io.OutputStream;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Json;
import org.modeshape.schematic.internal.document.BasicArray;

public class EsRequest {
    private final EditableDocument document;

    public EsRequest() {
        this.document = DocumentFactory.newDocument();
    }

    public EsRequest(Document origin) {
        this.document = DocumentFactory.newDocument((Document)origin);
    }

    public void put(String name, Object value) {
        if (value instanceof EsRequest) {
            this.document.setDocument(name, (Document)((EsRequest)value).document);
        } else {
            this.document.set(name, value);
        }
    }

    public void put(String name, Object[] values) {
        if (values instanceof EsRequest[]) {
            Object[] docs = new Object[values.length];
            for (int i = 0; i < docs.length; ++i) {
                docs[i] = ((EsRequest)values[i]).document;
            }
            this.document.setArray(name, docs);
        } else {
            this.document.setArray(name, values);
        }
    }

    public Object get(String name) {
        Object[] obj = this.document.get(name);
        return obj instanceof BasicArray ? ((BasicArray)obj).toArray() : obj;
    }

    public void remove(String name) {
        this.document.remove(name);
    }

    public void write(OutputStream out) throws IOException {
        Json.write((Document)this.document, (OutputStream)out);
    }

    public String toString() {
        return this.document.toString();
    }
}

