/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.POIFSContainerDetector;
import org.apache.tika.detect.ZipContainerDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ContainerAwareDetector
implements Detector {
    private Detector fallbackDetector;
    private Detector zipDetector;
    private Detector poifsDetector;

    public ContainerAwareDetector(Detector fallbackDetector) {
        this.fallbackDetector = fallbackDetector;
        this.poifsDetector = new POIFSContainerDetector();
        this.zipDetector = new ZipContainerDetector();
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        MediaType type = this.zipDetector.detect(input, metadata);
        if (MediaType.OCTET_STREAM.equals(type)) {
            type = this.poifsDetector.detect(input, metadata);
        }
        if (MediaType.OCTET_STREAM.equals(type)) {
            return this.fallbackDetector.detect(input, metadata);
        }
        return type;
    }
}

