/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.IoUtil;
import org.modeshape.extractor.tika.StringTextExtractorOutput;
import org.modeshape.extractor.tika.TikaTextExtractor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.text.TextExtractorContext;
import org.modeshape.graph.text.TextExtractorOutput;

public class TikaTextExtractorTest {
    private TikaTextExtractor extractor;
    private ExecutionContext execContext;
    private Path inputPath;
    private Set<Property> inputProperties;
    private String mimeType;
    private Problems problems;
    private boolean print = false;
    private LinkedList<String> extracted = null;
    private LinkedList<String> expected = null;

    @Before
    public void beforeEach() {
        this.execContext = new ExecutionContext();
        this.extractor = new TikaTextExtractor();
        this.inputProperties = new HashSet<Property>();
        this.print = false;
        this.extracted = new LinkedList();
        this.expected = new LinkedList();
    }

    @Test
    public void shouldIncludedNoMimeTypesByDefault() {
        Assert.assertThat((Object)this.extractor.getIncludedMimeTypes().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExcludedPackageTypeMimeTypesByDefault() {
        Assert.assertThat((Object)this.extractor.getExcludedMimeTypes().containsAll(TikaTextExtractor.DEFAULT_EXCLUDED_MIME_TYPES), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSupportExtractingFromTextFiles() throws IOException {
        Assert.assertThat((Object)this.extractor.supportsMimeType(this.mimeTypeOf("modeshape.txt")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSupportExtractingFromPdfFiles() throws IOException {
        Assert.assertThat((Object)this.extractor.supportsMimeType(this.mimeTypeOf("modeshape.pdf")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotSupportExtractingFromPostscriptFiles() throws IOException {
        Assert.assertThat((Object)this.extractor.supportsMimeType(this.mimeTypeOf("modeshape.ps")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSupportExtractingFromDocWordFiles() throws IOException {
        Assert.assertThat((Object)this.extractor.supportsMimeType(this.mimeTypeOf("modeshape.doc")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSupportExtractingFromDocxWordFiles() throws IOException {
        Assert.assertThat((Object)this.extractor.supportsMimeType(this.mimeTypeOf("modeshape.docx")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExtractTextFromTextFile() throws IOException {
        this.extractTermsFrom("modeshape.txt");
        this.loadExpectedFrom("modeshape.txt");
        this.extractedShouldHave(this.remainingExpectedTerms());
    }

    @Test
    public void shouldExtractTextFromDocFile() throws IOException {
        this.extractTermsFrom("modeshape.doc");
        this.loadExpectedFrom("modeshape.txt");
        this.extractedShouldHave(this.remainingExpectedTerms());
    }

    @Test
    public void shouldExtractTextFromDocxFile() throws IOException {
        this.print = true;
        this.extractTermsFrom("modeshape.docx");
        this.loadExpectedFrom("modeshape.txt");
    }

    @Test
    public void shouldExtractTextFromPdfFile() throws IOException {
        this.extractTermsFrom("modeshape.pdf");
        this.loadExpectedFrom("modeshape.txt");
        this.extractedShouldHave("2011-01-24");
        this.extractedShouldHave(this.expectedTermsThrough("-", "versioning"));
        this.extractedShouldHave("-", "1/2", "-");
        this.loadExpectedFrom("modeshape.txt");
        this.expectedTermsThrough("managing", "this", "complex", "and");
        this.extractedShouldHave(this.expectedTermsThrough("-", "versioning"));
        this.extractedShouldHave("2011-01-24");
        this.extractedShouldHave(this.remainingExpectedTerms());
    }

    protected Path path(String path) {
        return (Path)this.execContext.getValueFactories().getPathFactory().create(path);
    }

    protected List<String> remainingExpectedTerms() {
        return this.expected;
    }

    protected void extractedShouldHave(String ... words) {
        for (String word : words) {
            Assert.assertThat((Object)this.extracted.pop(), (Matcher)Is.is((Object)word));
        }
    }

    protected void extractedShouldHave(List<String> words) {
        for (String word : words) {
            Assert.assertThat((Object)this.extracted.pop(), (Matcher)Is.is((Object)word));
        }
    }

    protected List<String> expectedTermsThrough(String ... words) {
        if (words == null || words.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        String nextWord = words[0];
        while (nextWord != null && !this.expected.isEmpty()) {
            String word = this.expected.pop();
            result.add(word);
            if (!word.equals(nextWord)) continue;
            boolean foundAll = true;
            for (int i = 1; i != words.length; ++i) {
                String next = this.expected.pop();
                result.add(next);
                if (next.equals(words[i])) continue;
                foundAll = false;
                break;
            }
            if (!foundAll) continue;
            return result;
        }
        System.out.println("expected terms thru " + words + " are: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractTermsFrom(String resourcePath) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            if (this.inputPath == null) {
                this.inputPath = this.path(resourcePath);
            }
            if (this.mimeType == null) {
                this.mimeType = this.execContext.getMimeTypeDetector().mimeTypeOf(resourcePath, null);
            }
            if (this.problems == null) {
                this.problems = new SimpleProblems();
            }
            TextExtractorContext context = new TextExtractorContext(this.execContext, this.inputPath, this.inputProperties, this.mimeType, this.problems);
            StringTextExtractorOutput output = new StringTextExtractorOutput();
            this.extractor.extractFrom(stream, (TextExtractorOutput)output, context);
            String result = ((Object)output).toString();
            if (this.print) {
                System.out.println("Text extracted from \"" + resourcePath + "\"");
                System.out.println("============================================");
                System.out.println(result);
            }
            if (!this.problems.isEmpty()) {
                System.out.println(this.problems);
                Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
            }
            this.addWords(this.extracted, ((Object)output).toString());
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExpectedFrom(String resourcePath) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            this.addWords(this.expected, IoUtil.read((InputStream)stream));
        }
        finally {
            stream.close();
        }
    }

    protected void addWords(List<String> words, String input) {
        for (String word : input.split("[\\s\"]+")) {
            if (word.length() <= 0) continue;
            words.add(word);
        }
    }

    protected String mimeTypeOf(String resourcePath) throws IOException {
        return this.execContext.getMimeTypeDetector().mimeTypeOf(resourcePath, null);
    }
}

