/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.MailboxListField;
import org.apache.james.mime4j.field.UnstructuredField;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class MailContentHandler
implements ContentHandler {
    private XHTMLContentHandler handler;
    private Metadata metadata;
    private boolean inPart = false;

    MailContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.handler = xhtml;
        this.metadata = metadata;
    }

    public void body(BodyDescriptor body, InputStream is) throws MimeException, IOException {
        AutoDetectParser parser = new AutoDetectParser();
        Metadata submd = new Metadata();
        submd.set("Content-Type", body.getMimeType());
        submd.set("Content-Encoding", body.getCharset());
        try {
            BodyContentHandler bch = new BodyContentHandler(this.handler);
            parser.parse(is, new EmbeddedContentHandler(bch), submd);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
    }

    public void endBodyPart() throws MimeException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void endHeader() throws MimeException {
    }

    public void startMessage() throws MimeException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void endMessage() throws MimeException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void endMultipart() throws MimeException {
        this.inPart = false;
    }

    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    public void field(Field field) throws MimeException {
        if (this.inPart) {
            return;
        }
        String fieldname = field.getName();
        if (fieldname.equalsIgnoreCase("From")) {
            MailboxListField fromField = (MailboxListField)AbstractField.parse((ByteSequence)field.getRaw());
            MailboxList mailboxList = fromField.getMailboxList();
            for (int i = 0; i < mailboxList.size(); ++i) {
                this.metadata.add("Author", mailboxList.get(i).getDisplayString());
            }
        } else if (fieldname.equalsIgnoreCase("Subject")) {
            UnstructuredField subjectField = (UnstructuredField)AbstractField.parse((ByteSequence)field.getRaw());
            this.metadata.add("subject", subjectField.getValue());
        }
    }

    public void preamble(InputStream is) throws MimeException, IOException {
    }

    public void raw(InputStream is) throws MimeException, IOException {
    }

    public void startBodyPart() throws MimeException {
        try {
            this.handler.startElement("div", "class", "email-entry");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void startHeader() throws MimeException {
    }

    public void startMultipart(BodyDescriptor descr) throws MimeException {
        this.inPart = true;
    }
}

