/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.tika.detect.ZipContainerDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private final EmbeddedDocumentExtractor extractor;

    protected AbstractPOIFSExtractor(ParseContext context) {
        EmbeddedDocumentExtractor ex = context.get(EmbeddedDocumentExtractor.class);
        this.extractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            Metadata metadata = new Metadata();
            if (filename != null) {
                metadata.set("tika.mime.file", filename);
                metadata.set("resourceName", filename);
            }
            if (mediaType != null) {
                metadata.set("Content-Type", mediaType);
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                this.extractor.parseEmbedded(resource, xhtml, metadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbededOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        try {
            Entry ooxml = dir.getEntry("Package");
            TikaInputStream stream = TikaInputStream.get(new DocumentInputStream((DocumentEntry)ooxml));
            try {
                ZipContainerDetector detector = new ZipContainerDetector();
                MediaType type = detector.detect(stream, new Metadata());
                this.handleEmbeddedResource(stream, null, type.toString(), xhtml, true);
                return;
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            POIFSFileSystem newFS = new POIFSFileSystem();
            this.copy(dir, newFS.getRoot());
            File tmpFile = File.createTempFile("tika", ".ole2");
            try {
                TikaInputStream embedded;
                FileOutputStream out = new FileOutputStream(tmpFile);
                newFS.writeFilesystem(out);
                out.close();
                Metadata metadata = new Metadata();
                OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
                if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                    Entry entry = dir.getEntry("\u0001Ole10Native");
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy(new DocumentInputStream((DocumentEntry)entry), bos);
                    byte[] data = bos.toByteArray();
                    try {
                        Ole10Native ole = new Ole10Native(data, 0);
                        byte[] dataBuffer = ole.getDataBuffer();
                        metadata.set("resourceName", dir.getName() + '/' + ole.getLabel());
                        embedded = TikaInputStream.get(dataBuffer);
                    }
                    catch (Ole10NativeException ex) {
                        embedded = TikaInputStream.get(data);
                    }
                } else {
                    metadata.set("Content-Type", type.getType().toString());
                    metadata.set("resourceName", dir.getName() + '.' + type.getExtension());
                    embedded = TikaInputStream.get(tmpFile);
                }
                try {
                    if (this.extractor.shouldParseEmbedded(metadata)) {
                        this.extractor.parseEmbedded(embedded, xhtml, metadata, true);
                    }
                }
                finally {
                    embedded.close();
                }
            }
            finally {
                tmpFile.delete();
            }
            return;
        }
    }

    protected void copy(DirectoryEntry sourceDir, DirectoryEntry destDir) throws IOException {
        for (Entry entry : sourceDir) {
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry newDir = destDir.createDirectory(entry.getName());
                this.copy((DirectoryEntry)entry, newDir);
                continue;
            }
            DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);
            destDir.createDocument(entry.getName(), contents);
        }
    }
}

