/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public class PictureDescriptor {
    private static final int LCB_OFFSET = 0;
    private static final int CBHEADER_OFFSET = 4;
    private static final int MFP_MM_OFFSET = 6;
    private static final int MFP_XEXT_OFFSET = 8;
    private static final int MFP_YEXT_OFFSET = 10;
    private static final int MFP_HMF_OFFSET = 12;
    private static final int DXAGOAL_OFFSET = 28;
    private static final int DYAGOAL_OFFSET = 30;
    private static final int MX_OFFSET = 32;
    private static final int MY_OFFSET = 34;
    private static final int DXACROPLEFT_OFFSET = 36;
    private static final int DYACROPTOP_OFFSET = 38;
    private static final int DXACROPRIGHT_OFFSET = 40;
    private static final int DYACROPBOTTOM_OFFSET = 42;
    protected int lcb;
    protected int cbHeader;
    protected int mfp_mm;
    protected int mfp_xExt;
    protected int mfp_yExt;
    protected int mfp_hMF;
    protected byte[] offset14 = new byte[14];
    protected short dxaGoal = 0;
    protected short dyaGoal = 0;
    protected short mx;
    protected short my;
    protected short dxaCropLeft = 0;
    protected short dyaCropTop = 0;
    protected short dxaCropRight = 0;
    protected short dyaCropBottom = 0;

    public PictureDescriptor() {
    }

    public PictureDescriptor(byte[] _dataStream, int startOffset) {
        this.lcb = LittleEndian.getInt(_dataStream, startOffset + 0);
        this.cbHeader = LittleEndian.getUShort(_dataStream, startOffset + 4);
        this.mfp_mm = LittleEndian.getUShort(_dataStream, startOffset + 6);
        this.mfp_xExt = LittleEndian.getUShort(_dataStream, startOffset + 8);
        this.mfp_yExt = LittleEndian.getUShort(_dataStream, startOffset + 10);
        this.mfp_hMF = LittleEndian.getUShort(_dataStream, startOffset + 12);
        this.offset14 = LittleEndian.getByteArray(_dataStream, startOffset + 14, 14);
        this.dxaGoal = LittleEndian.getShort(_dataStream, startOffset + 28);
        this.dyaGoal = LittleEndian.getShort(_dataStream, startOffset + 30);
        this.mx = LittleEndian.getShort(_dataStream, startOffset + 32);
        this.my = LittleEndian.getShort(_dataStream, startOffset + 34);
        this.dxaCropLeft = LittleEndian.getShort(_dataStream, startOffset + 36);
        this.dyaCropTop = LittleEndian.getShort(_dataStream, startOffset + 38);
        this.dxaCropRight = LittleEndian.getShort(_dataStream, startOffset + 40);
        this.dyaCropBottom = LittleEndian.getShort(_dataStream, startOffset + 42);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PICF]\n");
        stringBuilder.append("        lcb           = ").append(this.lcb).append('\n');
        stringBuilder.append("        cbHeader      = ").append(this.cbHeader).append('\n');
        stringBuilder.append("        mfp.mm        = ").append(this.mfp_mm).append('\n');
        stringBuilder.append("        mfp.xExt      = ").append(this.mfp_xExt).append('\n');
        stringBuilder.append("        mfp.yExt      = ").append(this.mfp_yExt).append('\n');
        stringBuilder.append("        mfp.hMF       = ").append(this.mfp_hMF).append('\n');
        stringBuilder.append("        offset14      = ").append(Arrays.toString(this.offset14)).append('\n');
        stringBuilder.append("        dxaGoal       = ").append(this.dxaGoal).append('\n');
        stringBuilder.append("        dyaGoal       = ").append(this.dyaGoal).append('\n');
        stringBuilder.append("        dxaCropLeft   = ").append(this.dxaCropLeft).append('\n');
        stringBuilder.append("        dyaCropTop    = ").append(this.dyaCropTop).append('\n');
        stringBuilder.append("        dxaCropRight  = ").append(this.dxaCropRight).append('\n');
        stringBuilder.append("        dyaCropBottom = ").append(this.dyaCropBottom).append('\n');
        stringBuilder.append("[/PICF]");
        return stringBuilder.toString();
    }
}

