/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.util.LittleEndian;

public final class PlexOfCps {
    private int _iMac;
    private int _offset;
    private int _cbStruct;
    private ArrayList<GenericPropertyNode> _props;

    public PlexOfCps(int sizeOfStruct) {
        this._props = new ArrayList();
        this._cbStruct = sizeOfStruct;
    }

    public PlexOfCps(byte[] buf, int start, int cb, int cbStruct) {
        this._iMac = (cb - 4) / (4 + cbStruct);
        this._cbStruct = cbStruct;
        this._props = new ArrayList(this._iMac);
        for (int x = 0; x < this._iMac; ++x) {
            this._props.add(this.getProperty(x, buf, start));
        }
    }

    public GenericPropertyNode getProperty(int index) {
        return this._props.get(index);
    }

    public void addProperty(GenericPropertyNode node) {
        this._props.add(node);
    }

    public byte[] toByteArray() {
        int size = this._props.size();
        int cpBufSize = (size + 1) * 4;
        int structBufSize = this._cbStruct * size;
        int bufSize = cpBufSize + structBufSize;
        byte[] buf = new byte[bufSize];
        GenericPropertyNode node = null;
        for (int x = 0; x < size; ++x) {
            node = this._props.get(x);
            LittleEndian.putInt(buf, 4 * x, node.getStart());
            System.arraycopy(node.getBytes(), 0, buf, cpBufSize + x * this._cbStruct, this._cbStruct);
        }
        LittleEndian.putInt(buf, 4 * size, node.getEnd());
        return buf;
    }

    private GenericPropertyNode getProperty(int index, byte[] buf, int offset) {
        int start = LittleEndian.getInt(buf, offset + this.getIntOffset(index));
        int end = LittleEndian.getInt(buf, offset + this.getIntOffset(index + 1));
        byte[] struct = new byte[this._cbStruct];
        System.arraycopy(buf, offset + this.getStructOffset(index), struct, 0, this._cbStruct);
        return new GenericPropertyNode(start, end, struct);
    }

    private int getIntOffset(int index) {
        return index * 4;
    }

    public int length() {
        return this._iMac;
    }

    private int getStructOffset(int index) {
        return 4 * (this._iMac + 1) + this._cbStruct * index;
    }

    GenericPropertyNode[] toPropertiesArray() {
        if (this._props == null || this._props.isEmpty()) {
            return new GenericPropertyNode[0];
        }
        return this._props.toArray(new GenericPropertyNode[this._props.size()]);
    }

    public String toString() {
        return "PLCF (cbStruct: " + this._cbStruct + "; iMac: " + this._iMac + ")";
    }
}

