/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ScatterChartData;
import org.apache.poi.ss.usermodel.charts.ScatterChartSerie;
import org.apache.poi.ss.util.DataMarker;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.charts.XSSFNumberCache;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STScatterStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFScatterChartData
implements ScatterChartData {
    private List<Serie> series = new ArrayList<Serie>();

    @Override
    public ScatterChartSerie addSerie(DataMarker xMarker, DataMarker yMarker) {
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries);
        newSerie.setXValues(xMarker);
        newSerie.setYValues(yMarker);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xssfChart = (XSSFChart)chart;
        CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
        CTScatterChart scatterChart = plotArea.addNewScatterChart();
        this.addStyle(scatterChart);
        for (Serie s : this.series) {
            s.addToChart(scatterChart);
        }
        for (ChartAxis ax : axis) {
            scatterChart.addNewAxId().setVal(ax.getId());
        }
    }

    public List<? extends Serie> getSeries() {
        return this.series;
    }

    private void addStyle(CTScatterChart ctScatterChart) {
        CTScatterStyle scatterStyle = ctScatterChart.addNewScatterStyle();
        scatterStyle.setVal(STScatterStyle.LINE_MARKER);
    }

    static class Serie
    implements ScatterChartSerie {
        private int id;
        private int order;
        private boolean useCache;
        private DataMarker xMarker;
        private DataMarker yMarker;
        private XSSFNumberCache lastCaclulatedXCache;
        private XSSFNumberCache lastCalculatedYCache;

        protected Serie(int id, int order) {
            this.id = id;
            this.order = order;
            this.useCache = true;
        }

        public void setXValues(DataMarker marker) {
            this.xMarker = marker;
        }

        public void setYValues(DataMarker marker) {
            this.yMarker = marker;
        }

        public void setUseCache(boolean useCache) {
            this.useCache = useCache;
        }

        XSSFNumberCache getLastCaculatedXCache() {
            return this.lastCaclulatedXCache;
        }

        XSSFNumberCache getLastCalculatedYCache() {
            return this.lastCalculatedYCache;
        }

        protected void addToChart(CTScatterChart ctScatterChart) {
            CTScatterSer scatterSer = ctScatterChart.addNewSer();
            scatterSer.addNewIdx().setVal(this.id);
            scatterSer.addNewOrder().setVal(this.order);
            CTAxDataSource xVal = scatterSer.addNewXVal();
            CTNumRef xNumRef = xVal.addNewNumRef();
            xNumRef.setF(this.xMarker.formatAsString());
            CTNumDataSource yVal = scatterSer.addNewYVal();
            CTNumRef yNumRef = yVal.addNewNumRef();
            yNumRef.setF(this.yMarker.formatAsString());
            if (this.useCache) {
                XSSFNumberCache.buildCache(this.xMarker, xNumRef);
                this.lastCalculatedYCache = XSSFNumberCache.buildCache(this.yMarker, yNumRef);
            }
        }
    }
}

