/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.xml.AbstractMetadataHandler;
import org.xml.sax.Attributes;

public class ElementMetadataHandler
extends AbstractMetadataHandler {
    private final String uri;
    private final String localName;
    private final StringBuilder buffer = new StringBuilder();
    private int matchLevel = 0;

    public ElementMetadataHandler(String uri, String localName, Metadata metadata, String name) {
        super(metadata, name);
        this.uri = uri;
        this.localName = localName;
    }

    protected boolean isMatchingElement(String uri, String localName) {
        return uri.equals(this.uri) && localName.equals(this.localName);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (this.isMatchingElement(uri, localName)) {
            ++this.matchLevel;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (this.isMatchingElement(uri, localName)) {
            --this.matchLevel;
            if (this.matchLevel == 0) {
                this.addMetadata(this.buffer.toString().trim());
                this.buffer.setLength(0);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.matchLevel > 0) {
            this.buffer.append(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }
}

