/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.LineCap;
import org.apache.poi.xslf.usermodel.LineDash;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;

public abstract class XSLFSimpleShape
extends XSLFShape {
    private final XmlObject _shape;
    private final XSLFSheet _sheet;
    private CTShapeProperties _spPr;
    private CTNonVisualDrawingProps _nvPr;

    XSLFSimpleShape(XmlObject shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    public XmlObject getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public int getShapeType() {
        STShapeType.Enum stEnum = this.getSpPr().getPrstGeom().getPrst();
        return stEnum.intValue();
    }

    public String getShapeName() {
        return this.getNvPr().getName();
    }

    public int getShapeId() {
        return (int)this.getNvPr().getId();
    }

    protected CTNonVisualDrawingProps getNvPr() {
        XmlObject[] rs;
        if (this._nvPr == null && (rs = this._shape.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr")).length != 0) {
            this._nvPr = (CTNonVisualDrawingProps)rs[0];
        }
        return this._nvPr;
    }

    protected CTShapeProperties getSpPr() {
        if (this._spPr == null) {
            for (XmlObject obj : this._shape.selectPath("*")) {
                if (!(obj instanceof CTShapeProperties)) continue;
                this._spPr = (CTShapeProperties)obj;
            }
        }
        if (this._spPr == null) {
            throw new IllegalStateException("CTShapeProperties was not found.");
        }
        return this._spPr;
    }

    public Rectangle2D getAnchor() {
        CTTransform2D xfrm = this.getSpPr().getXfrm();
        CTPoint2D off = xfrm.getOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    public void setAnchor(Rectangle2D anchor) {
        CTTransform2D xfrm = this.getSpPr().isSetXfrm() ? this.getSpPr().getXfrm() : this.getSpPr().addNewXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    public void setRotation(double theta) {
        CTTransform2D xfrm = this.getSpPr().getXfrm();
        xfrm.setRot((int)(theta * 60000.0));
    }

    public double getRotation() {
        CTTransform2D xfrm = this.getSpPr().getXfrm();
        return (double)xfrm.getRot() / 60000.0;
    }

    public void setFlipHorizontal(boolean flip) {
        CTTransform2D xfrm = this.getSpPr().getXfrm();
        xfrm.setFlipH(flip);
    }

    public void setFlipVertical(boolean flip) {
        CTTransform2D xfrm = this.getSpPr().getXfrm();
        xfrm.setFlipV(flip);
    }

    public boolean getFlipHorizontal() {
        return this.getSpPr().getXfrm().getFlipH();
    }

    public boolean getFlipVertical() {
        return this.getSpPr().getXfrm().getFlipV();
    }

    public void setLineColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetSolidFill()) {
                spPr.getLn().unsetSolidFill();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            CTSolidColorFillProperties fill = ln.isSetSolidFill() ? ln.getSolidFill() : ln.addNewSolidFill();
            fill.setSrgbClr(rgb);
        }
    }

    public Color getLineColor() {
        CTShapeProperties spPr = this.getSpPr();
        if (!spPr.isSetLn() || !spPr.getLn().isSetSolidFill()) {
            return null;
        }
        CTSRgbColor rgb = spPr.getLn().getSolidFill().getSrgbClr();
        byte[] val = rgb.getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    public void setLineWidth(double width) {
        CTShapeProperties spPr = this.getSpPr();
        if (width == 0.0) {
            if (spPr.isSetLn()) {
                spPr.getLn().unsetW();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setW(Units.toEMU(width));
        }
    }

    public double getLineWidth() {
        CTShapeProperties spPr = this.getSpPr();
        CTLineProperties ln = spPr.getLn();
        if (ln == null || !ln.isSetW()) {
            return 0.0;
        }
        return Units.toPoints(ln.getW());
    }

    public void setLineDash(LineDash dash) {
        CTShapeProperties spPr = this.getSpPr();
        if (dash == null) {
            if (spPr.isSetLn()) {
                spPr.getLn().unsetPrstDash();
            }
        } else {
            CTPresetLineDashProperties val = CTPresetLineDashProperties.Factory.newInstance();
            val.setVal(STPresetLineDashVal.Enum.forInt(dash.ordinal() + 1));
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setPrstDash(val);
        }
    }

    public LineDash getLineDash() {
        CTShapeProperties spPr = this.getSpPr();
        CTLineProperties ln = spPr.getLn();
        if (ln == null || !ln.isSetPrstDash()) {
            return null;
        }
        CTPresetLineDashProperties dash = ln.getPrstDash();
        return LineDash.values()[dash.getVal().intValue() - 1];
    }

    public void setLineCap(LineCap cap) {
        CTShapeProperties spPr = this.getSpPr();
        if (cap == null) {
            if (spPr.isSetLn()) {
                spPr.getLn().unsetCap();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setCap(STLineCap.Enum.forInt(cap.ordinal() + 1));
        }
    }

    public LineCap getLineCap() {
        CTShapeProperties spPr = this.getSpPr();
        CTLineProperties ln = spPr.getLn();
        if (ln == null || !ln.isSetCap()) {
            return null;
        }
        return LineCap.values()[ln.getCap().intValue() - 1];
    }
}

