/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.mbox.MboxParser;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class OutlookExtractor
extends AbstractPOIFSExtractor {
    private final MAPIMessage msg;

    public OutlookExtractor(NPOIFSFileSystem filesystem, ParseContext context) throws TikaException {
        this(filesystem.getRoot(), context);
    }

    public OutlookExtractor(DirectoryNode root, ParseContext context) throws TikaException {
        super(context);
        try {
            this.msg = new MAPIMessage(root);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook message", e);
        }
    }

    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException, IOException {
        try {
            String from;
            String subject;
            block37: {
                this.msg.setReturnNullOnMissingChunk(true);
                if (this.msg.has7BitEncodingStrings()) {
                    if (this.msg.getHeaders() != null) {
                        this.msg.guess7BitEncoding();
                    } else {
                        StringChunk text = this.msg.getMainChunks().textBodyChunk;
                        if (text != null) {
                            CharsetDetector detector = new CharsetDetector();
                            detector.setText(text.getRawValue());
                            CharsetMatch match = detector.detect();
                            if (match.getConfidence() > 35) {
                                this.msg.set7BitEncoding(match.getName());
                            }
                        }
                    }
                }
                subject = this.msg.getSubject();
                from = this.msg.getDisplayFrom();
                metadata.set("Author", from);
                metadata.set("Message-From", from);
                metadata.set("Message-To", this.msg.getDisplayTo());
                metadata.set("Message-Cc", this.msg.getDisplayCC());
                metadata.set("Message-Bcc", this.msg.getDisplayBCC());
                metadata.set("title", subject);
                metadata.set("subject", this.msg.getConversationTopic());
                try {
                    for (String recipientAddress : this.msg.getRecipientEmailAddressList()) {
                        if (recipientAddress == null) continue;
                        metadata.add("Message-Recipient-Address", recipientAddress);
                    }
                }
                catch (ChunkNotFoundException he) {
                    // empty catch block
                }
                if (this.msg.getMessageDate() != null) {
                    metadata.set(Metadata.DATE, this.msg.getMessageDate().getTime());
                    metadata.set(Metadata.CREATION_DATE, this.msg.getMessageDate().getTime());
                    metadata.set(Metadata.LAST_SAVED, this.msg.getMessageDate().getTime());
                } else {
                    try {
                        String[] headers = this.msg.getHeaders();
                        if (headers == null || headers.length <= 0) break block37;
                        for (String header : headers) {
                            if (!header.toLowerCase().startsWith("date:")) continue;
                            String date = header.substring(header.indexOf(58) + 1).trim();
                            try {
                                Date d = MboxParser.parseDate(date);
                                metadata.set(Metadata.DATE, d);
                                metadata.set(Metadata.CREATION_DATE, d);
                                metadata.set(Metadata.LAST_SAVED, d);
                            }
                            catch (ParseException e) {
                                metadata.set(Metadata.DATE, date);
                                metadata.set(Metadata.CREATION_DATE, date);
                                metadata.set(Metadata.LAST_SAVED, date);
                            }
                            break;
                        }
                    }
                    catch (ChunkNotFoundException he) {
                        // empty catch block
                    }
                }
            }
            xhtml.element("h1", subject);
            xhtml.startElement("dl");
            if (from != null) {
                this.header(xhtml, "From", from);
            }
            this.header(xhtml, "To", this.msg.getDisplayTo());
            this.header(xhtml, "Cc", this.msg.getDisplayCC());
            this.header(xhtml, "Bcc", this.msg.getDisplayBCC());
            try {
                this.header(xhtml, "Recipients", this.msg.getRecipientEmailAddress());
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            xhtml.endElement("dl");
            Chunk htmlChunk = null;
            Chunk rtfChunk = null;
            Chunk textChunk = null;
            for (Chunk chunk : this.msg.getMainChunks().getAll()) {
                if (chunk.getChunkId() == MAPIProperty.BODY_HTML.id) {
                    htmlChunk = chunk;
                }
                if (chunk.getChunkId() == MAPIProperty.RTF_COMPRESSED.id) {
                    rtfChunk = chunk;
                }
                if (chunk.getChunkId() != MAPIProperty.BODY.id) continue;
                textChunk = chunk;
            }
            boolean doneBody = false;
            if (htmlChunk != null) {
                byte[] data = null;
                if (htmlChunk instanceof ByteChunk) {
                    data = ((ByteChunk)htmlChunk).getValue();
                } else if (htmlChunk instanceof StringChunk) {
                    data = ((StringChunk)htmlChunk).getRawValue();
                }
                if (data != null) {
                    HtmlParser htmlParser = new HtmlParser();
                    htmlParser.parse(new ByteArrayInputStream(data), new BodyContentHandler(xhtml), new Metadata(), new ParseContext());
                    doneBody = true;
                }
            }
            if (rtfChunk != null && !doneBody) {
                ByteChunk chunk = (ByteChunk)rtfChunk;
                MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, 258, chunk.getValue());
                RTFParser rtfParser = new RTFParser();
                rtfParser.parse(new ByteArrayInputStream(rtf.getData()), xhtml, new Metadata(), new ParseContext());
                doneBody = true;
            }
            if (textChunk != null && !doneBody) {
                xhtml.element("p", ((StringChunk)textChunk).getValue());
            }
            for (AttachmentChunks attachment : this.msg.getAttachmentFiles()) {
                xhtml.startElement("div", "class", "attachment-entry");
                String filename = null;
                if (attachment.attachLongFileName != null) {
                    filename = attachment.attachLongFileName.getValue();
                } else if (attachment.attachFileName != null) {
                    filename = attachment.attachFileName.getValue();
                }
                if (filename != null && filename.length() > 0) {
                    xhtml.element("h1", filename);
                }
                if (attachment.attachData != null) {
                    this.handleEmbeddedResource(TikaInputStream.get(attachment.attachData.getValue()), filename, null, xhtml, true);
                }
                if (attachment.attachmentDirectory != null) {
                    this.handleEmbeddedOfficeDoc(attachment.attachmentDirectory.getDirectory(), xhtml);
                }
                xhtml.endElement("div");
            }
        }
        catch (ChunkNotFoundException e) {
            throw new TikaException("POI MAPIMessage broken - didn't return null on missing chunk", e);
        }
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value != null && value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }
}

