/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;

public class TikaMimeTypeDetector
extends MimeTypeDetector {
    public String mimeTypeOf(final String name, Binary binaryValue) throws RepositoryException, IOException {
        CheckArg.isNotNull((Object)binaryValue, (String)"binaryValue");
        return (String)this.processStream(binaryValue, (MimeTypeDetector.StreamOperation)new MimeTypeDetector.StreamOperation<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String execute(InputStream stream) throws IOException {
                Metadata metadata = new Metadata();
                if (!StringUtil.isBlank((String)name)) {
                    metadata.set("resourceName", name);
                }
                TemporaryResources tmp = new TemporaryResources();
                try {
                    TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
                    MediaType autoDetectedMimeType = new DefaultDetector(this.getClass().getClassLoader()).detect((InputStream)tikaInputStream, metadata);
                    String string = autoDetectedMimeType.toString();
                    return string;
                }
                finally {
                    tmp.close();
                }
            }
        });
    }
}

