/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import junit.framework.Assert;
import org.junit.Test;
import org.modeshape.jcr.SingleUseAbstractTest;
import org.modeshape.jcr.api.JcrTools;

public class TikaTextExtractorRepositoryTest
extends SingleUseAbstractTest {
    private JcrTools jcrTools = new JcrTools();

    public void beforeEach() throws Exception {
        this.startRepositoryWithConfiguration(this.getResource("repo-config.json"));
    }

    @Test
    public void shouldExtractAndIndexContentFromPlainTextFile() throws Exception {
        this.uploadFile("text-file.txt");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'The Quick Red Fox Jumps Over the Lazy Brown Dog')");
    }

    @Test
    public void shouldExtractAndIndexContentFromDocFile() throws Exception {
        this.uploadFile("modeshape.doc");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'ModeShape supports')");
    }

    @Test
    public void shouldExtractAndIndexContentFromPdfGSFile() throws Exception {
        this.uploadFile("modeshape_gs.pdf");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'ModeShape supports')");
    }

    private void assertExtractedTextHasBeenIndexed(String validationQuery) throws RepositoryException {
        Query query = this.jcrSession().getWorkspace().getQueryManager().createQuery(validationQuery, "JCR-SQL2");
        QueryResult result = query.execute();
        Assert.assertEquals((String)"Node with text content not found", (long)1L, (long)result.getNodes().getSize());
    }

    private void uploadFile(String filepath) throws RepositoryException, IOException, InterruptedException {
        this.jcrTools.uploadFile((Session)this.session, "/" + filepath, this.getResource(filepath));
        this.session.save();
        Thread.sleep(500L);
    }

    private InputStream getResource(String path) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
    }
}

