/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.eval.NotImplementedException;

public class FractionFormat
extends Format {
    private static final Pattern DENOM_FORMAT_PATTERN = Pattern.compile("(?:(#+)|(\\d+))");
    private static final int MAX_DENOM_POW = 4;
    private final int exactDenom;
    private final int maxDenom;
    private final String wholePartFormatString;

    public FractionFormat(String wholePartFormatString, String denomFormatString) {
        this.wholePartFormatString = wholePartFormatString;
        Matcher m = DENOM_FORMAT_PATTERN.matcher(denomFormatString);
        int tmpExact = -1;
        int tmpMax = -1;
        if (m.find()) {
            if (m.group(2) != null) {
                try {
                    tmpExact = Integer.parseInt(m.group(2));
                    if (tmpExact == 0) {
                        tmpExact = -1;
                    }
                }
                catch (NumberFormatException e) {}
            } else if (m.group(1) != null) {
                int len = m.group(1).length();
                len = len > 4 ? 4 : len;
                tmpMax = (int)Math.pow(10.0, len);
            } else {
                tmpExact = 100;
            }
        }
        if (tmpExact <= 0 && tmpMax <= 0) {
            tmpExact = 100;
        }
        this.exactDenom = tmpExact;
        this.maxDenom = tmpMax;
    }

    public String format(Number num) {
        double decPart;
        double doubleValue = num.doubleValue();
        boolean isNeg = doubleValue < 0.0;
        double absDoubleValue = Math.abs(doubleValue);
        double wholePart = Math.floor(absDoubleValue);
        if (wholePart + (decPart = absDoubleValue - wholePart) == 0.0) {
            return "0";
        }
        if (absDoubleValue < (double)(1 / Math.max(this.exactDenom, this.maxDenom))) {
            return "0";
        }
        if (wholePart + (double)((int)decPart) == wholePart + decPart) {
            StringBuilder sb = new StringBuilder();
            if (isNeg) {
                sb.append("-");
            }
            sb.append(Integer.toString((int)wholePart));
            return sb.toString();
        }
        SimpleFraction fract = null;
        try {
            fract = this.exactDenom > 0 ? this.calcFractionExactDenom(decPart, this.exactDenom) : this.calcFractionMaxDenom(decPart, this.maxDenom);
        }
        catch (SimpleFractionException e) {
            e.printStackTrace();
            return Double.toString(doubleValue);
        }
        StringBuilder sb = new StringBuilder();
        if (isNeg) {
            sb.append("-");
        }
        if ("".equals(this.wholePartFormatString)) {
            int trueNum = fract.getDenominator() * (int)wholePart + fract.getNumerator();
            sb.append(trueNum).append("/").append(fract.getDenominator());
            return sb.toString();
        }
        if (fract.getNumerator() == 0) {
            sb.append(Integer.toString((int)wholePart));
            return sb.toString();
        }
        if (fract.getNumerator() == fract.getDenominator()) {
            sb.append(Integer.toString((int)wholePart + 1));
            return sb.toString();
        }
        if (wholePart > 0.0) {
            sb.append(Integer.toString((int)wholePart)).append(" ");
        }
        sb.append(fract.getNumerator()).append("/").append(fract.getDenominator());
        return sb.toString();
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.format((Number)obj));
    }

    public Object parseObject(String source, ParsePosition pos) {
        throw new NotImplementedException("Reverse parsing not supported");
    }

    private SimpleFraction calcFractionMaxDenom(double value, int maxDenominator) throws SimpleFractionException {
        double epsilon = 1.0E-12f;
        int maxIterations = 100;
        long overflow = Integer.MAX_VALUE;
        double r0 = value;
        long a0 = (long)Math.floor(r0);
        if (Math.abs(a0) > overflow) {
            throw new SimpleFractionException(String.format("value > Integer.MAX_VALUE: %d.", a0));
        }
        if (Math.abs((double)a0 - value) < epsilon) {
            return new SimpleFraction((int)a0, 1);
        }
        long p0 = 1L;
        long q0 = 0L;
        long p1 = a0;
        long q1 = 1L;
        long p2 = 0L;
        long q2 = 1L;
        int n = 0;
        boolean stop = false;
        do {
            ++n;
            double r1 = 1.0 / (r0 - (double)a0);
            long a1 = (long)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            if (Math.abs(p2) > overflow || Math.abs(q2) > overflow) {
                throw new SimpleFractionException(String.format("Greater than overflow in loop %f, %d, %d", value, p2, q2));
            }
            double convergent = (double)p2 / (double)q2;
            if (n < maxIterations && Math.abs(convergent - value) > epsilon && q2 < (long)maxDenominator) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n >= maxIterations) {
            throw new SimpleFractionException("n greater than max iterations " + value + " : " + maxIterations);
        }
        if (q2 < (long)maxDenominator) {
            return new SimpleFraction((int)p2, (int)q2);
        }
        return new SimpleFraction((int)p1, (int)q1);
    }

    private SimpleFraction calcFractionExactDenom(double val, int exactDenom) {
        int num = (int)Math.round(val * (double)exactDenom);
        return new SimpleFraction(num, exactDenom);
    }

    private class SimpleFractionException
    extends Throwable {
        private SimpleFractionException(String message) {
            super(message);
        }
    }

    private class SimpleFraction {
        private final int num;
        private final int denom;

        public SimpleFraction(int num, int denom) {
            this.num = num;
            this.denom = denom;
        }

        public int getNumerator() {
            return this.num;
        }

        public int getDenominator() {
            return this.denom;
        }
    }
}

