/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.junit.Assert;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.text.Inflector;
import org.modeshape.test.ModeShapeSingleUseTest;

public abstract class AbstractSequencerTest
extends ModeShapeSingleUseTest {
    public DeleteListener registerListenerForDeletes() throws RepositoryException {
        return this.registerListenerForDeletesBelow("/");
    }

    public DeleteListener registerListenerForDeletesBelow(String path) throws RepositoryException {
        DeleteListener listener = new DeleteListener(this.session(), path);
        listener.register();
        return listener;
    }

    public static class DeleteListener
    implements EventListener {
        private final Session session;
        private final String path;
        private List<List<String>> deletedPaths = new ArrayList<List<String>>();
        private boolean isRegistered = false;

        protected DeleteListener(Session session, String path) {
            this.session = session;
            this.path = path;
        }

        public void onEvent(EventIterator events) {
            try {
                ArrayList<String> deleted = new ArrayList<String>();
                while (events.hasNext()) {
                    Event event = events.nextEvent();
                    deleted.add(event.getPath());
                }
                this.deletedPaths.add(deleted);
            }
            catch (RepositoryException e) {
                throw new SystemFailureException((Throwable)e);
            }
        }

        public void clear() {
            this.deletedPaths.clear();
        }

        public int size() {
            int count = 0;
            for (List<String> list : this.deletedPaths) {
                count += list.size();
            }
            return count;
        }

        public List<List<String>> getDeletedPaths() {
            return this.deletedPaths;
        }

        public void register() throws RepositoryException {
            if (this.isRegistered) {
                return;
            }
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 2, this.path, true, null, null, false);
            this.isRegistered = true;
        }

        public void unregister() throws RepositoryException {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            this.isRegistered = false;
        }

        public Set<String> waitForDeleted(long maxTimeToWait, TimeUnit unit, String ... paths) {
            return this.waitForDeleted(maxTimeToWait, unit, true, paths);
        }

        public Set<String> waitForDeleted(long maxTimeToWait, TimeUnit unit, boolean failIfNotAllFound, String ... paths) {
            assert (paths != null);
            HashSet<String> remainingPaths = new HashSet<String>();
            for (String path : paths) {
                if (path == null) continue;
                remainingPaths.add(path);
            }
            if (remainingPaths.isEmpty()) {
                return remainingPaths;
            }
            long maxTimeToWaitInMillis = unit.toMillis(maxTimeToWait);
            long startTime = System.currentTimeMillis();
            long waitedInMillis = 0L;
            while (waitedInMillis < maxTimeToWaitInMillis) {
                for (List<String> list : this.deletedPaths) {
                    remainingPaths.removeAll(list);
                    if (!remainingPaths.isEmpty()) continue;
                    return remainingPaths;
                }
                waitedInMillis = System.currentTimeMillis() - startTime;
                if (waitedInMillis >= maxTimeToWaitInMillis) continue;
                try {
                    Thread.sleep(Math.min(50L, maxTimeToWaitInMillis - waitedInMillis));
                }
                catch (InterruptedException e) {
                    break;
                }
                waitedInMillis = System.currentTimeMillis() - startTime;
            }
            if (failIfNotAllFound && !remainingPaths.isEmpty()) {
                Inflector inflector = new Inflector();
                String unitName = inflector.pluralize((Object)unit.toString().toLowerCase(), (int)maxTimeToWait);
                Assert.fail((String)("Waited for " + maxTimeToWait + " " + unitName + " but didn't see events for deletion of: " + remainingPaths + ". Did see these deletions: " + this.deletedPaths));
            }
            return remainingPaths;
        }
    }
}

