/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.io.File;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.test.ModeShapeSingleUseTest;

public class SequencerTest
extends ModeShapeSingleUseTest {
    @Test
    public void shouldRegisterNodeTypesDefinedInConfigurationFileWithDefaultNamespace() throws Exception {
        SequencerTest.startEngineUsing((String)"config/configRepositoryWithDefaultNamespace.xml");
        this.session();
        this.assertNodeType("ddl:tableOperand", true, false, true, false, null, 0, 0, new String[]{"nt:base", "ddl:operand"});
        this.assertNodeType("derbyddl:functionOperand", true, false, true, false, null, 0, 0, new String[]{"nt:base", "ddl:operand"});
        this.assertNodeType("text:column", false, true, true, false, null, 0, 1, new String[0]);
        this.assertNodeType("relational:column", false, false, true, false, null, 0, 42, new String[]{"nt:unstructured", "relational:relationalEntity"});
        this.assertNodeType("relational:baseTable", false, false, true, true, null, 0, 0, new String[]{"relational:table"});
        this.assertNodeTypes(new String[]{"relational:relationalEntity", "relational:column", "relational:columnSet", "relational:uniqueKey", "relational:primaryKey", "relational:foreignKey", "jdbcs:imported"});
    }

    @Test
    public void shouldRegisterNodeTypes() throws Exception {
        configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("source").usingClass(InMemoryRepositorySource.class)).setDescription("The content store");
        configuration.repository("repo").setSource("source").addNodeTypes(this.resourceUrl("org/modeshape/connector/meta/jdbc/connector-metajdbc.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/classfile/sequencer-classfile.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/image/images.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/java/javaSource.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/mp3/mp3.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/msoffice/msoffice.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/text/sequencer-text.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/xml/xml.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/zip/zip.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/ddl/dialect/derby/DerbyDdl.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/ddl/dialect/oracle/OracleDdl.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/ddl/dialect/postgres/PostgresDdl.cnd")).addNodeTypes(this.resourceUrl("org/modeshape/sequencer/teiid/teiid.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine();
        this.session();
        this.assertNodeType("relational:column", false, false, true, false, null, 0, 42, new String[]{"nt:unstructured", "relational:relationalEntity"});
        this.assertNodeType("relational:baseTable", false, false, true, true, null, 0, 0, new String[]{"relational:table"});
        this.assertNodeTypes(new String[]{"relational:relationalEntity", "relational:column", "relational:columnSet", "relational:uniqueKey", "relational:primaryKey", "relational:foreignKey", "jdbcs:imported"});
    }

    @Test
    public void shouldSequenceContentInOneSourceAndStoreDerivedContentInAnother() throws Exception {
        String repoId = "content";
        String repoSrcId = "store";
        String workSpace = "images";
        String metaRepoId = "metadata";
        String metaRepoSrcId = "imageexif";
        String metaWorkSpace = "info";
        configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource(repoSrcId).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workSpace);
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource(metaRepoSrcId).usingClass(InMemoryRepositorySource.class)).setDescription("The meta repository for our content")).setProperty("defaultWorkspaceName", metaWorkSpace);
        configuration.repository(repoId).registerNamespace("image", "http://www.modeshape.org/images/1.0").setSource(repoSrcId);
        configuration.repository(metaRepoId).addNodeTypes("src/test/resources/sequencers/cnd/images.cnd").registerNamespace("example", "http://www.example.com/exif").setSource(metaRepoSrcId);
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)configuration.sequencer("Image Sequencer").usingClass("org.modeshape.sequencer.image.ImageMetadataSequencer").loadedFromClasspath()).setDescription("Sequences image files to extract the characteristics of the image")).sequencingFrom("store:images://(*.(jpg|jpeg|gif|bmp|pcx|png|iff|ras|pbm|pgm|ppm|psd)[*])/jcr:content[@jcr:data]").andOutputtingTo("imageexif:info:/$1");
        this.engine();
        Session session = this.sessionTo(repoId);
        session.getRootNode().addNode("files", "nt:unstructured");
        session.save();
        File file = new File("src/test/resources/sequencers/image/caution.gif");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        this.uploadFile(file.toURI().toURL(), "/files/");
        this.waitUntilSequencedNodesIs(1);
        Thread.sleep(400L);
        Session imageSession = this.sessionTo(metaRepoId);
        Node caution = imageSession.getNode("/caution.gif");
        Node metadata = caution.getNode("image:metadata");
        Assert.assertThat((Object)metadata.getProperty("image:height").getLong(), (Matcher)Is.is((Object)48L));
        this.printSubgraph(caution);
    }
}

