/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.NodeTypeAssertion;
import org.modeshape.repository.ModeShapeConfiguration;

public class ClusteringTest {
    private static JcrConfiguration configuration;
    private static JcrEngine engine1;
    private static JcrEngine engine2;
    private static JcrEngine engine3;
    private static List<Session> sessions;
    private boolean print;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        Session session;
        JcrRepository repository;
        block14: {
            FileUtil.delete((String)"target/db");
            String url = "jdbc:hsqldb:file:target/db/ClusteredObservationBusTest";
            String username = "sa";
            String password = "";
            configuration = new JcrConfiguration();
            ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("car-source").usingClass(JpaSource.class)).setDescription("The automobile content")).setProperty("dialect", "org.hibernate.dialect.HSQLDialect")).setProperty("driverClassName", "org.hsqldb.jdbcDriver")).setProperty("url", url)).setProperty("username", username)).setProperty("password", password)).setProperty("maximumConnectionsInPool", "2")).setProperty("minimumConnectionsInPool", "1")).setProperty("numberOfConnectionsToAcquireAsNeeded", "1")).setProperty("maximumSizeOfStatementCache", "100")).setProperty("maximumConnectionIdleTimeInSeconds", "10")).setProperty("referentialIntegrityEnforced", "true")).setProperty("largeValueSizeInBytes", "150")).setProperty("autoGenerateSchema", "update")).setProperty("retryLimit", "3")).setProperty("showSql", "false")).setProperty("defaultWorkspaceName", "content")).setProperty("cacheProviderClassName", (String)null)).setProperty("predefinedWorkspaceNames", (Object[])new String[]{"content", "system"});
            configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(ClusteringTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin").setOption(JcrRepository.Option.SYSTEM_SOURCE_NAME, "system@car-source");
            configuration.clustering().setProperty("clusterName", "MyCluster");
            engine1 = configuration.build();
            try {
                engine1.start();
            }
            catch (RuntimeException e) {
                System.err.println("There were problems starting the engine:");
                for (Problem problem : engine1.getProblems()) {
                    System.err.println(problem);
                }
                throw e;
            }
            repository = engine1.getRepository("cars");
            session = repository.login();
            try {
                InputStream stream = ClusteringTest.resourceStream("io/cars-system-view.xml");
                try {
                    session.getWorkspace().importXML("/", stream, 0);
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        stream.close();
                    }
                }
                stream.close();
            }
            finally {
                session.logout();
            }
        }
        session = repository.login();
        try {
            Node node = session.getRootNode().getNode("Cars/Hybrid/Toyota Highlander");
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)session.getRootNode().getNodes().getSize(), (Matcher)Is.is((Object)2L));
        }
        finally {
            session.logout();
        }
        engine2 = configuration.build();
        engine2.start();
        engine3 = configuration.build();
        engine3.start();
    }

    @AfterClass
    public static void afterAll() throws Exception {
        for (Session session : sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        sessions.clear();
        if (engine1 != null) {
            engine1.shutdown();
        }
        if (engine2 != null) {
            engine2.shutdown();
        }
        if (engine3 != null) {
            engine3.shutdown();
        }
        engine1 = null;
        engine2 = null;
        engine3 = null;
    }

    @Before
    public void beforeEach() {
        this.print = false;
    }

    @Test
    public void shouldAllowMultipleEnginesToAccessSameDatabase() throws Exception {
        Session session1 = this.sessionFrom(engine1);
        Node node1 = session1.getRootNode().getNode("Cars/Hybrid/Toyota Highlander");
        Assert.assertThat((Object)node1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Session session2 = this.sessionFrom(engine2);
        Node node = session2.getRootNode().getNode("Cars/Hybrid/Toyota Highlander");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReceiveNotificationsFromAllEnginesWhenChangingContentInOne() throws Exception {
        Session session1 = this.sessionFrom(engine1);
        Session session2 = this.sessionFrom(engine2);
        Session session3 = this.sessionFrom(engine3);
        session1.getRootNode().addNode("Base");
        session1.save();
        Thread.sleep(1000L);
        int eventTypes = 3;
        CustomListener listener1 = this.addListenerTo(session1, null, eventTypes, 1);
        CustomListener listener2 = this.addListenerTo(session2, "/Base", eventTypes, 1);
        CustomListener listener3 = this.addListenerTo(session3, "/Base", eventTypes, 1);
        CustomListener remoteListener1 = this.addRemoteListenerTo(session1, "/Base", eventTypes, 0);
        CustomListener remoteListener2 = this.addRemoteListenerTo(session2, "/Base", eventTypes, 1);
        CustomListener remoteListener3 = this.addRemoteListenerTo(session3, "/Base", eventTypes, 1);
        session1.getNode("/Base").addNode("SomeNewNode");
        session1.save();
        listener1.await();
        listener2.await();
        listener3.await();
        remoteListener1.await();
        remoteListener2.await();
        remoteListener3.await();
        listener1.disconnect();
        listener2.disconnect();
        listener3.disconnect();
        remoteListener1.disconnect();
        remoteListener2.disconnect();
        remoteListener3.disconnect();
        listener1.checkObservedEvents();
        listener2.checkObservedEvents();
        listener3.checkObservedEvents();
        remoteListener1.checkObservedEvents();
        remoteListener2.checkObservedEvents();
        remoteListener3.checkObservedEvents();
    }

    @Test
    @FixFor(value={"MODE-809"})
    public void shouldUpdateWorkspaceNamespaceRegistryAcrossCluster() throws Exception {
        Session session1 = this.sessionFrom(engine1);
        Session session2 = this.sessionFrom(engine2);
        Session session3 = this.sessionFrom(engine3);
        String nsUri = "http://example.com/foo/bar/baz";
        String nsPrefix = "foo";
        session1.getWorkspace().getNamespaceRegistry().registerNamespace(nsPrefix, nsUri);
        session1.getRootNode().addNode("Base");
        session1.save();
        int eventTypes = 3;
        CustomListener listener1 = this.addListenerTo(session1, "/Base", eventTypes, 1);
        CustomListener listener2 = this.addListenerTo(session2, "/Base", eventTypes, 1);
        CustomListener listener3 = this.addListenerTo(session3, "/Base", eventTypes, 1);
        CustomListener remoteListener1 = this.addRemoteListenerTo(session1, "/Base", eventTypes, 0);
        CustomListener remoteListener2 = this.addRemoteListenerTo(session2, "/Base", eventTypes, 1);
        CustomListener remoteListener3 = this.addRemoteListenerTo(session3, "/Base", eventTypes, 1);
        String propName = "foo:description";
        String propValue = "This is the foobar description";
        Node newNode = session1.getNode("/Base").addNode("SomeNewNode");
        newNode.setProperty(propName, propValue);
        session1.save();
        String path = newNode.getPath();
        listener1.await();
        listener2.await();
        listener3.await();
        remoteListener1.await();
        remoteListener2.await();
        remoteListener3.await();
        listener1.disconnect();
        listener2.disconnect();
        listener3.disconnect();
        remoteListener1.disconnect();
        remoteListener2.disconnect();
        remoteListener3.disconnect();
        listener1.checkObservedEvents();
        listener2.checkObservedEvents();
        listener3.checkObservedEvents();
        remoteListener1.checkObservedEvents();
        remoteListener2.checkObservedEvents();
        remoteListener3.checkObservedEvents();
        Assert.assertThat((Object)session1.getWorkspace().getNamespaceRegistry().getURI(nsPrefix), (Matcher)Is.is((Object)nsUri));
        Assert.assertThat((Object)session2.getWorkspace().getNamespaceRegistry().getURI(nsPrefix), (Matcher)Is.is((Object)nsUri));
        Assert.assertThat((Object)session3.getWorkspace().getNamespaceRegistry().getURI(nsPrefix), (Matcher)Is.is((Object)nsUri));
        Assert.assertThat((Object)session1.getNode(path).getProperty(propName).getString(), (Matcher)Is.is((Object)propValue));
        Assert.assertThat((Object)session2.getNode(path).getProperty(propName).getString(), (Matcher)Is.is((Object)propValue));
        Assert.assertThat((Object)session3.getNode(path).getProperty(propName).getString(), (Matcher)Is.is((Object)propValue));
    }

    @Test
    public void shouldPropagateTypeUnregistrationAcrossCluster() throws Exception {
        Session session1 = this.sessionFrom(engine1);
        Session session2 = this.sessionFrom(engine2);
        Session session3 = this.sessionFrom(engine3);
        NodeTypeManager typeManager1 = session1.getWorkspace().getNodeTypeManager();
        NodeTypeManager typeManager2 = session2.getWorkspace().getNodeTypeManager();
        NodeTypeManager typeManager3 = session3.getWorkspace().getNodeTypeManager();
        String NODE_TYPE_NAME = "nt:file";
        typeManager1.unregisterNodeType("nt:file");
        Assert.assertFalse((boolean)typeManager1.hasNodeType("nt:file"));
        for (int i = 0; i < 50; ++i) {
            try {
                if (!typeManager2.hasNodeType("nt:file") && !typeManager3.hasNodeType("nt:file")) break;
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        Assert.assertFalse((boolean)typeManager2.hasNodeType("nt:file"));
        Assert.assertFalse((boolean)typeManager3.hasNodeType("nt:file"));
    }

    @Test
    public void shouldPropagateTypeRegistrationAcrossCluster() throws Exception {
        Session session1 = this.sessionFrom(engine1);
        Session session2 = this.sessionFrom(engine2);
        Session session3 = this.sessionFrom(engine3);
        NodeTypeManager typeManager1 = session1.getWorkspace().getNodeTypeManager();
        NodeTypeManager typeManager2 = session2.getWorkspace().getNodeTypeManager();
        NodeTypeManager typeManager3 = session3.getWorkspace().getNodeTypeManager();
        String NODE_TYPE_NAME = "mode:newType";
        NodeTypeTemplate nodeType = typeManager1.createNodeTypeTemplate();
        nodeType.setName("mode:newType");
        nodeType.setMixin(true);
        nodeType.setDeclaredSuperTypeNames(new String[]{"mix:referenceable"});
        nodeType.setOrderableChildNodes(true);
        nodeType.setQueryable(true);
        PropertyDefinitionTemplate prop = typeManager1.createPropertyDefinitionTemplate();
        prop.setName("prop");
        prop.setAvailableQueryOperators(new String[]{"jcr.operator.equal.to"});
        prop.setMultiple(true);
        prop.setRequiredType(1);
        nodeType.getPropertyDefinitionTemplates().add(prop);
        NodeDefinitionTemplate child = typeManager1.createNodeDefinitionTemplate();
        child.setName("child");
        child.setSameNameSiblings(true);
        nodeType.getNodeDefinitionTemplates().add(child);
        typeManager1.registerNodeType((NodeTypeDefinition)nodeType, false);
        Assert.assertTrue((boolean)typeManager1.hasNodeType("mode:newType"));
        NodeType nodeType1 = typeManager1.getNodeType("mode:newType");
        for (int i = 0; i < 50; ++i) {
            try {
                if (typeManager2.hasNodeType("mode:newType") && typeManager3.hasNodeType("mode:newType")) break;
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        Assert.assertTrue((boolean)typeManager2.hasNodeType("mode:newType"));
        Assert.assertTrue((boolean)typeManager3.hasNodeType("mode:newType"));
        Assert.assertThat((Object)typeManager2.getNodeType("mode:newType").getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)typeManager3.getNodeType("mode:newType").getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)typeManager2.getNodeType("mode:newType").getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)typeManager3.getNodeType("mode:newType").getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        PropertyDefinition defn1 = typeManager1.getNodeType("mode:newType").getDeclaredPropertyDefinitions()[0];
        PropertyDefinition defn2 = typeManager2.getNodeType("mode:newType").getDeclaredPropertyDefinitions()[0];
        PropertyDefinition defn3 = typeManager3.getNodeType("mode:newType").getDeclaredPropertyDefinitions()[0];
        this.print = false;
        this.print("Property definition from session1: " + defn1);
        this.print("Property definition from session2: " + defn2);
        this.print("Property definition from session3: " + defn3);
        NodeTypeTemplate template2 = typeManager2.createNodeTypeTemplate((NodeTypeDefinition)typeManager2.getNodeType("mode:newType"));
        NodeTypeTemplate template3 = typeManager3.createNodeTypeTemplate((NodeTypeDefinition)typeManager3.getNodeType("mode:newType"));
        NodeTypeAssertion.compareTemplateToNodeType((NodeTypeTemplate)template2, (NodeType)nodeType1);
        NodeTypeAssertion.compareTemplateToNodeType((NodeTypeTemplate)template3, (NodeType)nodeType1);
        Node newNode = session1.getRootNode().addNode("my-new-node", "nt:unstructured");
        newNode.addMixin("mode:newType");
        Property property = newNode.setProperty("prop", "Value for prop");
        this.print("Property definition for " + property.getName() + " (via session1) before save:  " + property.getDefinition());
        Assert.assertThat((Object)property.getDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session1.save();
        this.print("Property definition for " + property.getName() + " (via session1) after save :  " + property.getDefinition());
        Assert.assertThat((Object)property.getDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node newNode2 = session2.getRootNode().addNode("my-new-node-2", "nt:unstructured");
        newNode2.addMixin("mode:newType");
        Property property2 = newNode2.setProperty("prop", "Value2 for prop");
        this.print("Property definition for " + property2.getName() + " (via session2) before save:  " + property2.getDefinition());
        Assert.assertThat((Object)property2.getDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session2.save();
        this.print("Property definition for " + property2.getName() + " (via session2) after save :  " + property2.getDefinition());
        Assert.assertThat((Object)property2.getDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session1.refresh(false);
        Node newNode2FromSession1 = session1.getNode("/my-new-node-2");
        Property property2FromSession1 = newNode2FromSession1.getProperty("prop");
        this.print("Property definition for " + property2FromSession1.getName() + " (via session1):  " + property2FromSession1.getDefinition());
        Assert.assertThat((Object)property2FromSession1.getDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session3.refresh(false);
        Node newNode2FromSession3 = session3.getNode("/my-new-node-2");
        Property property2FromSession3 = newNode2FromSession3.getProperty("prop");
        PropertyDefinition defn3b = property2FromSession3.getDefinition();
        this.print("Property definition for " + property2FromSession3.getName() + " (via session3):  " + defn3b);
        Assert.assertThat((Object)defn3b, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    protected void print(String text) {
        if (this.print) {
            System.out.println(text);
        }
    }

    protected Session sessionFrom(JcrEngine engine) throws RepositoryException {
        JcrRepository repository = engine.getRepository("cars");
        Session session = repository.login();
        sessions.add(session);
        return session;
    }

    protected CustomListener addRemoteListenerTo(Session session, String absPath, int eventTypes, int expectedEventCount) throws UnsupportedRepositoryOperationException, RepositoryException {
        CustomListener listener = new CustomListener(session, expectedEventCount);
        session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, eventTypes, absPath, true, null, null, true);
        return listener;
    }

    protected CustomListener addListenerTo(Session session, String absPath, int eventTypes, int expectedEventCount) throws UnsupportedRepositoryOperationException, RepositoryException {
        CustomListener listener = new CustomListener(session, expectedEventCount);
        session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, eventTypes, absPath, true, null, null, false);
        return listener;
    }

    protected static URL resourceUrl(String name) {
        return ClusteringTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return ClusteringTest.class.getClassLoader().getResourceAsStream(name);
    }

    static {
        sessions = new ArrayList<Session>();
    }

    protected static class CustomListener
    implements EventListener {
        private final List<Event> receivedEvents = new ArrayList<Event>();
        private final int expectedEventCount;
        private final CountDownLatch latch;
        private final Session session;

        protected CustomListener(Session session, int expectedEventCount) {
            this.latch = new CountDownLatch(expectedEventCount);
            this.expectedEventCount = expectedEventCount;
            this.session = session;
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                this.receivedEvents.add(events.nextEvent());
                this.latch.countDown();
            }
        }

        public void await() throws InterruptedException {
            this.latch.await(3L, TimeUnit.SECONDS);
        }

        public List<Event> getObservedEvents() {
            return this.receivedEvents;
        }

        public void checkObservedEvents() {
            StringBuilder msg = new StringBuilder("Expected ");
            msg.append(this.expectedEventCount);
            msg.append(" events but received ");
            msg.append(this.receivedEvents.size());
            msg.append(": ");
            msg.append(this.receivedEvents);
            Assert.assertThat((String)msg.toString(), (Object)this.receivedEvents.size(), (Matcher)Is.is((Object)this.expectedEventCount));
        }

        public void disconnect() throws RepositoryException {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
    }
}

