/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import javax.jcr.Node;
import javax.jcr.Property;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeSingleUseTest;

public class JcrImportExportIntegrationTest
extends ModeShapeSingleUseTest {
    @Test
    @FixFor(value={"MODE-687"})
    public void shouldBeAbleToImportSystemFileIntoRepository() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsImportExport.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrImportExportIntegrationTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/systemViewImport.xml");
        this.session().refresh(false);
        this.assertNode("/drools:repository", "nt:folder", new String[0]);
    }

    @Test
    @FixFor(value={"MODE-1026"})
    public void shouldBeAbleToImportFileWithValuesDefinedByXsiTypeAttributes() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsImportExport.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrImportExportIntegrationTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.assertNode("/drools:repository", "nt:folder", new String[0]);
        this.assertNode("/drools:repository/drools:package_area", "nt:folder", new String[0]);
        this.assertNode("/drools:repository/drools:package_area/mortgages", "drools:packageNodeType", new String[0]);
        this.assertNode("/drools:repository/drools:package_area/mortgages/assets", "drools:versionableAssetFolder", new String[0]);
        Node dsl = this.assertNode("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl", "drools:assetNodeType", new String[0]);
        Property property = dsl.getProperty("drools:content");
        Assert.assertThat((Object)property.getType(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getValue().getString().startsWith("[when]"), (Matcher)Is.is((Object)true));
    }

    @Test
    @FixFor(value={"MODE-1165"})
    public void shouldBeAbleToImportGuvnorExport() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsImportExport.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrImportExportIntegrationTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/sample-guvnor-repository.xml");
        this.session().refresh(false);
        this.assertNode("/drools:repository", "nt:folder", new String[0]);
    }
}

