/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class ConfigurationTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() {
        this.configuration = new JcrConfiguration();
        FileUtil.delete((String)"target/database/ConfigurationTest");
        FileUtil.delete((String)"target/testConfig/modeshape/repositories/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadFederatingConfig() throws Exception {
        String[] workspaceNames;
        File file = new File("src/test/resources/config/federatingConfigRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        Assert.assertThat((Object)this.configuration.repository("magnolia").getSource(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("magnolia").getName(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("disk").getName(), (Matcher)Is.is((Object)"disk"));
        Assert.assertThat((Object)this.configuration.repositorySource("data").getName(), (Matcher)Is.is((Object)"data"));
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("magnolia");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Set magnoliaWorkspaces = this.engine.getGraph("magnolia").getWorkspaces();
        Set diskWorkspaces = this.engine.getGraph("disk").getWorkspaces();
        Set dataWorkspaces = this.engine.getGraph("data").getWorkspaces();
        Assert.assertThat((Object)magnoliaWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
        Assert.assertThat((Object)dataWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "modeSystem"})));
        Assert.assertThat((Object)diskWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"workspace1"})));
        Session session = null;
        SimpleCredentials credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        for (String workspaceName : workspaceNames = new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"}) {
            try {
                session = repository.login((Credentials)credentials, workspaceName);
                session.getRootNode().addNode("testNode", "nt:folder");
                Set jcrWorkspaces = org.modeshape.common.collection.Collections.unmodifiableSet((Object[])session.getWorkspace().getAccessibleWorkspaceNames());
                Assert.assertThat((Object)jcrWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateInMemoryRepository() throws Exception {
        String[] workspaceNames;
        File file = new File("src/test/resources/config/federatingConfigRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        Assert.assertThat((Object)this.configuration.repository("magnolia").getSource(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("magnolia").getName(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("disk").getName(), (Matcher)Is.is((Object)"disk"));
        Assert.assertThat((Object)this.configuration.repositorySource("data").getName(), (Matcher)Is.is((Object)"data"));
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("data");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Set magnoliaWorkspaces = this.engine.getGraph("magnolia").getWorkspaces();
        Set diskWorkspaces = this.engine.getGraph("disk").getWorkspaces();
        Set dataWorkspaces = this.engine.getGraph("data").getWorkspaces();
        Assert.assertThat((Object)magnoliaWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
        Assert.assertThat((Object)dataWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "modeSystem"})));
        Assert.assertThat((Object)diskWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"workspace1"})));
        Session session = null;
        SimpleCredentials credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        for (String workspaceName : workspaceNames = new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion"}) {
            try {
                session = repository.login((Credentials)credentials, workspaceName);
                session.getRootNode().addNode("testNode", "nt:folder");
                Set jcrWorkspaces = org.modeshape.common.collection.Collections.unmodifiableSet((Object[])session.getWorkspace().getAccessibleWorkspaceNames());
                Assert.assertThat((Object)jcrWorkspaces, (Matcher)Is.is((Object)org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion"})));
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @Test
    public void shouldEnableRebuildingIndexesUponStartupInBackgroundConfiguredProgrammatically() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.configuration.repository("My repository").setOption(JcrRepository.Option.QUERY_INDEXES_REBUILT_SYNCHRONOUSLY, false);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("My repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldEnableRebuildingIndexesUponStartupInBackground() throws Exception {
        File file = new File("src/test/resources/config/configRepositoryWithAsynchronousIndex.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("My repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    @FixFor(value={"MODE-1224"})
    public void shouldStartWithEdsConfiguration() throws Exception {
        Logger.getLogger(this.getClass()).debug("Here we go...", new Object[0]);
        File file = new File("src/test/resources/config/configRepositoryEds.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("eds");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
    }

    @Test
    @FixFor(value={"MODE-1224"})
    public void shouldStartWithEdsConfigurationAndRestart() throws Exception {
        Logger.getLogger(this.getClass()).debug("Here we go...", new Object[0]);
        File file = new File("src/test/resources/config/configRepositoryEds.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("eds");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Thread.sleep(500L);
        this.engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
        Logger.getLogger(this.getClass()).debug("*** Restarting the engine ***", new Object[0]);
        JcrConfiguration configuration2 = new JcrConfiguration();
        configuration2.loadFrom(file);
        this.engine = configuration2.build();
        this.engine.start();
        repository = this.engine.getRepository("eds");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Thread.sleep(500L);
    }

    @Test
    @FixFor(value={"MODE-1224"})
    public void shouldStartWithEdsConfigurationUsingJpaStore() throws Exception {
        Logger.getLogger(this.getClass()).debug("Here we go...", new Object[0]);
        File file = new File("target/test-classes/config/configRepositoryEdsWithJpaStore.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("eds");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldWork() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("My repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldWork2() throws Exception {
        File file = new File("src/test/resources/config/configRepositoryForBrix.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("Brix repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    @FixFor(value={"MODE-1216"})
    public void shouldReadNodeTypesUponRestartUsingJpaConnector() throws Exception {
        FileUtil.delete((String)"target/database/ConfigurationTest");
        File file = new File("src/test/resources/config/configRepositoryForJpaWithDiskStorage.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        JcrConfiguration config1 = new JcrConfiguration();
        config1.loadFrom(file);
        JcrConfiguration config2 = new JcrConfiguration();
        config2.loadFrom(file);
        this.startEngineThenShutdownThenRestartAndTestForNodeTypes(config1, config2);
    }

    @Test
    @FixFor(value={"MODE-1190"})
    public void shouldReadNodeTypesUponRestartUsingDiskConnector() throws Exception {
        FileUtil.delete((String)"target/database/ConfigurationTest");
        File file = new File("src/test/resources/config/configRepositoryForDiskStorage.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        JcrConfiguration config1 = new JcrConfiguration();
        config1.loadFrom(file);
        JcrConfiguration config2 = new JcrConfiguration();
        config2.loadFrom(file);
        this.startEngineThenShutdownThenRestartAndTestForNodeTypes(config1, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEngineThenShutdownThenRestartAndTestForNodeTypes(JcrConfiguration config1, JcrConfiguration config2) throws Exception {
        JcrEngine engine = config1.build();
        engine.start();
        JcrRepository repository = engine.getRepository("Repo");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ArrayList<String> nodeTypeNames = new ArrayList<String>();
        Session session = repository.login();
        try {
            this.readNodeTypes(session, "/io/drools/configuration_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/tag_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/state_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/versionable_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/versionable_asset_folder_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/rule_node_type.cnd");
            this.readNodeTypes(session, "/io/drools/rulepackage_node_type.cnd");
            NodeTypeIterator nodeTypes = session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
            while (nodeTypes.hasNext()) {
                NodeType nodeType = nodeTypes.nextNodeType();
                nodeTypeNames.add(nodeType.getName());
            }
        }
        finally {
            session.logout();
            engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
        }
        Collections.sort(nodeTypeNames);
        engine = config2.build();
        engine.start();
        JcrRepository repository2 = engine.getRepository("Repo");
        Assert.assertThat((Object)repository2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ArrayList<String> nodeTypeNames2 = new ArrayList<String>();
        Session session2 = repository2.login();
        try {
            NodeTypeIterator nodeTypes = session2.getWorkspace().getNodeTypeManager().getAllNodeTypes();
            while (nodeTypes.hasNext()) {
                NodeType nodeType = nodeTypes.nextNodeType();
                nodeTypeNames2.add(nodeType.getName());
            }
        }
        finally {
            session.logout();
            engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
        }
        Collections.sort(nodeTypeNames2);
        Assert.assertThat(nodeTypeNames, (Matcher)Is.is(nodeTypeNames2));
    }

    protected void readNodeTypes(Session session, String ... cndResources) throws IOException, RepositoryException {
        for (String cndResource : cndResources) {
            CndNodeTypeReader reader = new CndNodeTypeReader(session);
            reader.read(cndResource);
            Assert.assertThat((Object)reader.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
            session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        }
    }
}

