/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.infinispan;

import java.util.concurrent.TimeUnit;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.collection.Problem;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

@Ignore
public class InfinispanClusterTest {
    private JcrEngine engine1;
    private JcrEngine engine2;

    @Before
    public void beforeEach() throws Exception {
        this.engine1 = new JcrConfiguration().loadFrom("./src/test/resources/infinispan/configRepository.xml").build();
        this.engine2 = new JcrConfiguration().loadFrom("./src/test/resources/infinispan/configRepository.xml").build();
        this.engine1.start();
        if (this.engine1.getProblems().hasProblems()) {
            for (Problem problem : this.engine1.getProblems()) {
                System.err.println(problem.getMessageString());
            }
        }
        this.engine2.start();
        if (this.engine2.getProblems().hasProblems()) {
            for (Problem problem : this.engine2.getProblems()) {
                System.err.println(problem.getMessageString());
            }
        }
    }

    @After
    public void afterEach() throws Exception {
        if (this.engine1 != null) {
            this.engine1.shutdown();
            this.engine1.awaitTermination(5L, TimeUnit.SECONDS);
        }
        if (this.engine2 != null) {
            this.engine2.shutdown();
            this.engine2.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void shouldShareContent() throws Exception {
        Assert.assertThat((Object)this.engine1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.engine2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        JcrRepository repo1 = this.engine1.getRepository("Test Repository Source");
        JcrRepository repo2 = this.engine2.getRepository("Test Repository Source");
        Session session1 = repo1.login();
        Session session2 = repo2.login();
        Node fooNode = session1.getRootNode().addNode("foo");
        fooNode.addMixin("mix:referenceable");
        this.checkNoNodeAt(session2, "/foo");
        session1.save();
        session2.refresh(false);
        Item foo2 = session2.getItem("/foo");
        foo2.remove();
        session2.save();
        session1.refresh(false);
        this.checkNoNodeAt(session1, "/foo");
    }

    private void checkNoNodeAt(Session session, String path) throws Exception {
        try {
            session.getItem(path);
            Assert.fail((String)("No node should exist at path: " + path));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

