/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.manual;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.eclipse.core.runtime.AssertionFailedException;
import org.modeshape.common.collection.Problem;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.performance.GuvnorEmulator;
import org.xml.sax.SAXException;

public class ReadNodeTypesUponRestart
extends ModeShapeUnitTest {
    private static final boolean FIRST_TIME = false;
    private static final String CONFIG_FILE_PATH = "src/test/resources/config/read-node-types-upon-restart-config.xml";
    private static final String NODE_TYPE_NAME = "StandardArticle";
    private static JcrEngine engine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        GuvnorEmulator guvnor;
        Workspace workspace;
        Session session;
        try {
            ReadNodeTypesUponRestart.startEngine(true);
            try {
                session = ReadNodeTypesUponRestart.getSession();
                workspace = session.getWorkspace();
                ReadNodeTypesUponRestart.getOrCreateNamespace(workspace, "jboss", "http://www.jboss.org");
                ReadNodeTypesUponRestart.getOrCreateNodeType(workspace);
                guvnor = new GuvnorEmulator(ReadNodeTypesUponRestart.getSession().getRepository(), 150, true);
                guvnor.importGuvnorNodeTypes(true);
                System.out.print("Verifying Guvnor content ... ");
                guvnor.verifyContent();
                System.out.println("completed");
            }
            catch (Exception e) {
                System.out.print("exception" + e);
            }
            try {
                session = ReadNodeTypesUponRestart.getSession();
                workspace = session.getWorkspace();
                ReadNodeTypesUponRestart.getNamespace(workspace, "jboss", "http://www.jboss.org");
                ReadNodeTypesUponRestart.getNodeType(workspace);
            }
            catch (RepositoryException e) {
                System.out.print("exception" + (Object)((Object)e));
            }
        }
        finally {
            ReadNodeTypesUponRestart.shutdownEngine();
        }
        try {
            ReadNodeTypesUponRestart.startEngine(false);
            try {
                session = ReadNodeTypesUponRestart.getSession();
                workspace = session.getWorkspace();
                ReadNodeTypesUponRestart.getNamespace(workspace, "jboss", "http://www.jboss.org");
                ReadNodeTypesUponRestart.getNodeType(workspace);
                guvnor = new GuvnorEmulator(ReadNodeTypesUponRestart.getSession().getRepository(), 150, true);
                guvnor.importGuvnorNodeTypes(true);
            }
            catch (Exception e) {
                System.out.print("exception" + e);
            }
        }
        finally {
            ReadNodeTypesUponRestart.shutdownEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownEngine() {
        if (engine == null) {
            return;
        }
        try {
            System.out.print("Shutting down ModeShape engine ... ");
            long nanos = System.nanoTime();
            engine.shutdownAndAwaitTermination(5L, TimeUnit.SECONDS);
            nanos = System.nanoTime() - nanos;
            System.out.println("completed in " + TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) + " millis");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            engine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startEngine(boolean firstTime) {
        long nanos;
        if (engine != null) {
            return;
        }
        if (firstTime) {
            System.out.print("Starting ModeShape engine ... ");
        } else {
            System.out.println("");
            System.out.print("Restarting ModeShape engine ... ");
        }
        try {
            JcrConfiguration config = new JcrConfiguration().loadFrom(CONFIG_FILE_PATH);
            if (firstTime) {
                // empty if block
            }
            config.repositorySource("Store").setProperty("mode:autoGenerateSchema", "disable");
            engine = config.build();
            nanos = System.nanoTime();
            engine.start(true);
            nanos = System.nanoTime() - nanos;
            if (engine.getProblems().hasProblems()) {
                System.out.println("resulted in problems:");
                for (Problem problem : engine.getProblems()) {
                    System.err.println(problem.getMessageString());
                }
                throw new RuntimeException("Could not start due to problems");
            }
            System.out.println("completed in " + TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) + " millis");
        }
        catch (IOException e) {
            System.out.print("exception" + e);
        }
        catch (SAXException e) {
            System.out.print("exception" + e);
        }
        Session session = null;
        try {
            System.out.print("Getting initial session ... ");
            nanos = System.nanoTime();
            session = ReadNodeTypesUponRestart.getSession();
            nanos = System.nanoTime() - nanos;
            System.out.println("completed in " + TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) + " millis");
        }
        catch (RepositoryException e) {
            System.out.print("exception" + (Object)((Object)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static Session getSession() throws RepositoryException {
        JcrRepository repository = engine.getRepository("Repo");
        Session session = repository.login();
        return session;
    }

    private static void getNodeType(Workspace workspace) {
        try {
            NodeTypeManager mgr = workspace.getNodeTypeManager();
            mgr.getAllNodeTypes();
            NodeType nodeType = mgr.getNodeType(NODE_TYPE_NAME);
            System.out.println("Found node type \"" + nodeType.getName() + "\"");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static void getOrCreateNodeType(Workspace workspace) {
        try {
            NodeTypeManager nodeTypeManager = workspace.getNodeTypeManager();
            try {
                NodeType newNodeType = nodeTypeManager.getNodeType(NODE_TYPE_NAME);
                System.out.println("Found existing node type \"" + newNodeType.getName() + "\"");
            }
            catch (NoSuchNodeTypeException e) {
                throw new AssertionFailedException("Should have found existing node type: " + e.getMessage());
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static void getNamespace(Workspace workspace, String prefix, String uri) {
        try {
            NamespaceRegistry registry = workspace.getNamespaceRegistry();
            String actualUri = registry.getURI(prefix);
            if (actualUri.equals(uri)) {
                System.out.println("Found existing namespace " + ReadNodeTypesUponRestart.namespace(prefix, actualUri));
            } else {
                System.out.println("Found existing namespace " + ReadNodeTypesUponRestart.namespace(prefix, actualUri) + " that didn't match expected URI: " + uri);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static void getOrCreateNamespace(Workspace workspace, String prefix, String uri) {
        try {
            NamespaceRegistry registry = workspace.getNamespaceRegistry();
            try {
                String actualUri = registry.getURI(prefix);
                if (actualUri.equals(uri)) {
                    System.out.println("Found existing namespace " + ReadNodeTypesUponRestart.namespace(prefix, actualUri));
                } else {
                    System.out.println("Found existing namespace " + ReadNodeTypesUponRestart.namespace(prefix, actualUri) + " that didn't match expected URI: " + uri);
                }
            }
            catch (NamespaceException e) {
                throw new AssertionFailedException("Should have found existing namespace " + ReadNodeTypesUponRestart.namespace(prefix, uri) + " : " + e.getMessage());
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static String namespace(String prefix, String uri) {
        return prefix + ":" + uri;
    }
}

