/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.util.CheckArg;

public class GeneratePerformanceRules {
    protected static final String SPECIFICATION_PATTERN_STRING = "([^\\(]*)([\\(]([^\\)]*)[\\)])?";
    protected static final Pattern SPECIFICATION_PATTERN = Pattern.compile("([^\\(]*)([\\(]([^\\)]*)[\\)])?");
    protected static final String METHOD_SPECIFICATION_PATTERN_STRING = "([^\\(]*)([\\(]([^\\)]*)[\\)])?";
    protected static final Pattern METHOD_SPECIFICATION_PATTERN = Pattern.compile("([^\\(]*)([\\(]([^\\)]*)[\\)])?");
    public static final String DEFAULT_OUTPUT_FILE = "jcr-performance-generated.txt";
    private String outputFile = "jcr-performance-generated.txt";
    private ClassLoader classLoader;
    private List<Specification> specs = new ArrayList<Specification>();
    private boolean verbose = false;
    private String helperClass;

    public static void main(String[] args) throws Exception {
        GeneratePerformanceRules generator = new GeneratePerformanceRules();
        String outputFile = "target/byteman/jcr-performance-generated.txt";
        generator.setOutputFile(outputFile);
        for (String arg : args) {
            if ((arg = arg.trim()).equals("--verbose")) {
                generator.setVerbose(true);
            }
            if (arg.startsWith("--class=") && arg.length() > 8) {
                String classSpecification = arg.substring(8).trim();
                generator.instrumentClass(classSpecification);
            }
            if (!arg.startsWith("--file=") || arg.length() <= 7) continue;
            outputFile = arg.substring(7).trim();
        }
        generator.generateRules();
    }

    public GeneratePerformanceRules() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public void setOutputFile(String outputFile) {
        if (outputFile == null || outputFile.trim().length() == 0) {
            outputFile = DEFAULT_OUTPUT_FILE;
        }
        this.outputFile = outputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getHelperClass() {
        return this.helperClass;
    }

    public void setHelperClass(String helperClass) {
        this.helperClass = helperClass;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void instrumentClass(String specification) throws ClassNotFoundException {
        Matcher matcher = SPECIFICATION_PATTERN.matcher(specification);
        if (matcher.find()) {
            String targetClass = matcher.group(1);
            String methodSpecs = matcher.group(3);
            if (methodSpecs != null && methodSpecs.trim().length() != 0) {
                for (String methodSpec : methodSpecs.split(";")) {
                    String[] parts = methodSpec.split(":");
                    if (parts.length <= 1) continue;
                    String visibilities = parts[0];
                    String methodClass = parts[1];
                    if (methodClass == null || (methodClass = methodClass.trim()).length() == 0) continue;
                    HashSet<Visibility> visibles = new HashSet<Visibility>();
                    for (String visibility : visibilities.split(",")) {
                        visibles.add(Visibility.parse(visibility));
                    }
                    Visibility[] vizzes = visibles.toArray(new Visibility[visibles.size()]);
                    this.instrumentClass(targetClass, methodClass, vizzes);
                }
            }
        }
    }

    public void instrumentClass(String clazz, String methodsIn, Visibility ... visibilities) throws ClassNotFoundException {
        CheckArg.isNotEmpty((String)clazz, (String)"clazz");
        Class<?> target = this.classLoader.loadClass(clazz);
        Class<?> methods = methodsIn != null ? this.classLoader.loadClass(methodsIn) : null;
        this.instrumentClass(target, methods, visibilities);
    }

    public void instrumentClass(Class<?> target, Class<?> methodsIn, Visibility ... visibilities) {
        CheckArg.isNotNull(target, (String)"target");
        this.specs.add(new Specification(target, methodsIn, visibilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRules() throws IOException {
        PrintStream stream = null;
        if ("System.out".equals(this.outputFile)) {
            stream = System.out;
        } else {
            File file = new File(this.outputFile);
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            stream = new PrintStream(file);
        }
        try {
            HashSet<Method> methods = new HashSet<Method>();
            for (Specification spec : this.specs) {
                boolean written = false;
                Class<?> targetClass = spec.getTargetClass();
                String targetClassName = targetClass.getCanonicalName();
                Class<?> methodClass = spec.getMethodsIn();
                for (Method method : methodClass.getDeclaredMethods()) {
                    if (!methods.add(method) || !spec.includes(method)) continue;
                    String signature = this.signatureFor(method);
                    if (!written) {
                        this.writeHeader(stream, "Rules for " + spec);
                        written = true;
                    }
                    this.writeMethodEnterRule(stream, targetClassName, method.getName(), signature);
                    this.writeMethodExitRule(stream, targetClassName, method.getName(), signature);
                }
            }
        }
        finally {
            if (stream != System.out) {
                stream.flush();
                stream.close();
            }
        }
    }

    protected String signatureFor(Method method) {
        StringBuilder signature = new StringBuilder();
        signature.append(method.getName());
        signature.append('(');
        boolean firstParam = true;
        for (Class<?> paramType : method.getParameterTypes()) {
            if (firstParam) {
                firstParam = false;
            } else {
                signature.append(',');
            }
            signature.append(paramType.getCanonicalName());
        }
        signature.append(')');
        return signature.toString();
    }

    protected void writeMethodEnterRule(PrintStream out, String targetClass, String methodName, String methodSignature) {
        out.println("RULE trace on enter for " + targetClass + "." + methodSignature);
        out.println("CLASS " + targetClass);
        out.println("METHOD " + methodSignature);
        if (this.getHelperClass() != null && this.getHelperClass().trim().length() != 0) {
            out.println("HELPER " + this.getHelperClass());
        }
        out.println("AT ENTRY");
        out.println("IF TRUE");
        out.println("DO enterMethod(\"" + methodName + "\",$*)");
        out.println("ENDRULE");
        out.println();
    }

    protected void writeMethodExitRule(PrintStream out, String targetClass, String methodName, String methodSignature) {
        out.println("RULE trace on exit for " + targetClass + "." + methodSignature);
        out.println("CLASS " + targetClass);
        out.println("METHOD " + methodSignature);
        if (this.getHelperClass() != null && this.getHelperClass().trim().length() != 0) {
            out.println("HELPER " + this.getHelperClass());
        }
        out.println("AT EXIT");
        out.println("IF TRUE");
        out.println("DO exitMethod(\"" + methodName + "\",$*)");
        out.println("ENDRULE");
        out.println();
        out.println();
    }

    protected void writeHeader(PrintStream out, String msg) {
        out.println("# *****************************************************************************************************************");
        out.println("# " + msg);
        out.println("# *****************************************************************************************************************");
    }

    @Immutable
    public static class Specification {
        private final Class<?> clazz;
        private final Class<?> methodsIn;
        private final Set<Visibility> visibilities;

        public Specification(Class<?> clazz, Class<?> methodsIn, Visibility ... visibilities) {
            assert (clazz != null);
            this.clazz = clazz;
            this.methodsIn = methodsIn != null ? methodsIn : clazz;
            this.visibilities = visibilities.length == 0 ? Collections.unmodifiableSet(EnumSet.of(Visibility.PUBLIC)) : Collections.unmodifiableSet(EnumSet.of(visibilities[0], visibilities));
        }

        public Class<?> getTargetClass() {
            return this.clazz;
        }

        public Class<?> getMethodsIn() {
            return this.methodsIn;
        }

        public Set<Visibility> getVisibilities() {
            return this.visibilities;
        }

        public boolean includes(Method method) {
            int modifiers = method.getModifiers();
            return this.includes(modifiers);
        }

        public boolean includes(int modifiers) {
            if (Modifier.isPrivate(modifiers)) {
                if (this.visibilities.contains((Object)Visibility.PRIVATE)) {
                    return true;
                }
            } else if (Modifier.isProtected(modifiers)) {
                if (this.visibilities.contains((Object)Visibility.PROTECTED)) {
                    return true;
                }
            } else if (Modifier.isPublic(modifiers)) {
                if (this.visibilities.contains((Object)Visibility.PUBLIC)) {
                    return true;
                }
            } else {
                return this.visibilities.contains((Object)Visibility.PACKAGE);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.visibilities.contains((Object)Visibility.PUBLIC)) {
                sb.append("public");
            }
            if (this.visibilities.contains((Object)Visibility.PROTECTED)) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append("protected");
            }
            if (this.visibilities.contains((Object)Visibility.PACKAGE)) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append("package");
            }
            if (this.visibilities.contains((Object)Visibility.PRIVATE)) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append("private");
            }
            if (this.methodsIn != this.clazz && this.methodsIn != null) {
                sb.append(this.methodsIn.getCanonicalName());
                sb.append(" methods in ");
            }
            sb.append(' ');
            sb.append(this.clazz.getCanonicalName());
            return sb.toString();
        }
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;


        public static Visibility parse(String value) {
            if ("public".equalsIgnoreCase(value)) {
                return PUBLIC;
            }
            if ("protected".equalsIgnoreCase(value)) {
                return PROTECTED;
            }
            if ("package".equalsIgnoreCase(value)) {
                return PACKAGE;
            }
            if ("private".equalsIgnoreCase(value)) {
                return PACKAGE;
            }
            return PUBLIC;
        }
    }
}

