/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JcrTools;

public class GuvnorEmulator {
    private final int numberOfCopies;
    private final JcrTools tools;
    private final Repository repository;

    public GuvnorEmulator(Repository repository, int numberOfCopies, boolean print) {
        this.repository = repository;
        this.numberOfCopies = numberOfCopies;
        this.tools = new JcrTools(print);
    }

    public void simulateGuvnorUsage(int count) throws Exception {
        Assert.assertThat((Object)(count >= 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        Stopwatch sw = new Stopwatch(false, "Iteration");
        Stopwatch total = new Stopwatch(true, "Total usage");
        Stopwatch sw15 = new Stopwatch(true, "First " + this.numberOfCopies);
        Stopwatch swRest = new Stopwatch(true, "Remaining");
        for (int i = 0; i != count; ++i) {
            sw.start();
            total.start();
            if (i <= this.numberOfCopies) {
                sw15.start();
            } else {
                swRest.start();
            }
            this.tools.browseTo(this.repository, "/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
            ModifyAsset modifyAsset = new ModifyAsset("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
            this.tools.repeatedlyWithSession(this.repository, 1, (JcrTools.Operation)modifyAsset);
            this.tools.browseTo(this.repository, "/drools:repository/drools:package_area/mortgages");
            ViewContent viewContent = new ViewContent("/drools:repository/drools:package_area/mortgages");
            this.tools.withSession(this.repository, (JcrTools.Operation)viewContent);
            this.printDetail(viewContent.getContent());
            this.tools.withSession(this.repository, (JcrTools.Operation)new BuildPackage("mortgages"));
            String snapshotName = i <= this.numberOfCopies ? "TEST" + i : "TEST15";
            this.tools.withSession(this.repository, (JcrTools.Operation)new CreatePackageSnapshot("mortgages", snapshotName, "My TEST snapshot"));
            this.tools.withSession(this.repository, (JcrTools.Operation)new LoadPackageSnapshot("mortgages", snapshotName));
            sw.stop();
            total.stop();
            if (i <= this.numberOfCopies) {
                sw15.stop();
            } else {
                swRest.stop();
            }
            this.tools.print((Object)(StringUtil.justifyRight((String)("" + i), (int)3, (char)' ') + " " + sw));
            sw.reset();
        }
        if (sw15.getCount() != total.getCount()) {
            this.tools.print((Object)sw15);
        }
        if (swRest.getCount() > 0) {
            this.tools.print((Object)swRest);
        }
        this.tools.print((Object)total);
    }

    public void printVersionHistory(String path) throws Exception {
        this.tools.withSession(this.repository, (JcrTools.Operation)new PrintVersionHistory(this.tools, path));
    }

    public void verifyContent() throws Exception {
        this.tools.withSession(this.repository, (JcrTools.Operation)new VerifyContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGuvnorNodeTypes(boolean shouldFind) throws IOException, RepositoryException {
        Session session = this.repository.login();
        try {
            session.getNamespacePrefix("http://www.jboss.org/drools-repository/1.0");
            NodeType newNodeType = session.getWorkspace().getNodeTypeManager().getNodeType("drools:configurationNodeType");
            if (shouldFind) {
                this.tools.print((Object)"Found existing Guvnor node types");
            } else {
                this.tools.print((Object)("Should not have found existing node type \"" + newNodeType.getName() + "\"; check instructions in JavaDoc and try again."));
            }
        }
        catch (RepositoryException e) {
            this.tools.print((Object)"Importing Guvnor CNDs...");
            this.importNodeTypes(session, "/io/drools/configuration_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/tag_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/state_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/versionable_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/versionable_asset_folder_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/rule_node_type.cnd");
            this.importNodeTypes(session, "/io/drools/rulepackage_node_type.cnd");
            this.tools.print((Object)"Finished importing Guvnor CNDs");
        }
        finally {
            session.logout();
        }
    }

    protected void importNodeTypes(Session session, String resourcePath) throws IOException, RepositoryException {
        CndNodeTypeReader reader = new CndNodeTypeReader(session);
        reader.read(resourcePath);
        session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
    }

    protected void printDetail(Object msg) {
        if (this.tools.isDebug() && msg != null) {
            this.tools.print((Object)msg.toString());
        }
    }

    public abstract class DroolsOperation
    extends JcrTools.BasicOperation {
        public static final String TITLE_PROPERTY_NAME = "drools:title";
        public static final String DESCRIPTION_PROPERTY_NAME = "drools:description";
        public static final String LAST_MODIFIED_PROPERTY_NAME = "drools:lastModified";
        public static final String FORMAT_PROPERTY_NAME = "drools:format";
        public static final String CHECKIN_COMMENT = "drools:checkinComment";
        public static final String VERSION_NUMBER_PROPERTY_NAME = "drools:versionNumber";
        public static final String CONTENT_PROPERTY_ARCHIVE_FLAG = "drools:archive";
        public static final String LAST_CONTRIBUTOR_PROPERTY_NAME = "drools:lastContributor";
        public static final String CONTENT_PROPERTY_NAME = "drools:content";
        public static final String CONTENT_PROPERTY_BINARY_NAME = "drools:binaryContent";
        public static final String CONTENT_PROPERTY_ATTACHMENT_FILENAME = "drools:attachmentFileName";
        public static final String PACKAGE_AREA = "drools:package_area";
        public static final String PACKAGE_SNAPSHOT_AREA = "drools:packagesnapshot_area";
        public static final String ASSET_FOLDER_NAME = "assets";

        protected DroolsOperation() {
            super(null);
        }

        protected DroolsOperation(JcrTools tools) {
            super(tools);
        }

        public VersionManager versionMgr(Node versionable) throws RepositoryException {
            return versionable.getSession().getWorkspace().getVersionManager();
        }

        public void checkout(Node versionable) throws RepositoryException {
            this.versionMgr(versionable).checkout(versionable.getPath());
        }

        public void checkin(Node versionable, String comment) throws RepositoryException {
            versionable.setProperty(LAST_MODIFIED_PROPERTY_NAME, Calendar.getInstance());
            this.updateCheckinComment(versionable, comment);
            versionable.setProperty(LAST_CONTRIBUTOR_PROPERTY_NAME, versionable.getSession().getUserID());
            long nextVersion = this.versionNumber(versionable) + 1L;
            versionable.setProperty(VERSION_NUMBER_PROPERTY_NAME, nextVersion);
            versionable.getSession().save();
            this.versionMgr(versionable).checkin(versionable.getPath());
        }

        public void updateCheckinComment(Node versionable, String comment) throws RepositoryException {
            versionable.setProperty(CHECKIN_COMMENT, comment);
        }

        public Calendar lastModified(Node versionable) throws RepositoryException {
            if (versionable.hasProperty(LAST_MODIFIED_PROPERTY_NAME)) {
                Property lastModifiedProperty = versionable.getProperty(LAST_MODIFIED_PROPERTY_NAME);
                return lastModifiedProperty.getDate();
            }
            return null;
        }

        public long versionNumber(Node versionable) throws RepositoryException {
            return this.longProperty(versionable, VERSION_NUMBER_PROPERTY_NAME);
        }

        public long longProperty(Node theNode, String propertyName) throws RepositoryException {
            if (theNode.hasProperty(propertyName)) {
                Property data = theNode.getProperty(propertyName);
                return data.getValue().getLong();
            }
            return 0L;
        }

        public void updateDescription(Node versionable, String newDescriptionContent) throws RepositoryException {
            this.checkout(versionable);
            versionable.setProperty(DESCRIPTION_PROPERTY_NAME, newDescriptionContent);
            Calendar lastModified = Calendar.getInstance();
            versionable.setProperty(LAST_MODIFIED_PROPERTY_NAME, lastModified);
        }

        public boolean isBinary(Node node) throws RepositoryException {
            return node.hasProperty(CONTENT_PROPERTY_BINARY_NAME);
        }

        public boolean isArchived(Node node) throws RepositoryException {
            return node.hasProperty(CONTENT_PROPERTY_ARCHIVE_FLAG);
        }

        public String getAssetFormat(Node node) throws RepositoryException {
            return node.hasProperty(FORMAT_PROPERTY_NAME) ? node.getProperty(FORMAT_PROPERTY_NAME).getString() : null;
        }

        public String readBinaryContentAttachment(Node assetNode) throws RepositoryException, IOException {
            if (assetNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = assetNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return IoUtil.read((InputStream)data.getBinary().getStream());
            }
            if (assetNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = assetNode.getProperty(CONTENT_PROPERTY_NAME);
                return IoUtil.read((InputStream)data.getBinary().getStream());
            }
            return null;
        }

        public Node area(Session session, String areaName) throws RepositoryException {
            return session.getRootNode().getNode("drools:repository").getNode(areaName);
        }

        public void removePackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            Node snapshotPackage = null;
            if (snapshotArea.hasNode(packageName)) {
                snapshotPackage = snapshotArea.getNode(packageName);
            } else {
                snapshotPackage = snapshotArea.addNode(packageName, "nt:folder");
                session.save();
            }
            if (snapshotPackage.hasNode(snapshotName)) {
                snapshotPackage.getNode(snapshotName).remove();
                session.save();
            }
        }

        public void createPackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            Node snapshotPackage = null;
            if (snapshotArea.hasNode(packageName)) {
                snapshotPackage = snapshotArea.getNode(packageName);
            } else {
                snapshotPackage = snapshotArea.addNode(packageName, "nt:folder");
                session.save();
            }
            if (snapshotPackage.hasNode(snapshotName)) {
                snapshotPackage.getNode(snapshotName).remove();
                session.save();
            }
            String newName = snapshotPackage.getPath() + "/" + snapshotName;
            long start = System.currentTimeMillis();
            session.getWorkspace().copy(packageNode.getPath(), newName);
            GuvnorEmulator.this.printDetail("Time taken for snap: " + (System.currentTimeMillis() - start));
        }

        public Node loadPackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            return snapshotArea.getNode(packageName).getNode(snapshotName);
        }

        public void buildPackage(Session session, String packageName) throws RepositoryException, IOException {
            List<Node> assets = this.listAssets(session, packageName, "function");
            long time = System.currentTimeMillis();
            for (Node assetNode : assets) {
                if (this.isBinary(assetNode)) {
                    this.readBinaryContentAttachment(assetNode);
                    continue;
                }
                if (!assetNode.hasProperty(CONTENT_PROPERTY_NAME)) continue;
                Property data = assetNode.getProperty(CONTENT_PROPERTY_NAME);
                data.getValue().getString();
            }
            List<Node> drls = this.listAssets(session, packageName, "drl");
            for (Node drlNode : drls) {
                if (this.isArchived(drlNode)) continue;
                this.readBinaryContentAttachment(drlNode);
            }
            List<Node> allAssets = this.getPackageAssets(session, packageName);
            for (Node nonDrlNode : allAssets) {
                if ("drl".equals(this.getAssetFormat(nonDrlNode)) || this.isArchived(nonDrlNode)) continue;
                this.readBinaryContentAttachment(nonDrlNode);
            }
            long taken = System.currentTimeMillis() - time;
            GuvnorEmulator.this.printDetail("Package build time is: " + taken);
        }

        public List<Node> listAssets(Session session, String packageName, String format) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            String packagePath = packageNode.getPath();
            String sql = "SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '" + packagePath + "/" + ASSET_FOLDER_NAME + "[%]/%'" + " AND drools:format = '" + format + "' AND drools:archive = 'false' ORDER BY drools:title";
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            long time = System.currentTimeMillis();
            QueryResult res = q.execute();
            NodeIterator it = res.getNodes();
            long taken = System.currentTimeMillis() - time;
            GuvnorEmulator.this.printDetail("Query execution time is: " + taken);
            return this.nodesFrom(it);
        }

        public List<Node> getPackageAssets(Session session, String packageName) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            NodeIterator iter = packageNode.getNode(ASSET_FOLDER_NAME).getNodes();
            return this.nodesFrom(iter);
        }

        protected List<Node> nodesFrom(NodeIterator iter) {
            ArrayList<Node> result = new ArrayList<Node>();
            while (iter.hasNext()) {
                result.add(iter.nextNode());
            }
            return result;
        }
    }

    protected class BuildPackage
    extends DroolsOperation {
        private String packageName;

        public BuildPackage(String packageName) {
            this.packageName = packageName;
        }

        public void run(Session s) throws RepositoryException, IOException {
            this.buildPackage(s, this.packageName);
            this.getPackageAssets(s, this.packageName);
        }
    }

    protected class LoadPackageSnapshot
    extends DroolsOperation {
        private String packageName;
        private String snapshotName;

        public LoadPackageSnapshot(String packageName, String snapshotName) {
            this.packageName = packageName;
            this.snapshotName = snapshotName;
        }

        public void run(Session s) throws RepositoryException {
            this.loadPackageSnapshot(s, this.packageName, this.snapshotName);
        }
    }

    protected class CreatePackageSnapshot
    extends DroolsOperation {
        private String packageName;
        private String snapshotName;
        private String comment;

        public CreatePackageSnapshot(String packageName, String snapshotName, String comment) {
            this.packageName = packageName;
            this.snapshotName = snapshotName;
            this.comment = comment;
        }

        public void run(Session s) throws RepositoryException {
            this.createPackageSnapshot(s, this.packageName, this.snapshotName);
            Node pkgItem = this.loadPackageSnapshot(s, this.packageName, this.snapshotName);
            if (this.comment != null) {
                this.updateCheckinComment(pkgItem, this.comment);
            }
            s.save();
        }
    }

    protected class PrintVersionHistory
    extends DroolsOperation {
        private String path;

        public PrintVersionHistory(JcrTools tools, String path) {
            super(tools);
            this.path = path;
        }

        public void run(Session s) throws RepositoryException {
            Node assetNode = s.getNode(this.path);
            VersionManager vmgr = s.getWorkspace().getVersionManager();
            VersionHistory versionHistory = vmgr.getVersionHistory(this.path);
            if (this.tools.isDebug()) {
                this.tools.print((Object)"");
                this.tools.print((Object)"Node with history:");
                this.tools.printNode(assetNode);
                this.tools.printSubgraph((Node)versionHistory);
            }
        }
    }

    protected class ModifyAsset
    extends DroolsOperation {
        private String path;

        public ModifyAsset(String path) {
            this.path = path;
        }

        public void run(Session s) throws RepositoryException {
            Node assetNode = s.getNode(this.path);
            this.checkout(assetNode);
            this.updateDescription(assetNode, "This is the new description");
            this.checkin(assetNode, "First change");
        }
    }

    protected class ViewContent
    extends DroolsOperation {
        private String path;
        private String content;

        public ViewContent(String path) {
            this.path = path;
        }

        public void run(Session s) throws Exception {
            Node node = s.getNode(this.path);
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            this.content = this.readBinaryContentAttachment(node);
        }

        public String getContent() {
            return this.content;
        }
    }

    protected class VerifyContent
    extends JcrTools.BasicOperation {
        public VerifyContent() {
            super(null);
        }

        public void run(Session s) throws Exception {
            this.assertNode(s, "/drools:repository", "nt:folder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area", "nt:folder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area/mortgages", "drools:packageNodeType", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area/mortgages/assets", "drools:versionableAssetFolder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:state_area/Draft", "drools:stateNodeType", new String[0]);
            this.assertNode(s, "/drools:repository/drools:tag_area/Home Mortgage", "drools:categoryNodeType", new String[0]);
        }
    }
}

