/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeSingleUseTest;
import org.modeshape.test.integration.performance.GuvnorEmulator;

public class JcrRepositoryPerformanceTest
extends ModeShapeSingleUseTest {
    private static final int NUMBER_OF_COPIES = 150;
    private GuvnorEmulator guvnor;

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    public void shouldSimulateGuvnorUsageAgainstRepositoryWithInMemoryStore() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.guvnor.verifyContent();
        this.guvnor.simulateGuvnorUsage(5);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    public void shouldSimulateGuvnorUsageAgainstRepositoryWithJpaStore() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.guvnor.verifyContent();
        this.guvnor.simulateGuvnorUsage(30);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1113"})
    public void shouldHaveImportContentAvailableAfterRestart() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.printSubgraph(this.assertNode("/drools:repository"));
        this.guvnor.verifyContent();
        JcrRepositoryPerformanceTest.stopEngine();
        this.startEngineUsing("config/configRepositoryForDroolsJpaNoNodeTypes.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.printSubgraph(this.assertNode("/drools:repository"));
        this.guvnor.verifyContent();
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsNewContent() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 0;
        for (int i = 0; i != 3; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.guvnor.verifyContent();
        }
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsNewContentUsingJpa() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 0;
        for (int i = 0; i != 3; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.guvnor.verifyContent();
        }
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsReplacedContent() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        for (int i = 0; i != 2; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.guvnor.verifyContent();
        }
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsReplacedContentUsingJpa() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        for (int i = 0; i != 2; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.guvnor.verifyContent();
        }
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportOnceAndSimulateGuvnorUsage() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportOnceAndSimulateGuvnorUsageUsingJpa() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportAndSimulateGuvnorUsageTwice() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.simulateGuvnorUsage(2);
        this.guvnor.printVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
        this.session().refresh(false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.printVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
        this.guvnor.simulateGuvnorUsage(1);
        this.guvnor.printVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportAndSimulateGuvnorUsageTwiceUsingJpa() throws Exception {
        this.startEngineUsing("config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.guvnor = new GuvnorEmulator(this.repository(), 150, false);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.printVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
        this.session().refresh(false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.guvnor.verifyContent();
        this.guvnor.printVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
        this.guvnor.simulateGuvnorUsage(1);
    }
}

