/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.io.File;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;
import org.modeshape.test.integration.sequencer.CndSequencerIntegrationTest;
import org.modeshape.test.integration.sequencer.TeiidSequencerIntegrationTest;
import org.modeshape.test.integration.sequencer.XmlSequencerIntegrationTest;
import org.modeshape.test.integration.sequencer.ZipSequencerIntegrationTest;

public class JavaSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForJavaSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("java", "http://www.modeshape.org/java/1.0");
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("class", "http://www.modeshape.org/sequencer/javaclass/1.0");
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldSequenceJavaSourceFile() throws Exception {
        File file = new File("src/test/java/org/modeshape/test/integration/ClusteringTest.java");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        this.uploadFile(file.toURI().toURL(), "/files/");
        String path = "/sequenced/java/ClusteringTest.java";
        Node java = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        this.printSubgraph(java);
        this.assertNode(path + "/ClusteringTest", "class:class", new String[]{"mode:derived"});
        this.assertNode(path + "/ClusteringTest/class:constructors", "class:constructors", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods", "class:methods", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/beforeAll()", "class:method", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/beforeAll()/class:annotations", "class:annotations", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/beforeAll()/class:annotations/BeforeClass", "class:annotation", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/afterAll()", "class:method", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/afterAll()/class:annotations", "class:annotations", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/afterAll()/class:annotations/AfterClass", "class:annotation", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldAllowMultipleEnginesToAccessSameDatabase()", "class:method", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldAllowMultipleEnginesToAccessSameDatabase()/class:annotations", "class:annotations", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldAllowMultipleEnginesToAccessSameDatabase()/class:annotations/Test", "class:annotation", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldReceiveNotificationsFromAllEnginesWhenChangingContentInOne()", "class:method", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldReceiveNotificationsFromAllEnginesWhenChangingContentInOne()/class:annotations", "class:annotations", new String[0]);
        this.assertNode(path + "/ClusteringTest/class:methods/shouldReceiveNotificationsFromAllEnginesWhenChangingContentInOne()/class:annotations/Test", "class:annotation", new String[0]);
        this.printQuery("SELECT * FROM [class:class]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:constructors]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:methods]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:method]", 14L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:annotations]", 21L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:annotation]", 10L, new ModeShapeUnitTest.Variable[0]);
    }

    protected void assertSequenceable(Class<?> javaClass) throws Exception {
        String className = javaClass.getCanonicalName();
        String sourceName = className.replaceAll("[.]", "/") + ".java";
        String typeName = javaClass.getSimpleName();
        String packageName = javaClass.getPackage().getName().replaceAll("[.]", "/");
        File file = new File("src/test/java/" + sourceName);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        this.uploadFile(file.toURI().toURL(), "/files/" + packageName);
        String path = "/sequenced/java/" + sourceName;
        Node java = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        this.printSubgraph(java);
        this.assertNode(path + "/" + typeName, "class:class", new String[]{"mode:derived"});
        this.assertNode(path + "/" + typeName + "/class:constructors", "class:constructors", new String[0]);
        this.assertNode(path + "/" + typeName + "/class:methods", "class:methods", new String[0]);
        this.printQuery("SELECT * FROM [class:class]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:constructors]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:methods]", 1L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceJavaSource1FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(AbstractSequencerTest.class);
    }

    @Test
    public void shouldSequenceJavaSource2FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(CndSequencerIntegrationTest.class);
    }

    @Test
    public void shouldSequenceJavaSource3FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(JavaSequencerIntegrationTest.class);
    }

    @Test
    public void shouldSequenceJavaSource4FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(TeiidSequencerIntegrationTest.class);
    }

    @Test
    public void shouldSequenceJavaSource5FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(XmlSequencerIntegrationTest.class);
    }

    @Test
    public void shouldSequenceJavaSource6FileBelowSequencedPath() throws Exception {
        this.assertSequenceable(ZipSequencerIntegrationTest.class);
    }

    @Test
    public void shouldSequenceJavaSourceFileBelowSequencedPath2() throws Exception {
        File file = new File("src/test/java/org/modeshape/test/integration/sequencer/SequencerTest.java");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        this.uploadFile(file.toURI().toURL(), "/files/org/modeshape/test/integration/sequencer");
        String path = "/sequenced/java/org/modeshape/test/integration/sequencer/SequencerTest.java";
        Node java = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        this.printSubgraph(java);
        this.assertNode(path + "/SequencerTest", "class:class", new String[]{"mode:derived"});
        this.assertNode(path + "/SequencerTest/class:constructors", "class:constructors", new String[0]);
        this.assertNode(path + "/SequencerTest/class:methods", "class:methods", new String[0]);
        this.printQuery("SELECT * FROM [class:class]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:constructors]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [class:methods]", 1L, new ModeShapeUnitTest.Variable[0]);
    }
}

