/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.derby;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.ddl.AbstractDdlIntegrationTest;

public class DerbyDdlSequencerIntegrationTest
extends AbstractDdlIntegrationTest {
    private static final String RESOURCE_FOLDER = "org/modeshape/test/integration/sequencer/ddl//dialect/derby/";

    @Override
    protected void addCustomConfiguration() {
        this.config.repository("ddlRepository").addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/dialect/derby/DerbyDdl.cnd")).registerNamespace("derbyddl", "http://www.modeshape.org/ddl/derby/1.0");
    }

    @Test
    public void shouldSequenceDerbyDdlFile() throws Exception {
        this.uploadFile(RESOURCE_FOLDER, "derby_test_statements.ddl");
        this.waitUntilSequencedNodesIs(1);
        Node ddlsNode = this.getStatementsContainer();
        NodeIterator iter = ddlsNode.getNodes();
        while (iter.hasNext()) {
            Node ddlNode = iter.nextNode();
            long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
            Assert.assertEquals((long)numStatements, (long)64L);
            this.verifyNode(ddlNode, "HOTELAVAILABILITY", "ddl:startLineNumber");
            this.verifyNode(ddlNode, "SAMP.DEPARTMENT", "ddl:expression");
            this.verifyNode(ddlNode, "HOTEL_ID", "ddl:datatypeName");
            this.verifyNode(ddlNode, "CITIES", "ddl:startLineNumber");
            this.verifyNode(ddlNode, "PROPERTY_FILE_READER", "ddl:startLineNumber", 71);
            this.verifyNodeTypes(ddlNode, "PROPERTY_FILE_READER", "derbyddl:createFunctionStatement", "ddl:creatable", "derbyddl:functionOperand");
            this.verifyNode(ddlNode, "KEY_COL", "ddl:datatypeName", "VARCHAR");
            Node functionNode = this.findNode(ddlNode, "TO_DEGREES");
            Assert.assertNotNull((Object)functionNode);
            this.verifySimpleStringProperty(functionNode, "derbyddl:parameterStyle", "PARAMETER STYLE JAVA");
            Node indexNode = this.findNode(ddlNode, "IXSALE", "derbyddl:createIndexStatement");
            Assert.assertNotNull((Object)indexNode);
            this.verifySimpleStringProperty(indexNode, "derbyddl:tableName", "SAMP.SALES");
            Node colRefNode = this.findNode(indexNode, "SALES");
            Assert.assertNotNull((Object)colRefNode);
            colRefNode = this.findNode(ddlNode, "SALES", "derbyddl:indexColumnReference");
            Assert.assertNotNull((Object)colRefNode);
            this.verifyNodeTypes(colRefNode, "SALES", "derbyddl:indexColumnReference", "ddl:columnReference", "ddl:referenceOperand");
            Node ttNode = this.findNode(ddlNode, "SESSION.t1", "derbyddl:declareGlobalTemporaryTableStatement");
            Assert.assertNotNull((Object)ttNode);
            Node colNode = this.findNode(ttNode, "c11");
            Assert.assertNotNull((Object)colNode);
            this.verifySimpleStringProperty(colNode, "ddl:datatypeName", "int");
            Node lockNode = this.findNode(ddlNode, "FlightAvailability", "derbyddl:lockTableStatement");
            Assert.assertNotNull((Object)lockNode);
            Node optionNode = this.findNode(lockNode, "lockMode");
            Assert.assertNotNull((Object)optionNode);
            this.verifySimpleStringProperty(optionNode, "ddl:value", "EXCLUSIVE");
            Node renameTableNode = this.findNode(ddlNode, "SAMP.EMP_ACT", "derbyddl:renameTableStatement");
            Assert.assertNotNull((Object)renameTableNode);
            this.verifySimpleStringProperty(renameTableNode, "ddl:newName", "EMPLOYEE_ACT");
            Node synonymNode = this.findNode(ddlNode, "SAMP.T1", "derbyddl:createSynonymStatement");
            Assert.assertNotNull((Object)synonymNode);
            this.verifySimpleStringProperty(synonymNode, "derbyddl:tableName", "SAMP.TABLEWITHLONGNAME");
            Node triggerNode = this.findNode(ddlNode, "FLIGHTSDELETE3", "derbyddl:createTriggerStatement");
            Assert.assertNotNull((Object)triggerNode);
            this.verifySimpleStringProperty(triggerNode, "derbyddl:tableName", "FLIGHTS");
            triggerNode = this.findNode(ddlNode, "t1", "derbyddl:createTriggerStatement");
            Assert.assertNotNull((Object)triggerNode);
            this.verifySimpleStringProperty(triggerNode, "derbyddl:tableName", "x");
            optionNode = this.findNode(triggerNode, "forEach");
            Assert.assertNotNull((Object)optionNode);
            this.verifySimpleStringProperty(optionNode, "ddl:value", "FOR EACH ROW");
            optionNode = this.findNode(triggerNode, "eventType");
            Assert.assertNotNull((Object)optionNode);
            this.verifySimpleStringProperty(optionNode, "ddl:value", "UPDATE");
            Node grantNode = this.findNode(ddlNode, "p", "derbyddl:grantOnProcedureStatement");
            Assert.assertNotNull((Object)grantNode);
            grantNode = this.findNode(ddlNode, "grantRoles", "derbyddl:grantRolesStatement");
            Assert.assertNotNull((Object)grantNode);
            Node roleNode = this.findNode(grantNode, "george", "ddl:grantee");
            Assert.assertNotNull((Object)roleNode);
        }
    }
}

