/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.filesystem;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrRepository;

public class FileSystemRepositoryTest {
    private static final String TEST_REPOSITORY = "Test Repository Source";
    private static final String TEST_WORKSPACE = "defaultWorkspace";
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static List<Session> sessions;
    private boolean print = false;
    private Stopwatch sw;

    @BeforeClass
    public static void beforeAll() throws Exception {
        configuration = new JcrConfiguration();
        configuration.loadFrom("src/test/resources/tck/filesystem/configRepository.xml");
        engine = configuration.build();
        try {
            engine.start();
        }
        catch (RuntimeException e) {
            System.err.println("There were problems starting the engine:");
            for (Problem problem : engine.getProblems()) {
                System.err.println(problem);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() throws Exception {
        for (Session session : sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        sessions.clear();
        if (engine != null) {
            try {
                engine.shutdown();
            }
            finally {
                engine = null;
            }
        }
    }

    @Before
    public void beforeEach() {
        this.sw = new Stopwatch();
        this.print = false;
    }

    @Test
    public void shouldHaveContentInWorkspace() throws Exception {
        Session session = this.sessionFrom(engine);
        Node node1 = session.getRootNode().getNode("testroot/node1");
        Assert.assertThat((Object)node1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node1.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:file"));
        Node node1Content = node1.getNode(this.stringFrom(JcrLexicon.CONTENT));
        Assert.assertThat((Object)node1Content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node1Content.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)this.stringFrom(JcrNtLexicon.RESOURCE)));
    }

    @Test
    public void shouldAllowNavigationOfAllContent() throws Exception {
        Session session = this.sessionFrom(engine);
        Node root = session.getRootNode();
        Node node1 = root.getNode("testroot/node1");
        Node node2 = root.getNode("testroot/yetAnotherNode");
        Assert.assertThat((Object)node1.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:file"));
        Assert.assertThat((Object)node2.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:file"));
    }

    @Test
    public void shouldAllowReadingSingleDirectory() throws Exception {
        Session session = this.sessionFrom(engine);
        session.getRootNode();
        Node testroot = session.getNode("/testroot");
        this.sw.start();
        Node folder1 = testroot.getNode("folder1");
        this.sw.stop();
        if (this.print) {
            System.out.println(this.sw);
        }
        Assert.assertThat((Object)folder1.getName(), (Matcher)Is.is((Object)"folder1"));
        Assert.assertThat((Object)folder1.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        this.sw.reset();
        this.sw.start();
        Node folder1a = testroot.getNode("folder1");
        this.sw.stop();
        if (this.print) {
            System.out.println(this.sw);
        }
        Assert.assertThat((Object)folder1a.getName(), (Matcher)Is.is((Object)"folder1"));
    }

    @Test
    public void shouldFindAllModeResourceNodesUsingJcrSql2Query() throws Exception {
        Session session = this.sessionFrom(engine);
        String sql = "SELECT * FROM [mode:resource]";
        Query query = session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        QueryResult result = query.execute();
        if (this.print) {
            System.out.println(result);
        }
    }

    @Test
    public void shouldFindAllNtFileNodesUsingJcrSql2Query() throws Exception {
        Session session = this.sessionFrom(engine);
        String sql = "SELECT * FROM [nt:file]";
        Query query = session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        QueryResult result = query.execute();
        if (this.print) {
            System.out.println(result);
        }
    }

    @Test
    public void shouldFindModeResourceNodesWithAnyPropertyContainingStringUsingJcrSql2Query() throws Exception {
        Session session = this.sessionFrom(engine);
        String sql = "SELECT * FROM [mode:resource] WHERE CONTAINS(*,'food')";
        Query query = session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        QueryResult result = query.execute();
        if (this.print) {
            System.out.println(result);
        }
        RowIterator rowIter = result.getRows();
        while (rowIter.hasNext()) {
            Row row = rowIter.nextRow();
            double score = row.getScore();
            Assert.assertThat((Object)(score > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldFindModeResourceNodesContainingStringUsingJcrSql2Query() throws Exception {
        Session session = this.sessionFrom(engine);
        String sql = "SELECT * FROM [mode:resource] WHERE CONTAINS([jcr:data],'food')";
        Query query = session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        QueryResult result = query.execute();
        if (this.print) {
            System.out.println(result);
        }
        RowIterator rowIter = result.getRows();
        while (rowIter.hasNext()) {
            Row row = rowIter.nextRow();
            double score = row.getScore();
            Assert.assertThat((Object)(score > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        }
    }

    protected Session sessionFrom(JcrEngine engine) throws RepositoryException {
        JcrRepository repository = engine.getRepository(TEST_REPOSITORY);
        Session session = repository.login(TEST_WORKSPACE);
        sessions.add(session);
        return session;
    }

    protected String stringFrom(Object object) {
        return (String)engine.getExecutionContext().getValueFactories().getStringFactory().create(object);
    }

    static {
        sessions = new ArrayList<Session>();
    }
}

