/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.sequencer.SequencingService;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public abstract class AbstractDdlIntegrationTest {
    protected static final String DDL_TEST_RESOURCE_ROOT_FOLDER = "org/modeshape/test/integration/sequencer/ddl/";
    protected static final String DEFAULT_REPOSITORY_NAME = "ddlRepository";
    protected static final String DEFAULT_DDL_SEQUENCER = "DDL Sequencer";
    private static final String DEFAULT_WORKSPACE_NAME = "default";
    private static final String ROOT_PATH = "/a/b/";
    protected Session session;
    protected JcrEngine engine;
    protected JcrConfiguration config;
    protected boolean print = false;
    private JcrTools tools;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.tools = new JcrTools();
        this.createDefaultConfig();
        this.startEngine();
    }

    private JcrConfiguration createDefaultConfig() {
        String repositorySource = "ddlRepositorySource";
        this.config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", DEFAULT_WORKSPACE_NAME);
        this.config.repository(DEFAULT_REPOSITORY_NAME).setSource(repositorySource).addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).registerNamespace("ddl", "http://www.modeshape.org/ddl/1.0");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)this.config.sequencer(DEFAULT_DDL_SEQUENCER).usingClass("org.modeshape.sequencer.ddl.DdlSequencer").loadedFromClasspath()).setDescription("Sequences DDL files to extract individual statements and accompanying statement properties and values")).sequencingFrom("(//(*.(ddl)[*]))/jcr:content[@jcr:data]").andOutputtingTo("/ddls/$1");
        this.addCustomConfiguration();
        this.config.save();
        return this.config;
    }

    protected void startEngine() throws RepositoryException {
        this.engine = this.config.build();
        this.engine.start();
        this.session = this.engine.getRepository(DEFAULT_REPOSITORY_NAME).login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()), DEFAULT_WORKSPACE_NAME);
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    protected void addCustomConfiguration() {
    }

    protected URL getUrl(String urlStr) {
        return this.getClass().getClassLoader().getResource(urlStr);
    }

    protected void uploadFile(String folder, String fileName) throws RepositoryException, IOException {
        URL url = this.getUrl(folder + fileName);
        this.uploadFile(url);
    }

    private void uploadFile(URL url) throws RepositoryException, IOException {
        String filename = url.getPath().replaceAll("([^/]*/)*", "");
        String nodePath = ROOT_PATH + filename;
        this.tools.uploadFile(this.session, nodePath, url);
        this.session.save();
    }

    private SequencingService.Statistics getStatistics() {
        return this.engine.getSequencingService().getStatistics();
    }

    protected void waitUntilSequencedNodesIs(int totalNumberOfNodesSequenced) throws InterruptedException {
        this.waitUntilSequencedNodesIs(totalNumberOfNodesSequenced, 5);
    }

    private void waitUntilSequencedNodesIs(int totalNumberOfNodesSequenced, int numberOfSeconds) throws InterruptedException {
        long numFound = 0L;
        int numberOfMillis = numberOfSeconds * 1000;
        int numberOfIterations = numberOfMillis / 100;
        for (int i = 0; i != numberOfIterations; ++i) {
            numFound = this.getStatistics().getNumberOfNodesSequenced();
            if (numFound >= (long)totalNumberOfNodesSequenced) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)("Expected to find " + totalNumberOfNodesSequenced + " nodes sequenced, but found " + numFound));
    }

    protected void verifyChildNode(Node parentNode, String childNodeName, String propName, String expectedValue) throws Exception {
        Node childNode = null;
        NodeIterator iter = parentNode.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (!nextNode.getName().equals(childNodeName)) continue;
            childNode = nextNode;
            break;
        }
        if (childNode != null) {
            Assert.assertThat((Object)childNode.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(childNode, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + childNodeName + " not found"));
        }
    }

    protected void verifyNode(Node topNode, String name, String propName) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    protected void verifySimpleStringProperty(Node node, String propName, String expectedValue) throws Exception {
        Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
        this.verifySingleValueProperty(node, propName, expectedValue);
    }

    protected void verifyNode(Node topNode, String name, String propName, String expectedValue) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(node, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    protected void verifyNode(Node topNode, String name, String propName, int expectedValue) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(node, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    private Value value(String value) throws Exception {
        return this.session.getValueFactory().createValue(value);
    }

    protected void verifySingleValueProperty(Node node, String propNameStr, String expectedValue) throws Exception {
        if (node == null) {
            return;
        }
        Value expValue = this.value(expectedValue);
        Property prop = node.getProperty(propNameStr);
        if (prop.getDefinition().isMultiple()) {
            Value[] values;
            boolean hasValue = false;
            for (Value val : values = prop.getValues()) {
                if (!val.equals(expValue)) continue;
                hasValue = true;
            }
            Assert.assertThat((Object)hasValue, (Matcher)Is.is((Object)true));
        } else {
            Value actualValue = prop.getValue();
            Assert.assertThat((Object)expValue, (Matcher)Is.is((Object)actualValue));
        }
    }

    protected void verifySingleValueProperty(Node node, String propNameStr, int expectedValue) throws Exception {
        Property prop = node.getProperty(propNameStr);
        Value expValue = this.session.getValueFactory().createValue((long)expectedValue);
        Value actualValue = prop.getValue();
        Assert.assertThat((Object)expValue, (Matcher)Is.is((Object)actualValue));
    }

    protected void verifyMixin(Node topNode, String nodeName, String nodeType) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            this.verifyMixin(node, nodeType);
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    protected boolean hasMixin(Node node, String nodeType) throws Exception {
        for (NodeType mixin : node.getMixinNodeTypes()) {
            String mixinName = mixin.getName();
            if (!mixinName.equals(nodeType)) continue;
            return true;
        }
        return false;
    }

    protected void verifyMixin(Node node, String nodeType) throws Exception {
        boolean foundMixin = this.hasMixin(node, nodeType);
        Assert.assertThat((Object)foundMixin, (Matcher)Is.is((Object)true));
    }

    protected void verifyNodeType(Node topNode, String nodeName, String nodeTypeName) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            Assert.assertThat((Object)node.isNodeType(nodeTypeName), (Matcher)Is.is((Object)true));
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    protected void verifyNodeTypes(Node topNode, String nodeName, String nodeTypeName, String ... moreNodeTypeNames) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            Assert.assertThat((Object)node.isNodeType(nodeTypeName), (Matcher)Is.is((Object)true));
            for (String nextTypeName : moreNodeTypeNames) {
                Assert.assertThat((Object)node.isNodeType(nextTypeName), (Matcher)Is.is((Object)true));
            }
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    protected Node findNode(Node node, String name) throws Exception {
        if (node.getName().equals(name)) {
            return node;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (nextNode.getName().equals(name)) {
                return nextNode;
            }
            Node someNode = this.findNode(nextNode, name);
            if (someNode == null) continue;
            return someNode;
        }
        return null;
    }

    protected Node findNode(Node node, String name, String type) throws Exception {
        if (node.getName().equals(name) && node.isNodeType(type)) {
            return node;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (nextNode.getName().equals(name) && nextNode.isNodeType(type)) {
                return nextNode;
            }
            Node someNode = this.findNode(nextNode, name, type);
            if (someNode == null) continue;
            return someNode;
        }
        return null;
    }

    protected Node assertNode(Node node, String name, String type) throws Exception {
        Node existingNode = this.findNode(node, name, type);
        Assert.assertNotNull((Object)node);
        return existingNode;
    }

    protected void printSubgraph(Node node) throws RepositoryException {
        this.printSubgraph(node, Integer.MAX_VALUE);
    }

    protected void printSubgraph(Node node, int maxDepth) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), maxDepth);
    }

    protected void printNode(Node node) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), 1);
    }

    private void printSubgraph(Node node, String lead, int depthOfSubgraph, int maxDepthOfSubgraph) throws RepositoryException {
        if (!this.print) {
            return;
        }
        int currentDepth = node.getDepth() - depthOfSubgraph + 1;
        if (currentDepth > maxDepthOfSubgraph) {
            return;
        }
        if (lead == null) {
            lead = "";
        }
        String nodeLead = lead + StringUtil.createString((char)' ', (int)((currentDepth - 1) * 2));
        StringBuilder sb = new StringBuilder();
        sb.append(nodeLead);
        if (node.getDepth() == 0) {
            sb.append("/");
        } else {
            sb.append(node.getName());
            if (node.getIndex() != 1) {
                sb.append('[').append(node.getIndex()).append(']');
            }
        }
        sb.append(" jcr:primaryType=" + node.getPrimaryNodeType().getName());
        boolean referenceable = false;
        if (node.getMixinNodeTypes().length != 0) {
            sb.append(" jcr:mixinTypes=[");
            boolean first = true;
            for (NodeType mixin : node.getMixinNodeTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(mixin.getName());
                if (!mixin.getName().equals("mix:referenceable")) continue;
                referenceable = true;
            }
            sb.append(']');
        }
        if (referenceable) {
            sb.append(" jcr:uuid=" + node.getIdentifier());
        }
        System.out.println(sb);
        LinkedList<String> propertyNames = new LinkedList<String>();
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String name = property.getName();
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes") || name.equals("jcr:uuid")) continue;
            propertyNames.add(property.getName());
        }
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            boolean binary;
            Property property = node.getProperty(propertyName);
            sb = new StringBuilder();
            sb.append(nodeLead).append("  - ").append(propertyName).append('=');
            boolean bl = binary = property.getType() == 2;
            if (property.isMultiple()) {
                sb.append('[');
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    if (binary) {
                        sb.append(value.getBinary());
                        continue;
                    }
                    sb.append(value.getString());
                }
                sb.append(']');
            } else {
                Value value = property.getValue();
                if (binary) {
                    sb.append(value.getBinary());
                } else {
                    sb.append(value.getString());
                }
            }
            System.out.println(sb);
        }
        if (currentDepth < maxDepthOfSubgraph) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                this.printSubgraph(child, lead, depthOfSubgraph, maxDepthOfSubgraph);
            }
        }
    }

    protected Node getStatementsContainer() throws RepositoryException {
        Node statementsContainer = this.session.getRootNode().getNode("ddls/a/b/");
        AbstractSequencerTest.SequencedNodeValidator.validateSequencedNodeType(statementsContainer);
        return statementsContainer;
    }
}

