/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.rhq.plugin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.modeshape.jboss.managed.ManagedEngine;
import org.modeshape.rhq.plugin.ConnectorComponent;
import org.modeshape.rhq.plugin.EngineComponent;
import org.modeshape.rhq.plugin.util.ModeShapeManagementView;
import org.modeshape.rhq.plugin.util.ProfileServiceUtil;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

public class ConnectorDiscoveryComponent
implements ResourceDiscoveryComponent<ConnectorComponent> {
    private final Log log = LogFactory.getLog((String)"org.modeshape");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        MetaValue[] mvConnectorArray;
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ManagedComponent mc = ProfileServiceUtil.getManagedEngine(((EngineComponent)discoveryContext.getParentResourceComponent()).getConnection());
        String operation = "getConnectors";
        MetaValue connectors = ModeShapeManagementView.executeManagedOperation(mc, operation, new MetaValue[]{null});
        if (connectors == null) {
            return discoveredResources;
        }
        for (MetaValue value : mvConnectorArray = ((CollectionValueSupport)connectors).getElements()) {
            CompositeValueSupport cvs = (CompositeValueSupport)value;
            String name = ProfileServiceUtil.stringValue(cvs.get("name"));
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), name, name, null, "A specification of a resource that can be used to access or store repository information", discoveryContext.getDefaultPluginConfiguration(), null);
            Configuration c = detail.getPluginConfiguration();
            operation = "getProperties";
            EnumValueSupport enumVs = new EnumValueSupport(new EnumMetaType((Enum[])ManagedEngine.Component.values()), (Enum)ManagedEngine.Component.CONNECTOR);
            MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)name)), enumVs};
            MetaValue properties = ModeShapeManagementView.executeManagedOperation(mc, operation, args);
            MetaValue[] propertyArray = ((CollectionValueSupport)properties).getElements();
            PropertyList connectorlist = new PropertyList("connectorPropertyList");
            c.put((Property)connectorlist);
            this.loadProperties(propertyArray, connectorlist);
            enumVs = new EnumValueSupport(new EnumMetaType((Enum[])ManagedEngine.Component.values()), (Enum)ManagedEngine.Component.CONNECTIONPOOL);
            args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)name)), enumVs};
            properties = ModeShapeManagementView.executeManagedOperation(mc, operation, args);
            propertyArray = ((CollectionValueSupport)properties).getElements();
            PropertyList connectionPoollist = new PropertyList("connectionpoolPropertyList");
            c.put((Property)connectionPoollist);
            this.loadProperties(propertyArray, connectionPoollist);
            detail.setPluginConfiguration(c);
            discoveredResources.add(detail);
            this.log.debug((Object)("Discovered ModeShape repositories: " + mc.getName()));
        }
        return discoveredResources;
    }

    private void loadProperties(MetaValue[] propertyArray, PropertyList list) throws Exception {
        for (MetaValue property : propertyArray) {
            CompositeValueSupport proCvs = (CompositeValueSupport)property;
            PropertyMap propMap = new PropertyMap("map");
            propMap.put((Property)new PropertySimple("label", (Object)ProfileServiceUtil.stringValue(proCvs.get("label"))));
            propMap.put((Property)new PropertySimple("value", (Object)ProfileServiceUtil.stringValue(proCvs.get("value"))));
            propMap.put((Property)new PropertySimple("description", (Object)ProfileServiceUtil.stringValue(proCvs.get("description"))));
            list.add((Property)propMap);
        }
    }
}

